# -*- coding: utf-8 -*-
from datetime import timedelta,datetime
from packages.checkworkMethods import isworkday,updatedic,getiskq
import tools

class CheckWork(object):

    #总的获取考勤最终数据的方法
    def get_kq_count(self,startdate,enddate,kqdatalist):
        '''获取异常考勤统计

               参数说明：
               startdate:统计开始的时间,时间格式为2017-05-01
               enddate: 统计截止时间,时间格式为2017-05-31
               kqdatalist: 需传入已打开记录的list

               返回值:异常考勤数据字符串

               示例：
               |  ${resultstr}=  | get_kq_count | startdate  | enddate | kqdatalist |

        '''
        startdate = datetime.strptime(startdate, '%Y-%m-%d')#把str格式的开始时间格式化成date格式
        nowdate=datetime.today()#今天date
        endddte = datetime.strptime(enddate, '%Y-%m-%d')#把str格式的截止时间格式化成date格式

        if endddte > nowdate:#如果截止时间大于今天,则截止时间设置为今天
            endddte=nowdate

        if startdate<=endddte:#开始时间小于结束时间
            #创建一个考勤模板,默认值为[0,0]
            labledic={}#定义一个空字典
            while startdate < endddte:
                if isworkday(startdate) == 1:  # 如果为非双休日,则append到list
                    labledic[datetime.strftime(startdate,'%Y-%m-%d')]=[0,0]
                startdate = startdate + timedelta(days=1)

            #更新模板数据
            newlabledic=updatedic(labledic,kqdatalist)

            #输出考勤情况字符串
            return getiskq(newlabledic)
        else:
            return '选择的开始时间大于截止时间,请检查!'








#r=['2017-05-02 20:00:51', '2017-05-02 09:11:30', '2017-05-02 08:45:49', '2017-05-02 08:45:32', '2017-05-03 18:28:25', '2017-05-03 09:13:59', '2017-05-04 18:04:12', '2017-05-04 08:57:19', '2017-05-05 18:36:45', '2017-05-05 09:16:10', '2017-05-08 19:37:13', '2017-05-08 09:06:46', '2017-05-09 18:12:31', '2017-05-09 08:49:10', '2017-05-10 18:39:33', '2017-05-10 08:51:58', '2017-05-12 18:13:22', '2017-05-12 09:06:21', '2017-05-15 18:41:12', '2017-05-15 09:05:40', '2017-05-16 08:58:12', '2017-05-17 19:24:11', '2017-05-17 08:36:14', '2017-05-18 18:18:14', '2017-05-18 13:44:50', '2017-05-18 13:44:20', '2017-05-19 18:21:19', '2017-05-19 09:01:22', '2017-05-22 18:57:09', '2017-05-22 09:04:47', '2017-05-23 19:55:57', '2017-05-23 09:20:16', '2017-05-24 18:49:28', '2017-05-24 09:42:17', '2017-05-25 18:42:37', '2017-05-25 09:05:24', '2017-05-26 18:31:13', '2017-05-26 09:01:27', '2017-05-27 18:20:00', '2017-05-31 18:41:41', '2017-05-31 09:03:10']
#r=['2017-05-18 08:20:51','2017-05-18 18:20:51','2017-05-30 08:20:51','2017-05-30 18:20:51','2017-05-11 08:20:51','2017-05-11 18:20:51','2017-05-16 18:20:51','2017-05-01 08:20:51','2017-05-01 18:20:51','2017-05-24 09:10:00','2017-05-27 09:01:51','2017-05-29 18:20:51','2017-05-29 09:01:51','2017-05-02 18:20:51', '2017-05-02 09:11:30', '2017-05-02 08:45:49', '2017-05-02 08:45:32', '2017-05-03 18:28:25', '2017-05-03 08:53:59', '2017-05-04 18:04:12', '2017-05-04 08:57:19', '2017-05-05 18:36:45', '2017-05-05 09:16:10', '2017-05-08 19:37:13', '2017-05-08 09:06:46', '2017-05-09 18:12:31', '2017-05-09 08:49:10', '2017-05-10 18:39:33', '2017-05-10 08:51:58', '2017-05-12 18:13:22', '2017-05-12 09:06:21', '2017-05-15 18:41:12', '2017-05-15 09:05:40', '2017-05-16 08:58:12', '2017-05-17 19:24:11', '2017-05-17 08:36:14', '2017-05-18 18:18:14', '2017-05-18 13:44:50', '2017-05-18 13:44:20', '2017-05-19 18:21:19', '2017-05-19 09:01:22', '2017-05-22 18:57:09', '2017-05-22 09:04:47', '2017-05-23 19:55:57', '2017-05-23 09:20:16', '2017-05-24 18:49:28', '2017-05-24 09:42:17', '2017-05-25 18:42:37', '2017-05-25 09:05:24', '2017-05-26 18:31:13', '2017-05-26 09:01:27', '2017-05-27 18:20:00', '2017-05-31 18:41:41', '2017-05-31 09:03:10']

#test=CheckWork().get_kq_count('2017-05-01','2017-05-31',r)
#b='\r\n'.join(str(a) for a in test)
#print test

#print tools.Tools().send_mail('xwang@innotek-co.com','OA统计',test)

