# pyqt6rc

![GitHub_repo](https://img.shields.io/github/license/domarm-comat/pyqt6rc?style=for-the-badge)

Script to convert resource paths generated by QT6 designer.  
PyQt6 does not provide pyrcc6 script to convert resources.  
In current PyQt6 implementation, files created by pyuic6 scripts using Qt resources has wrong path.   
This script is converting .ui files into .py files and using importlib to fix resource path.

There are multiple solutions to this problem:
* One is to use QtCore.QDir.addSearchPath().  
But still, path generated by designer does not follow pattern "prefix:path".
* Use of [importlib_resources](https://importlib-resources.readthedocs.io/en/latest/), which is third party library.
* Native python3.7+ solution using [importlib](https://docs.python.org/3/library/importlib.html#module-importlib.resources), which is adopted by this script.

# Conversion #

Generated template by pyuic6:
```python
icon = QtGui.QIcon()
icon.addPixmap(QtGui.QPixmap(":/icons/icon1.png"), QtGui.QIcon.Mode.Normal, QtGui.QIcon.State.Off)
```

Generated template by pyqt6rc script:
```python
icon = QtGui.QIcon()
with path("myPackage.resources.icons", "icon1.png") as f_path:
    icon.addPixmap(QtGui.QPixmap(str(f_path)), QtGui.QIcon.Mode.Normal, QtGui.QIcon.State.Off)
```

# Usage examples #

Package structure example
```
myPackage
│   __init__.py    
│
└───resources
|   |   __init__.py
│   │   image1.png
│   │   image2.png
│   │   resources.qrc
|   |   ...
|   |
|   └───icons
│       │   __init__.py
│       │   icon1.png
│       │   icon2.png
│       │   ...
│   
└───templates
    │   template1.ui
    │   template2.ui
```

Convert all .ui files located in templates directory
```shell
pyqt6rc /myPackage/templates -p myPackage
```

Convert template1.ui
```shell
pyqt6rc /myPackage/templates/template1.ui -p myPackage
```

Convert template1.ui and save it in /tmp directory
```shell
pyqt6rc /myPackage/templates/template1.ui -p myPackage -o /tmp
```