# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'ContactChannelTargetInfoArgs',
    'ContactStageArgs',
    'ContactTargetInfoArgs',
    'ContactTargetsArgs',
]

@pulumi.input_type
class ContactChannelTargetInfoArgs:
    def __init__(__self__, *,
                 channel_id: pulumi.Input[str],
                 retry_interval_in_minutes: pulumi.Input[int]):
        """
        Information about the contact channel that SSM Incident Manager uses to engage the contact.
        :param pulumi.Input[str] channel_id: The Amazon Resource Name (ARN) of the contact channel.
        :param pulumi.Input[int] retry_interval_in_minutes: The number of minutes to wait to retry sending engagement in the case the engagement initially fails.
        """
        pulumi.set(__self__, "channel_id", channel_id)
        pulumi.set(__self__, "retry_interval_in_minutes", retry_interval_in_minutes)

    @property
    @pulumi.getter(name="channelId")
    def channel_id(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) of the contact channel.
        """
        return pulumi.get(self, "channel_id")

    @channel_id.setter
    def channel_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "channel_id", value)

    @property
    @pulumi.getter(name="retryIntervalInMinutes")
    def retry_interval_in_minutes(self) -> pulumi.Input[int]:
        """
        The number of minutes to wait to retry sending engagement in the case the engagement initially fails.
        """
        return pulumi.get(self, "retry_interval_in_minutes")

    @retry_interval_in_minutes.setter
    def retry_interval_in_minutes(self, value: pulumi.Input[int]):
        pulumi.set(self, "retry_interval_in_minutes", value)


@pulumi.input_type
class ContactStageArgs:
    def __init__(__self__, *,
                 duration_in_minutes: pulumi.Input[int],
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input['ContactTargetsArgs']]]] = None):
        """
        A set amount of time that an escalation plan or engagement plan engages the specified contacts or contact methods.
        :param pulumi.Input[int] duration_in_minutes: The time to wait until beginning the next stage.
        :param pulumi.Input[Sequence[pulumi.Input['ContactTargetsArgs']]] targets: The contacts or contact methods that the escalation plan or engagement plan is engaging.
        """
        pulumi.set(__self__, "duration_in_minutes", duration_in_minutes)
        if targets is not None:
            pulumi.set(__self__, "targets", targets)

    @property
    @pulumi.getter(name="durationInMinutes")
    def duration_in_minutes(self) -> pulumi.Input[int]:
        """
        The time to wait until beginning the next stage.
        """
        return pulumi.get(self, "duration_in_minutes")

    @duration_in_minutes.setter
    def duration_in_minutes(self, value: pulumi.Input[int]):
        pulumi.set(self, "duration_in_minutes", value)

    @property
    @pulumi.getter
    def targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContactTargetsArgs']]]]:
        """
        The contacts or contact methods that the escalation plan or engagement plan is engaging.
        """
        return pulumi.get(self, "targets")

    @targets.setter
    def targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContactTargetsArgs']]]]):
        pulumi.set(self, "targets", value)


@pulumi.input_type
class ContactTargetInfoArgs:
    def __init__(__self__, *,
                 contact_id: pulumi.Input[str],
                 is_essential: pulumi.Input[bool]):
        """
        The contact that SSM Incident Manager is engaging during an incident.
        :param pulumi.Input[str] contact_id: The Amazon Resource Name (ARN) of the contact.
        :param pulumi.Input[bool] is_essential: A Boolean value determining if the contact's acknowledgement stops the progress of stages in the plan.
        """
        pulumi.set(__self__, "contact_id", contact_id)
        pulumi.set(__self__, "is_essential", is_essential)

    @property
    @pulumi.getter(name="contactId")
    def contact_id(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) of the contact.
        """
        return pulumi.get(self, "contact_id")

    @contact_id.setter
    def contact_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "contact_id", value)

    @property
    @pulumi.getter(name="isEssential")
    def is_essential(self) -> pulumi.Input[bool]:
        """
        A Boolean value determining if the contact's acknowledgement stops the progress of stages in the plan.
        """
        return pulumi.get(self, "is_essential")

    @is_essential.setter
    def is_essential(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_essential", value)


@pulumi.input_type
class ContactTargetsArgs:
    def __init__(__self__, *,
                 channel_target_info: Optional[pulumi.Input['ContactChannelTargetInfoArgs']] = None,
                 contact_target_info: Optional[pulumi.Input['ContactTargetInfoArgs']] = None):
        """
        The contacts or contact methods that the escalation plan or engagement plan is engaging.
        """
        if channel_target_info is not None:
            pulumi.set(__self__, "channel_target_info", channel_target_info)
        if contact_target_info is not None:
            pulumi.set(__self__, "contact_target_info", contact_target_info)

    @property
    @pulumi.getter(name="channelTargetInfo")
    def channel_target_info(self) -> Optional[pulumi.Input['ContactChannelTargetInfoArgs']]:
        return pulumi.get(self, "channel_target_info")

    @channel_target_info.setter
    def channel_target_info(self, value: Optional[pulumi.Input['ContactChannelTargetInfoArgs']]):
        pulumi.set(self, "channel_target_info", value)

    @property
    @pulumi.getter(name="contactTargetInfo")
    def contact_target_info(self) -> Optional[pulumi.Input['ContactTargetInfoArgs']]:
        return pulumi.get(self, "contact_target_info")

    @contact_target_info.setter
    def contact_target_info(self, value: Optional[pulumi.Input['ContactTargetInfoArgs']]):
        pulumi.set(self, "contact_target_info", value)


