# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'GetPublisherResult',
    'AwaitableGetPublisherResult',
    'get_publisher',
    'get_publisher_output',
]

@pulumi.output_type
class GetPublisherResult:
    def __init__(__self__, identity_provider=None, publisher_id=None, publisher_profile=None, publisher_status=None):
        if identity_provider and not isinstance(identity_provider, str):
            raise TypeError("Expected argument 'identity_provider' to be a str")
        pulumi.set(__self__, "identity_provider", identity_provider)
        if publisher_id and not isinstance(publisher_id, str):
            raise TypeError("Expected argument 'publisher_id' to be a str")
        pulumi.set(__self__, "publisher_id", publisher_id)
        if publisher_profile and not isinstance(publisher_profile, str):
            raise TypeError("Expected argument 'publisher_profile' to be a str")
        pulumi.set(__self__, "publisher_profile", publisher_profile)
        if publisher_status and not isinstance(publisher_status, str):
            raise TypeError("Expected argument 'publisher_status' to be a str")
        pulumi.set(__self__, "publisher_status", publisher_status)

    @property
    @pulumi.getter(name="identityProvider")
    def identity_provider(self) -> Optional['PublisherIdentityProvider']:
        """
        The type of account used as the identity provider when registering this publisher with CloudFormation.
        """
        return pulumi.get(self, "identity_provider")

    @property
    @pulumi.getter(name="publisherId")
    def publisher_id(self) -> Optional[str]:
        """
        The publisher id assigned by CloudFormation for publishing in this region.
        """
        return pulumi.get(self, "publisher_id")

    @property
    @pulumi.getter(name="publisherProfile")
    def publisher_profile(self) -> Optional[str]:
        """
        The URL to the publisher's profile with the identity provider.
        """
        return pulumi.get(self, "publisher_profile")

    @property
    @pulumi.getter(name="publisherStatus")
    def publisher_status(self) -> Optional['PublisherStatus']:
        """
        Whether the publisher is verified.
        """
        return pulumi.get(self, "publisher_status")


class AwaitableGetPublisherResult(GetPublisherResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPublisherResult(
            identity_provider=self.identity_provider,
            publisher_id=self.publisher_id,
            publisher_profile=self.publisher_profile,
            publisher_status=self.publisher_status)


def get_publisher(publisher_id: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPublisherResult:
    """
    Register as a publisher in the CloudFormation Registry.


    :param str publisher_id: The publisher id assigned by CloudFormation for publishing in this region.
    """
    __args__ = dict()
    __args__['publisherId'] = publisher_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws-native:cloudformation:getPublisher', __args__, opts=opts, typ=GetPublisherResult).value

    return AwaitableGetPublisherResult(
        identity_provider=__ret__.identity_provider,
        publisher_id=__ret__.publisher_id,
        publisher_profile=__ret__.publisher_profile,
        publisher_status=__ret__.publisher_status)


@_utilities.lift_output_func(get_publisher)
def get_publisher_output(publisher_id: Optional[pulumi.Input[str]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPublisherResult]:
    """
    Register as a publisher in the CloudFormation Registry.


    :param str publisher_id: The publisher id assigned by CloudFormation for publishing in this region.
    """
    ...
