# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import Any, Callable, Dict, IO, List, Optional, TypeVar, Union, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict

from .. import models as _models
from .._serialization import Serializer
from .._vendor import _format_url_section

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_apps_list_apps_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/apps"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_apps_create_app_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/apps"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_apps_update_app_request(id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/apps/{id}"
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_azure_regions_list_azure_regions_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/azureregions"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_cdf_clusters_list_cdf_clusters_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/cdfclusters"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_cdf_clusters_create_cdf_cluster_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/cdfclusters"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_cdf_clusters_update_cdf_cluster_request(id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/cdfclusters/{id}"
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_countries_list_countries_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/countries"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_customers_list_customers_request(
    *, page_size: int = 100, continuation_token_parameter: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/customers"

    # Construct parameters
    if page_size is not None:
        _params["pageSize"] = _SERIALIZER.query("page_size", page_size, "int")
    if continuation_token_parameter is not None:
        _params["continuationToken"] = _SERIALIZER.query(
            "continuation_token_parameter", continuation_token_parameter, "str"
        )

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_customers_create_customer_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/customers"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_customers_get_customer_request(id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/customers/{id}"
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_customers_update_customer_request(id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/customers/{id}"
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_customers_list_customer_tenants_request(id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/customers/{id}/tenants"
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_customers_create_tenant_request(id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/customers/{id}/tenants"
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_customers_update_tenant_request(id: str, tenant_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/customers/{id}/tenants/{tenantId}"
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, "str"),
        "tenantId": _SERIALIZER.url("tenant_id", tenant_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_customers_get_cdf_config_request(id: str, tenant_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/customers/{id}/tenants/{tenantId}/config"
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, "str"),
        "tenantId": _SERIALIZER.url("tenant_id", tenant_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_customers_update_cdf_config_request(id: str, tenant_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/customers/{id}/tenants/{tenantId}/config"
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, "str"),
        "tenantId": _SERIALIZER.url("tenant_id", tenant_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_customers_list_customer_apps_request(id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/customers/{id}/apps"
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_customers_add_customer_app_request(id: str, app_id: str, **kwargs: Any) -> HttpRequest:
    # Construct URL
    _url = "/customers/{id}/apps/{appId}"
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, "str"),
        "appId": _SERIALIZER.url("app_id", app_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    return HttpRequest(method="POST", url=_url, **kwargs)


def build_customers_remove_customer_app_request(id: str, app_id: str, **kwargs: Any) -> HttpRequest:
    # Construct URL
    _url = "/customers/{id}/apps/{appId}"
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, "str"),
        "appId": _SERIALIZER.url("app_id", app_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    return HttpRequest(method="DELETE", url=_url, **kwargs)


def build_customers_list_tenant_keys_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/customers/tenantkeys"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_databases_update_databases_request(**kwargs: Any) -> HttpRequest:
    # Construct URL
    _url = "/databases"

    return HttpRequest(method="POST", url=_url, **kwargs)


def build_power_list_power_regions_by_country_request(*, country: Optional[str] = None, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/power/regions"

    # Construct parameters
    if country is not None:
        _params["country"] = _SERIALIZER.query("country", country, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_power_create_power_region_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/power/regions"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_presentation_delete_component_settings_request(
    azure_ad_tenant_id: str, tenant_id: str, component_id: str, **kwargs: Any
) -> HttpRequest:
    # Construct URL
    _url = "/presentation/components/{azureAdTenantId}/{tenantId}/{componentId}"
    path_format_arguments = {
        "azureAdTenantId": _SERIALIZER.url("azure_ad_tenant_id", azure_ad_tenant_id, "str"),
        "tenantId": _SERIALIZER.url("tenant_id", tenant_id, "str"),
        "componentId": _SERIALIZER.url("component_id", component_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    return HttpRequest(method="DELETE", url=_url, **kwargs)


def build_presentation_save_component_settings_request(
    azure_ad_tenant_id: str, tenant_id: str, component_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/presentation/components/{azureAdTenantId}/{tenantId}/{componentId}"
    path_format_arguments = {
        "azureAdTenantId": _SERIALIZER.url("azure_ad_tenant_id", azure_ad_tenant_id, "str"),
        "tenantId": _SERIALIZER.url("tenant_id", tenant_id, "str"),
        "componentId": _SERIALIZER.url("component_id", component_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_tenants_list_tenants_details_request(
    *, tenant_id_prefix: Optional[str] = None, app_id: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/tenants"

    # Construct parameters
    if tenant_id_prefix is not None:
        _params["tenantIdPrefix"] = _SERIALIZER.query("tenant_id_prefix", tenant_id_prefix, "str")
    if app_id is not None:
        _params["appId"] = _SERIALIZER.query("app_id", app_id, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_user_get_user_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/user"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


class AppsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~ignos.internal.api.client.IgnosInternalApi`'s
        :attr:`apps` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list_apps(self, **kwargs: Any) -> List[_models.AppDto]:
        """Internal Ignos api for listing apps.

        Internal Ignos api for listing apps.

        :return: list of AppDto
        :rtype: list[~ignos.internal.api.client.models.AppDto]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[_models.AppDto]]

        request = build_apps_list_apps_request(
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("[AppDto]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @overload
    def create_app(
        self, body: Optional[_models.CreateApp] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AppDto:
        """Internal Ignos api for creating a new app.

        Internal Ignos api for creating a new app.

        :param body: Default value is None.
        :type body: ~ignos.internal.api.client.models.CreateApp
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AppDto
        :rtype: ~ignos.internal.api.client.models.AppDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def create_app(
        self, body: Optional[IO] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AppDto:
        """Internal Ignos api for creating a new app.

        Internal Ignos api for creating a new app.

        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :return: AppDto
        :rtype: ~ignos.internal.api.client.models.AppDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def create_app(self, body: Optional[Union[_models.CreateApp, IO]] = None, **kwargs: Any) -> _models.AppDto:
        """Internal Ignos api for creating a new app.

        Internal Ignos api for creating a new app.

        :param body: Is either a model type or a IO type. Default value is None.
        :type body: ~ignos.internal.api.client.models.CreateApp or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :return: AppDto
        :rtype: ~ignos.internal.api.client.models.AppDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.AppDto]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, "CreateApp")
            else:
                _json = None

        request = build_apps_create_app_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("AppDto", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @overload
    def update_app(
        self,
        id: str,
        body: Optional[_models.UpdateAppRequest] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AppDto:
        """Internal Ignos api for updating an app.

        Internal Ignos api for updating an app.

        :param id: Required.
        :type id: str
        :param body: Default value is None.
        :type body: ~ignos.internal.api.client.models.UpdateAppRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AppDto
        :rtype: ~ignos.internal.api.client.models.AppDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def update_app(
        self, id: str, body: Optional[IO] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AppDto:
        """Internal Ignos api for updating an app.

        Internal Ignos api for updating an app.

        :param id: Required.
        :type id: str
        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :return: AppDto
        :rtype: ~ignos.internal.api.client.models.AppDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def update_app(
        self, id: str, body: Optional[Union[_models.UpdateAppRequest, IO]] = None, **kwargs: Any
    ) -> _models.AppDto:
        """Internal Ignos api for updating an app.

        Internal Ignos api for updating an app.

        :param id: Required.
        :type id: str
        :param body: Is either a model type or a IO type. Default value is None.
        :type body: ~ignos.internal.api.client.models.UpdateAppRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :return: AppDto
        :rtype: ~ignos.internal.api.client.models.AppDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.AppDto]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, "UpdateAppRequest")
            else:
                _json = None

        request = build_apps_update_app_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("AppDto", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized


class AzureRegionsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~ignos.internal.api.client.IgnosInternalApi`'s
        :attr:`azure_regions` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list_azure_regions(self, **kwargs: Any) -> List[_models.AzureRegionDto]:
        """list_azure_regions.

        :return: list of AzureRegionDto
        :rtype: list[~ignos.internal.api.client.models.AzureRegionDto]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[_models.AzureRegionDto]]

        request = build_azure_regions_list_azure_regions_request(
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("[AzureRegionDto]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized


class CdfClustersOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~ignos.internal.api.client.IgnosInternalApi`'s
        :attr:`cdf_clusters` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list_cdf_clusters(self, **kwargs: Any) -> List[_models.CdfClusterDto]:
        """list_cdf_clusters.

        :return: list of CdfClusterDto
        :rtype: list[~ignos.internal.api.client.models.CdfClusterDto]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[_models.CdfClusterDto]]

        request = build_cdf_clusters_list_cdf_clusters_request(
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("[CdfClusterDto]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @overload
    def create_cdf_cluster(
        self, body: Optional[_models.CreateCdfCluster] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CdfClusterDto:
        """create_cdf_cluster.

        :param body: Default value is None.
        :type body: ~ignos.internal.api.client.models.CreateCdfCluster
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CdfClusterDto
        :rtype: ~ignos.internal.api.client.models.CdfClusterDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def create_cdf_cluster(
        self, body: Optional[IO] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CdfClusterDto:
        """create_cdf_cluster.

        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :return: CdfClusterDto
        :rtype: ~ignos.internal.api.client.models.CdfClusterDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def create_cdf_cluster(
        self, body: Optional[Union[_models.CreateCdfCluster, IO]] = None, **kwargs: Any
    ) -> _models.CdfClusterDto:
        """create_cdf_cluster.

        :param body: Is either a model type or a IO type. Default value is None.
        :type body: ~ignos.internal.api.client.models.CreateCdfCluster or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :return: CdfClusterDto
        :rtype: ~ignos.internal.api.client.models.CdfClusterDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.CdfClusterDto]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, "CreateCdfCluster")
            else:
                _json = None

        request = build_cdf_clusters_create_cdf_cluster_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("CdfClusterDto", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @overload
    def update_cdf_cluster(
        self,
        id: str,
        body: Optional[_models.UpdateCdfClusterRequest] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CdfClusterDto:
        """update_cdf_cluster.

        :param id: Required.
        :type id: str
        :param body: Default value is None.
        :type body: ~ignos.internal.api.client.models.UpdateCdfClusterRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CdfClusterDto
        :rtype: ~ignos.internal.api.client.models.CdfClusterDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def update_cdf_cluster(
        self, id: str, body: Optional[IO] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CdfClusterDto:
        """update_cdf_cluster.

        :param id: Required.
        :type id: str
        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :return: CdfClusterDto
        :rtype: ~ignos.internal.api.client.models.CdfClusterDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def update_cdf_cluster(
        self, id: str, body: Optional[Union[_models.UpdateCdfClusterRequest, IO]] = None, **kwargs: Any
    ) -> _models.CdfClusterDto:
        """update_cdf_cluster.

        :param id: Required.
        :type id: str
        :param body: Is either a model type or a IO type. Default value is None.
        :type body: ~ignos.internal.api.client.models.UpdateCdfClusterRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :return: CdfClusterDto
        :rtype: ~ignos.internal.api.client.models.CdfClusterDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.CdfClusterDto]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, "UpdateCdfClusterRequest")
            else:
                _json = None

        request = build_cdf_clusters_update_cdf_cluster_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("CdfClusterDto", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized


class CountriesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~ignos.internal.api.client.IgnosInternalApi`'s
        :attr:`countries` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list_countries(self, **kwargs: Any) -> List[_models.CountryDto]:
        """list_countries.

        :return: list of CountryDto
        :rtype: list[~ignos.internal.api.client.models.CountryDto]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[_models.CountryDto]]

        request = build_countries_list_countries_request(
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("[CountryDto]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized


class CustomersOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~ignos.internal.api.client.IgnosInternalApi`'s
        :attr:`customers` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list_customers(
        self, *, page_size: int = 100, continuation_token_parameter: Optional[str] = None, **kwargs: Any
    ) -> List[_models.IgnosCustomerDto]:
        """Internal Ignos api for listing customers.

        Internal Ignos api for listing customers.

        :keyword page_size: Default value is 100.
        :paramtype page_size: int
        :keyword continuation_token_parameter: Default value is None.
        :paramtype continuation_token_parameter: str
        :return: list of IgnosCustomerDto
        :rtype: list[~ignos.internal.api.client.models.IgnosCustomerDto]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[_models.IgnosCustomerDto]]

        request = build_customers_list_customers_request(
            page_size=page_size,
            continuation_token_parameter=continuation_token_parameter,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("[IgnosCustomerDto]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @overload
    def create_customer(
        self,
        body: Optional[_models.CreateIgnosCustomer] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.IgnosCustomerDto:
        """Internal Ignos api for creating a customer.

        Internal Ignos api for creating a customer.

        :param body: Default value is None.
        :type body: ~ignos.internal.api.client.models.CreateIgnosCustomer
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: IgnosCustomerDto
        :rtype: ~ignos.internal.api.client.models.IgnosCustomerDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def create_customer(
        self, body: Optional[IO] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.IgnosCustomerDto:
        """Internal Ignos api for creating a customer.

        Internal Ignos api for creating a customer.

        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :return: IgnosCustomerDto
        :rtype: ~ignos.internal.api.client.models.IgnosCustomerDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def create_customer(
        self, body: Optional[Union[_models.CreateIgnosCustomer, IO]] = None, **kwargs: Any
    ) -> _models.IgnosCustomerDto:
        """Internal Ignos api for creating a customer.

        Internal Ignos api for creating a customer.

        :param body: Is either a model type or a IO type. Default value is None.
        :type body: ~ignos.internal.api.client.models.CreateIgnosCustomer or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :return: IgnosCustomerDto
        :rtype: ~ignos.internal.api.client.models.IgnosCustomerDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.IgnosCustomerDto]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, "CreateIgnosCustomer")
            else:
                _json = None

        request = build_customers_create_customer_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("IgnosCustomerDto", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @distributed_trace
    def get_customer(self, id: str, **kwargs: Any) -> _models.IgnosCustomerDto:
        """Internal Ignos api for getting a customer.

        Internal Ignos api for getting a customer.

        :param id: Required.
        :type id: str
        :return: IgnosCustomerDto
        :rtype: ~ignos.internal.api.client.models.IgnosCustomerDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.IgnosCustomerDto]

        request = build_customers_get_customer_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("IgnosCustomerDto", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @overload
    def update_customer(
        self,
        id: str,
        body: Optional[_models.UpdateCustomerRequest] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.IgnosCustomerDto:
        """Internal Ignos api for updating a customer.

        Internal Ignos api for updating a customer.

        :param id: Required.
        :type id: str
        :param body: Default value is None.
        :type body: ~ignos.internal.api.client.models.UpdateCustomerRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: IgnosCustomerDto
        :rtype: ~ignos.internal.api.client.models.IgnosCustomerDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def update_customer(
        self, id: str, body: Optional[IO] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.IgnosCustomerDto:
        """Internal Ignos api for updating a customer.

        Internal Ignos api for updating a customer.

        :param id: Required.
        :type id: str
        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :return: IgnosCustomerDto
        :rtype: ~ignos.internal.api.client.models.IgnosCustomerDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def update_customer(
        self, id: str, body: Optional[Union[_models.UpdateCustomerRequest, IO]] = None, **kwargs: Any
    ) -> _models.IgnosCustomerDto:
        """Internal Ignos api for updating a customer.

        Internal Ignos api for updating a customer.

        :param id: Required.
        :type id: str
        :param body: Is either a model type or a IO type. Default value is None.
        :type body: ~ignos.internal.api.client.models.UpdateCustomerRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :return: IgnosCustomerDto
        :rtype: ~ignos.internal.api.client.models.IgnosCustomerDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.IgnosCustomerDto]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, "UpdateCustomerRequest")
            else:
                _json = None

        request = build_customers_update_customer_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("IgnosCustomerDto", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @distributed_trace
    def list_customer_tenants(self, id: str, **kwargs: Any) -> List[_models.TenantDto]:
        """Internal Ignos api for a customer's tenants.

        Internal Ignos api for a customer's tenants.

        :param id: Required.
        :type id: str
        :return: list of TenantDto
        :rtype: list[~ignos.internal.api.client.models.TenantDto]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[_models.TenantDto]]

        request = build_customers_list_customer_tenants_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("[TenantDto]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @overload
    def create_tenant(
        self,
        id: str,
        body: Optional[_models.CreateTenantRequest] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.TenantDto:
        """Internal Ignos api for creating a customer tenant.

        Internal Ignos api for creating a customer tenant.

        :param id: Required.
        :type id: str
        :param body: Default value is None.
        :type body: ~ignos.internal.api.client.models.CreateTenantRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: TenantDto
        :rtype: ~ignos.internal.api.client.models.TenantDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def create_tenant(
        self, id: str, body: Optional[IO] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.TenantDto:
        """Internal Ignos api for creating a customer tenant.

        Internal Ignos api for creating a customer tenant.

        :param id: Required.
        :type id: str
        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :return: TenantDto
        :rtype: ~ignos.internal.api.client.models.TenantDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def create_tenant(
        self, id: str, body: Optional[Union[_models.CreateTenantRequest, IO]] = None, **kwargs: Any
    ) -> _models.TenantDto:
        """Internal Ignos api for creating a customer tenant.

        Internal Ignos api for creating a customer tenant.

        :param id: Required.
        :type id: str
        :param body: Is either a model type or a IO type. Default value is None.
        :type body: ~ignos.internal.api.client.models.CreateTenantRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :return: TenantDto
        :rtype: ~ignos.internal.api.client.models.TenantDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.TenantDto]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, "CreateTenantRequest")
            else:
                _json = None

        request = build_customers_create_tenant_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("TenantDto", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @overload
    def update_tenant(
        self,
        id: str,
        tenant_id: str,
        body: Optional[_models.UpdateTenantRequest] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.TenantDto:
        """Internal Ignos api for updating a customer tenant.

        Internal Ignos api for updating a customer tenant.

        :param id: Required.
        :type id: str
        :param tenant_id: Required.
        :type tenant_id: str
        :param body: Default value is None.
        :type body: ~ignos.internal.api.client.models.UpdateTenantRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: TenantDto
        :rtype: ~ignos.internal.api.client.models.TenantDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def update_tenant(
        self,
        id: str,
        tenant_id: str,
        body: Optional[IO] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.TenantDto:
        """Internal Ignos api for updating a customer tenant.

        Internal Ignos api for updating a customer tenant.

        :param id: Required.
        :type id: str
        :param tenant_id: Required.
        :type tenant_id: str
        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :return: TenantDto
        :rtype: ~ignos.internal.api.client.models.TenantDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def update_tenant(
        self, id: str, tenant_id: str, body: Optional[Union[_models.UpdateTenantRequest, IO]] = None, **kwargs: Any
    ) -> _models.TenantDto:
        """Internal Ignos api for updating a customer tenant.

        Internal Ignos api for updating a customer tenant.

        :param id: Required.
        :type id: str
        :param tenant_id: Required.
        :type tenant_id: str
        :param body: Is either a model type or a IO type. Default value is None.
        :type body: ~ignos.internal.api.client.models.UpdateTenantRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :return: TenantDto
        :rtype: ~ignos.internal.api.client.models.TenantDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.TenantDto]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, "UpdateTenantRequest")
            else:
                _json = None

        request = build_customers_update_tenant_request(
            id=id,
            tenant_id=tenant_id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("TenantDto", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @distributed_trace
    def get_cdf_config(self, id: str, tenant_id: str, **kwargs: Any) -> _models.CdfConfigDto:
        """Internal Ignos api for checking CDF config.

        Internal Ignos api for checking CDF config.

        :param id: Customer id. Required.
        :type id: str
        :param tenant_id: Tenant id. Required.
        :type tenant_id: str
        :return: CdfConfigDto
        :rtype: ~ignos.internal.api.client.models.CdfConfigDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.CdfConfigDto]

        request = build_customers_get_cdf_config_request(
            id=id,
            tenant_id=tenant_id,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("CdfConfigDto", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @overload
    def update_cdf_config(
        self,
        id: str,
        tenant_id: str,
        body: Optional[_models.UpdateTenantCdfConfigRequest] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CdfConfigDto:
        """Internal Ignos api for updating CDF config.

        Internal Ignos api for updating CDF config.

        :param id: Customer id. Required.
        :type id: str
        :param tenant_id: Tenant id. Required.
        :type tenant_id: str
        :param body: Default value is None.
        :type body: ~ignos.internal.api.client.models.UpdateTenantCdfConfigRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CdfConfigDto
        :rtype: ~ignos.internal.api.client.models.CdfConfigDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def update_cdf_config(
        self,
        id: str,
        tenant_id: str,
        body: Optional[IO] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CdfConfigDto:
        """Internal Ignos api for updating CDF config.

        Internal Ignos api for updating CDF config.

        :param id: Customer id. Required.
        :type id: str
        :param tenant_id: Tenant id. Required.
        :type tenant_id: str
        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :return: CdfConfigDto
        :rtype: ~ignos.internal.api.client.models.CdfConfigDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def update_cdf_config(
        self,
        id: str,
        tenant_id: str,
        body: Optional[Union[_models.UpdateTenantCdfConfigRequest, IO]] = None,
        **kwargs: Any
    ) -> _models.CdfConfigDto:
        """Internal Ignos api for updating CDF config.

        Internal Ignos api for updating CDF config.

        :param id: Customer id. Required.
        :type id: str
        :param tenant_id: Tenant id. Required.
        :type tenant_id: str
        :param body: Is either a model type or a IO type. Default value is None.
        :type body: ~ignos.internal.api.client.models.UpdateTenantCdfConfigRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :return: CdfConfigDto
        :rtype: ~ignos.internal.api.client.models.CdfConfigDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.CdfConfigDto]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, "UpdateTenantCdfConfigRequest")
            else:
                _json = None

        request = build_customers_update_cdf_config_request(
            id=id,
            tenant_id=tenant_id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("CdfConfigDto", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @distributed_trace
    def list_customer_apps(self, id: str, **kwargs: Any) -> List[_models.CustomerAppDto]:
        """Internal Ignos api for listing customer apps.

        Internal Ignos api for listing customer apps.

        :param id: Required.
        :type id: str
        :return: list of CustomerAppDto
        :rtype: list[~ignos.internal.api.client.models.CustomerAppDto]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[_models.CustomerAppDto]]

        request = build_customers_list_customer_apps_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("[CustomerAppDto]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @distributed_trace
    def add_customer_app(  # pylint: disable=inconsistent-return-statements
        self, id: str, app_id: str, **kwargs: Any
    ) -> None:
        """Internal Ignos api for adding an app to a customer.

        Internal Ignos api for adding an app to a customer.

        :param id: Required.
        :type id: str
        :param app_id: Required.
        :type app_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_customers_add_customer_app_request(
            id=id,
            app_id=app_id,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    @distributed_trace
    def remove_customer_app(  # pylint: disable=inconsistent-return-statements
        self, id: str, app_id: str, **kwargs: Any
    ) -> None:
        """Internal Ignos api for removing an app from a customer.

        Internal Ignos api for removing an app from a customer.

        :param id: Required.
        :type id: str
        :param app_id: Required.
        :type app_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_customers_remove_customer_app_request(
            id=id,
            app_id=app_id,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    @distributed_trace
    def list_tenant_keys(self, **kwargs: Any) -> List[_models.TenantKeyDto]:
        """list_tenant_keys.

        :return: list of TenantKeyDto
        :rtype: list[~ignos.internal.api.client.models.TenantKeyDto]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[_models.TenantKeyDto]]

        request = build_customers_list_tenant_keys_request(
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("[TenantKeyDto]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized


class DatabasesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~ignos.internal.api.client.IgnosInternalApi`'s
        :attr:`databases` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def update_databases(self, **kwargs: Any) -> None:  # pylint: disable=inconsistent-return-statements
        """update_databases.

        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_databases_update_databases_request(
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})


class PowerOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~ignos.internal.api.client.IgnosInternalApi`'s
        :attr:`power` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list_power_regions_by_country(
        self, *, country: Optional[str] = None, **kwargs: Any
    ) -> List[_models.PowerRegionDto]:
        """list_power_regions_by_country.

        :keyword country: Default value is None.
        :paramtype country: str
        :return: list of PowerRegionDto
        :rtype: list[~ignos.internal.api.client.models.PowerRegionDto]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[_models.PowerRegionDto]]

        request = build_power_list_power_regions_by_country_request(
            country=country,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("[PowerRegionDto]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @overload
    def create_power_region(
        self, body: Optional[_models.CreatePowerRegion] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.PowerRegionDto:
        """create_power_region.

        :param body: Default value is None.
        :type body: ~ignos.internal.api.client.models.CreatePowerRegion
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: PowerRegionDto
        :rtype: ~ignos.internal.api.client.models.PowerRegionDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def create_power_region(
        self, body: Optional[IO] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.PowerRegionDto:
        """create_power_region.

        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :return: PowerRegionDto
        :rtype: ~ignos.internal.api.client.models.PowerRegionDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def create_power_region(
        self, body: Optional[Union[_models.CreatePowerRegion, IO]] = None, **kwargs: Any
    ) -> _models.PowerRegionDto:
        """create_power_region.

        :param body: Is either a model type or a IO type. Default value is None.
        :type body: ~ignos.internal.api.client.models.CreatePowerRegion or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :return: PowerRegionDto
        :rtype: ~ignos.internal.api.client.models.PowerRegionDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.PowerRegionDto]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, "CreatePowerRegion")
            else:
                _json = None

        request = build_power_create_power_region_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("PowerRegionDto", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized


class PresentationOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~ignos.internal.api.client.IgnosInternalApi`'s
        :attr:`presentation` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def delete_component_settings(  # pylint: disable=inconsistent-return-statements
        self, azure_ad_tenant_id: str, tenant_id: str, component_id: str, **kwargs: Any
    ) -> None:
        """delete_component_settings.

        :param azure_ad_tenant_id: Required.
        :type azure_ad_tenant_id: str
        :param tenant_id: Required.
        :type tenant_id: str
        :param component_id: Required.
        :type component_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_presentation_delete_component_settings_request(
            azure_ad_tenant_id=azure_ad_tenant_id,
            tenant_id=tenant_id,
            component_id=component_id,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    @overload
    def save_component_settings(
        self,
        azure_ad_tenant_id: str,
        tenant_id: str,
        component_id: str,
        body: Optional[_models.SaveComponentSettingsRequest] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ComponentSettingsDto:
        """save_component_settings.

        :param azure_ad_tenant_id: Required.
        :type azure_ad_tenant_id: str
        :param tenant_id: Required.
        :type tenant_id: str
        :param component_id: Required.
        :type component_id: str
        :param body: Default value is None.
        :type body: ~ignos.internal.api.client.models.SaveComponentSettingsRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ComponentSettingsDto
        :rtype: ~ignos.internal.api.client.models.ComponentSettingsDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def save_component_settings(
        self,
        azure_ad_tenant_id: str,
        tenant_id: str,
        component_id: str,
        body: Optional[IO] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ComponentSettingsDto:
        """save_component_settings.

        :param azure_ad_tenant_id: Required.
        :type azure_ad_tenant_id: str
        :param tenant_id: Required.
        :type tenant_id: str
        :param component_id: Required.
        :type component_id: str
        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :return: ComponentSettingsDto
        :rtype: ~ignos.internal.api.client.models.ComponentSettingsDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def save_component_settings(
        self,
        azure_ad_tenant_id: str,
        tenant_id: str,
        component_id: str,
        body: Optional[Union[_models.SaveComponentSettingsRequest, IO]] = None,
        **kwargs: Any
    ) -> _models.ComponentSettingsDto:
        """save_component_settings.

        :param azure_ad_tenant_id: Required.
        :type azure_ad_tenant_id: str
        :param tenant_id: Required.
        :type tenant_id: str
        :param component_id: Required.
        :type component_id: str
        :param body: Is either a model type or a IO type. Default value is None.
        :type body: ~ignos.internal.api.client.models.SaveComponentSettingsRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :return: ComponentSettingsDto
        :rtype: ~ignos.internal.api.client.models.ComponentSettingsDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ComponentSettingsDto]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, "SaveComponentSettingsRequest")
            else:
                _json = None

        request = build_presentation_save_component_settings_request(
            azure_ad_tenant_id=azure_ad_tenant_id,
            tenant_id=tenant_id,
            component_id=component_id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("ComponentSettingsDto", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized


class TenantsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~ignos.internal.api.client.IgnosInternalApi`'s
        :attr:`tenants` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list_tenants_details(
        self, *, tenant_id_prefix: Optional[str] = None, app_id: Optional[str] = None, **kwargs: Any
    ) -> List[_models.TenantDetailDto]:
        """Internal Ignos api for listing tenants.

        Internal Ignos api for listing tenants.

        :keyword tenant_id_prefix: Default value is None.
        :paramtype tenant_id_prefix: str
        :keyword app_id: Default value is None.
        :paramtype app_id: str
        :return: list of TenantDetailDto
        :rtype: list[~ignos.internal.api.client.models.TenantDetailDto]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[_models.TenantDetailDto]]

        request = build_tenants_list_tenants_details_request(
            tenant_id_prefix=tenant_id_prefix,
            app_id=app_id,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("[TenantDetailDto]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized


class UserOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~ignos.internal.api.client.IgnosInternalApi`'s
        :attr:`user` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def get_user(self, **kwargs: Any) -> _models.UserDetailsDto:
        """get_user.

        :return: UserDetailsDto
        :rtype: ~ignos.internal.api.client.models.UserDetailsDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.UserDetailsDto]

        request = build_user_get_user_request(
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("UserDetailsDto", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
