# coding: utf-8

"""
    Lilt REST API

    The Lilt REST API enables programmatic access to the full-range of Lilt backend services including:   * Training of and translating with interactive, adaptive machine translation   * Large-scale translation memory   * The Lexicon (a large-scale termbase)   * Programmatic control of the Lilt CAT environment   * Translation memory synchronization  Requests and responses are in JSON format. The REST API only responds to HTTPS / SSL requests. ## Authentication Requests are authenticated via REST API key, which requires the Business plan.  Requests are authenticated using [HTTP Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Add your REST API key as both the `username` and `password`.  For development, you may also pass the REST API key via the `key` query parameter. This is less secure than HTTP Basic Auth, and is not recommended for production use.   # noqa: E501

    The version of the OpenAPI document: v2.0
    Contact: support@lilt.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from lilt.configuration import Configuration


class TranslationList(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'untokenized_source': 'str',
        'tokenized_source': 'str',
        'source_delimiters': 'list[str]',
        'translation': 'list[Translation]'
    }

    attribute_map = {
        'untokenized_source': 'untokenizedSource',
        'tokenized_source': 'tokenizedSource',
        'source_delimiters': 'sourceDelimiters',
        'translation': 'translation'
    }

    def __init__(self, untokenized_source=None, tokenized_source=None, source_delimiters=None, translation=None, local_vars_configuration=None):  # noqa: E501
        """TranslationList - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._untokenized_source = None
        self._tokenized_source = None
        self._source_delimiters = None
        self._translation = None
        self.discriminator = None

        if untokenized_source is not None:
            self.untokenized_source = untokenized_source
        if tokenized_source is not None:
            self.tokenized_source = tokenized_source
        if source_delimiters is not None:
            self.source_delimiters = source_delimiters
        if translation is not None:
            self.translation = translation

    @property
    def untokenized_source(self):
        """Gets the untokenized_source of this TranslationList.  # noqa: E501

        The untokenized source segment. Punctuation has not been separated from words.  # noqa: E501

        :return: The untokenized_source of this TranslationList.  # noqa: E501
        :rtype: str
        """
        return self._untokenized_source

    @untokenized_source.setter
    def untokenized_source(self, untokenized_source):
        """Sets the untokenized_source of this TranslationList.

        The untokenized source segment. Punctuation has not been separated from words.  # noqa: E501

        :param untokenized_source: The untokenized_source of this TranslationList.  # noqa: E501
        :type: str
        """

        self._untokenized_source = untokenized_source

    @property
    def tokenized_source(self):
        """Gets the tokenized_source of this TranslationList.  # noqa: E501

        The tokenized source segment. Punctuation has been separated from words.  # noqa: E501

        :return: The tokenized_source of this TranslationList.  # noqa: E501
        :rtype: str
        """
        return self._tokenized_source

    @tokenized_source.setter
    def tokenized_source(self, tokenized_source):
        """Sets the tokenized_source of this TranslationList.

        The tokenized source segment. Punctuation has been separated from words.  # noqa: E501

        :param tokenized_source: The tokenized_source of this TranslationList.  # noqa: E501
        :type: str
        """

        self._tokenized_source = tokenized_source

    @property
    def source_delimiters(self):
        """Gets the source_delimiters of this TranslationList.  # noqa: E501

        A format string that indicates, for each word, if the word should be preceded by a space.  # noqa: E501

        :return: The source_delimiters of this TranslationList.  # noqa: E501
        :rtype: list[str]
        """
        return self._source_delimiters

    @source_delimiters.setter
    def source_delimiters(self, source_delimiters):
        """Sets the source_delimiters of this TranslationList.

        A format string that indicates, for each word, if the word should be preceded by a space.  # noqa: E501

        :param source_delimiters: The source_delimiters of this TranslationList.  # noqa: E501
        :type: list[str]
        """

        self._source_delimiters = source_delimiters

    @property
    def translation(self):
        """Gets the translation of this TranslationList.  # noqa: E501

        A list of Translation objects.  # noqa: E501

        :return: The translation of this TranslationList.  # noqa: E501
        :rtype: list[Translation]
        """
        return self._translation

    @translation.setter
    def translation(self, translation):
        """Sets the translation of this TranslationList.

        A list of Translation objects.  # noqa: E501

        :param translation: The translation of this TranslationList.  # noqa: E501
        :type: list[Translation]
        """

        self._translation = translation

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TranslationList):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, TranslationList):
            return True

        return self.to_dict() != other.to_dict()
