# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/0c_schedules.ipynb (unless otherwise specified).

__all__ = ['one_shot', 'iterative', 'sched_agp', 'sched_onecycle']

# Cell
import numpy as np

# Cell
def one_shot(start, end, pos): return end

# Cell
def iterative(start, end, pos, n_steps=3):
    "Perform iterative pruning, and pruning in `n_steps` steps"
    return start + ((end-start)/n_steps)*(np.ceil((pos)*n_steps))

# Cell
def sched_agp(start, end, pos): return end + (start - end) * (1 - pos)**3

# Cell
def sched_onecycle(start, end, pos, α=14, β=6):
    out = (1+np.exp(-α+β)) / (1 + (np.exp((-α*pos)+β)))
    return start + (end-start)*out