# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/05_knowledge_distillation.ipynb (unless otherwise specified).

__all__ = ['KnowledgeDistillation', 'SoftTarget', 'LogitsRegression', 'WeightRegression']

# Cell
from fastai.vision.all import *

import torch
import torch.nn as nn
import torch.nn.functional as F

# Cell
class KnowledgeDistillation(Callback):
    def __init__(self, teacher, loss):
        store_attr()

    def after_loss(self):
        self.teacher.model.eval()
        teacher_output = self.teacher.model(self.x)
        new_loss = self.loss(self.pred, self.y, teacher_output, student=self.learn.model, teacher=self.teacher.model)
        self.learn.loss_grad = new_loss
        self.learn.loss = self.learn.loss_grad.clone()

# Cell
def SoftTarget(y, labels, teacher_scores, T=20, α=0.7, **kwargs):
    return nn.KLDivLoss(reduction='batchmean')(F.log_softmax(y/T, dim=-1), F.softmax(teacher_scores/T, dim=-1)) * (T*T * 2.0 * α) + F.cross_entropy(y, labels) * (1. - α)

def LogitsRegression(y, labels, teacher_scores, **kwargs):
    return F.mse_loss(y, teacher_scores)

def WeightRegression(y, labels, teacher_scores, student, teacher, α=0.5, **kwargs):
    loss = 0
    for m1, m2 in zip(student.modules(), teacher.modules()):
        if isinstance(m1, nn.Conv2d) or isinstance(m1, nn.Linear):
            loss += F.mse_loss(m1.weight.to(device), m2.weight.to(device))
    return α*loss + F.cross_entropy(y, labels) * (1. - α)