# PyGMI Readme

PyGMI stands for *Python Geoscience Modelling and Interpretation*. It is a modelling and interpretation suite aimed at magnetic, gravity and other datasets. 

PyGMI is developed at the [Council for Geoscience](http://www.geoscience.org.za) (Geological Survey of South Africa).

It includes:
* Magnetic and Gravity 3D forward modelling
* Cluster Analysis
* Routines for cutting, reprojecting and doing simple modifications to data
* Convenient display of data using pseudo-color, ternary and sunshaded representation
* New features such as MT processing and 1D inversion, gravity processing, seismological  for SEISAN data.

It is released under the Gnu General Public License version [3.0](http://www.gnu.org/copyleft/gpl.html)

The PyGMI [Wiki](http://patrick-cole.github.io/pygmi/index.html) pages, include installation and full usage!

You may need to install the [Microsoft Visual C++ Redistributable for Visual Studio 2015, 2017 and 2019](https://support.microsoft.com/en-us/help/2977003/the-latest-supported-visual-c-downloads)

## Requirements
PyGMI will run on both Windows and Linux. It should be noted that the main development is now being done in Python 3.8 on Windows.

PyGMI is developed and has been tested with the following libraries in order to function:

* python 3.8.1
* fiona 1.8.13
* gdal 3.0.4
* geopandas 0.6.2
* llvmlite 0.31.0
* matplotlib 3.2.0rc2
* mtpy 1.1.3
* numba 0.47.0
* numexpr 2.7.1
* numpy 1.18.0+mkl
* pandas 0.25.3
* pillow 7.0.0
* pymatsolver 0.1.2
* pyopengl 3.1.5
* PyQt5 5.12.3
* pytest 5.3.2
* scikit-image 0.16.2
* scikit-learn 0.22.1
* scipy 1.4.1
* segyio 1.9.0
* shapely 1.6.4.post2
* SimPEG 0.13.1

## Installation
### General (Not Anaconda)
The easiest way to install pygmi if you are working in a python environment is to use the pip command as follows:

	pip install pygmi

This will download pygmi from PyPI and install it within your python repository. Please note the use of pip when installing PyGMI may cause Anaconda installations to break. Anaconda users should follow the instructions below.

Alternatively, if you satisfy the requirements, you can download pygmi either from Github or PyPI, extract it and run the following command from within the extracted directory:

	python setup.py install

In either case, running pygmi can be now done at the command prompt as follows:

	pygmi

If you are in python, you can run PyGMI by using the following commands:

	import pygmi
	pygmi.main()


If you prefer not to install pygmi as a library, or if there is a problem with running it in that matter, you can simply execute the following command to run it manually:

	python quickstart.py

### Windows
I have now made available convenient installers for PyGMI, thanks to Cyrille Rossant.

Installers are available in [64-bit](https://github.com/Patrick-Cole/pygmi/releases)

Running the software can be achieved through the shortcut on your desktop.

You may need to install the Microsoft Visual C++ 2015 Redistributable. It can be obtained from [here](https://www.visualstudio.com/downloads/download-visual-studio-vs#d-visual-c)

### Linux
Linux normally comes with python installed, but the additional libraries will still need to be installed. One convenient option is to install the above libraries through [Anaconda](http://continuum.io/downloads>).

After installation of python, you can follow the instructions under General.

### Anaconda
Anaconda users are advised not to use pip since it can break PyQt5. However, two packages are installed only by pip, so a Conda environment should be created. The process to install is as follows:

	conda create -n pygmi python=3.7
	conda install pyqt
	conda install numpy
	conda install scipy
	conda install numexpr
	conda install gdal
	conda install pillow
	conda install matplotlib
	conda install numba
	conda install pandas
	conda install scikit-learn
	conda install scikit-image
	conda install geopandas
	conda install pyopengl
	conda install pyyaml

	pip install mtpy
	pip install segyio

Once this is done, download pygmi, extract it to a directory, and run it from its root directory with the following command:

	python quickstart.py

Alternatively, if you satisfy the requirements, you can run the following command from within the extracted directory:

	python setup_anaconda.py install

Running pygmi can be now done at the command prompt as follows:

	pygmi
