"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaPowertoolsLayer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * Defines a new Lambda Layer with Powertools for python library.
 */
class LambdaPowertoolsLayer extends aws_cdk_lib_1.aws_lambda.LayerVersion {
    constructor(scope, id, props) {
        super(scope, id, {
            code: aws_cdk_lib_1.aws_lambda.Code.fromDockerBuild(path.join(__dirname, '../layer'), {
                buildArgs: {
                    PACKAGE_SUFFIX: LambdaPowertoolsLayer.constructBuildArgs(props === null || props === void 0 ? void 0 : props.includeExtras, props === null || props === void 0 ? void 0 : props.version),
                },
            }),
            license: 'MIT-0',
            compatibleRuntimes: [
                aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_6,
                aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_7,
                aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_8,
                aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_9,
            ],
            description: `Lambda Powertools for Python${(props === null || props === void 0 ? void 0 : props.includeExtras) ? ' with Pydantic' : ''} ${(props === null || props === void 0 ? void 0 : props.version) ? `version ${props.version}` : 'latest version'}`.trim(),
        });
    }
    /**
     * creates build argument for the Dockerfile.
     * There are multiple combinations between version and extras package that results in different suffix for the installation.
     * With and without version, with and without extras flag.
     * We construct one suffix here because it is easier to do in code than inside the Dockerfile with bash commands.
     * For example, if we set extras=true and version=1.22.0 we get '[pydantic]==1.22.0'.
     *
     */
    static constructBuildArgs(includeExtras, version) {
        let suffix = '';
        if (includeExtras) {
            suffix = '[pydantic]';
        }
        if (version) {
            suffix = `${suffix}==${version}`;
        }
        return suffix;
    }
    ;
}
exports.LambdaPowertoolsLayer = LambdaPowertoolsLayer;
_a = JSII_RTTI_SYMBOL_1;
LambdaPowertoolsLayer[_a] = { fqn: "cdk-lambda-powertools-python-layer.LambdaPowertoolsLayer", version: "2.0.18" };
//# sourceMappingURL=data:application/json;base64,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