/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.sax.discord;

import java.util.List;
import net.seninp.jmotif.sax.discord.DiscordRecord;
import net.seninp.jmotif.sax.discord.DiscordRecords;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDiscordRecords {
    private static final int ds1Pos = 11;
    private static final double ds1Dist = 0.11;
    private static final int ds2Pos = 21;
    private static final double ds2Dist = 0.21;
    private static final int ds3Pos = 31;
    private static final double ds3Dist = 0.31;
    private static final int ds4Pos = 41;
    private static final double ds4Dist = 0.41;
    private static final double precision = 1.0E-4;
    private DiscordRecord discord1;
    private DiscordRecord discord2;
    private DiscordRecord discord3;
    private DiscordRecord discord4;

    @Before
    public void setUp() throws Exception {
        this.discord1 = new DiscordRecord(11, 0.11);
        this.discord2 = new DiscordRecord(21, 0.21);
        this.discord3 = new DiscordRecord(31, 0.31);
        this.discord4 = new DiscordRecord(41, 0.41);
    }

    @Test
    public void testDiscordRecords() {
        DiscordRecords ds = new DiscordRecords();
        Assert.assertTrue("Test constructor", ds.getTopHits(10).isEmpty());
        ds.add(this.discord1);
        Assert.assertEquals("Test constructor", 1L, ds.getTopHits(10).size());
        Assert.assertSame("Test constructor", this.discord1, ds.getTopHits(10).get(0));
        ds.add(this.discord2);
        Assert.assertEquals("Test constructor", 2L, ds.getTopHits(10).size());
        Assert.assertSame("Test constructor", this.discord1, ds.getTopHits(2).get(1));
        ds.add(this.discord3);
        ds.add(this.discord4);
        Assert.assertNotNull("test to string", ds.toString());
        List<DiscordRecord> topHits = ds.getTopHits(2);
        Assert.assertEquals("Test constructor", 2L, topHits.size());
        Assert.assertSame("Test constructor", this.discord2, topHits.get(0));
    }

    @Test
    public void testDiscordRecordsInt() {
        DiscordRecords ds = new DiscordRecords();
        Assert.assertTrue("Test constructor", ds.getTopHits(10).isEmpty());
        ds.add(this.discord1);
        Assert.assertEquals("Test constructor", 1L, ds.getTopHits(10).size());
        Assert.assertSame("Test constructor", this.discord1, ds.getTopHits(10).get(0));
        ds.add(this.discord2);
        Assert.assertEquals("Test constructor", 2L, ds.getTopHits(10).size());
        Assert.assertSame("Test constructor", this.discord2, ds.getTopHits(10).get(0));
    }

    @Test
    public void testGetMinDistance() {
        DiscordRecords ds = new DiscordRecords();
        ds.add(this.discord1);
        ds.add(this.discord2);
        ds.add(this.discord3);
        Assert.assertEquals("Test constructor", 0.31, ds.getMinDistance(), 1.0E-4);
    }

    @Test
    public void testToString() {
        DiscordRecords ds = new DiscordRecords();
        Assert.assertEquals(-1.0, ds.getMinDistance(), 1.0E-4);
        ds.add(this.discord1);
        ds.add(this.discord2);
        Assert.assertTrue(ds.toString().contains(String.valueOf(11)));
    }
}

