/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.sax.datastructures;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import net.seninp.jmotif.sax.datastructure.DoublyLinkedSortedList;
import net.seninp.jmotif.sax.datastructure.SAXRecord;
import net.seninp.util.JmotifMapEntry;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDoublyLinkedSortedList {
    private Comparator<Map.Entry<String, SAXRecord>> cAscending;
    private Comparator<Map.Entry<String, SAXRecord>> cDescending;
    private SAXRecord srLargest;
    private Map.Entry<String, SAXRecord> entryLargest;
    private Map.Entry<String, SAXRecord> entryMed;
    private Map.Entry<String, SAXRecord> entrySmallest;

    @Before
    public void setUp() throws Exception {
        this.cAscending = new Comparator<Map.Entry<String, SAXRecord>>(){

            @Override
            public int compare(Map.Entry<String, SAXRecord> o1, Map.Entry<String, SAXRecord> o2) {
                int f1 = o1.getValue().getIndexes().size();
                int f2 = o2.getValue().getIndexes().size();
                return Integer.compare(f2, f1);
            }
        };
        this.cDescending = new Comparator<Map.Entry<String, SAXRecord>>(){

            @Override
            public int compare(Map.Entry<String, SAXRecord> o1, Map.Entry<String, SAXRecord> o2) {
                int f1 = o1.getValue().getIndexes().size();
                int f2 = o2.getValue().getIndexes().size();
                return Integer.compare(f1, f2);
            }
        };
        this.srLargest = new SAXRecord(String.valueOf("aaa").toCharArray(), 10);
        this.srLargest.addIndex(11);
        this.srLargest.addIndex(12);
        this.entryLargest = new JmotifMapEntry<String, SAXRecord>(String.valueOf(this.srLargest.getPayload()), this.srLargest);
        SAXRecord srMed = new SAXRecord(String.valueOf("bbb").toCharArray(), 15);
        srMed.addIndex(16);
        this.entryMed = new JmotifMapEntry<String, SAXRecord>(String.valueOf(srMed.getPayload()), srMed);
        SAXRecord srSmallest = new SAXRecord(String.valueOf("ccc").toCharArray(), 20);
        this.entrySmallest = new JmotifMapEntry<String, SAXRecord>(String.valueOf(srSmallest.getPayload()), srSmallest);
    }

    @Test
    public void testAddElement() {
        DoublyLinkedSortedList<Map.Entry<String, SAXRecord>> testList = new DoublyLinkedSortedList<Map.Entry<String, SAXRecord>>(2, this.cAscending);
        Assert.assertTrue("Assert emptiness", testList.isEmpty());
        testList.addElement(this.entryLargest);
        Assert.assertFalse("Assert non-emptiness", testList.isEmpty());
        Map.Entry<String, SAXRecord> e = testList.iterator().next();
        Assert.assertTrue("assert add element success", e.getKey().equals(this.entryLargest.getKey()));
    }

    @Test
    public void testComparatorAscending() {
        DoublyLinkedSortedList<Map.Entry<String, SAXRecord>> testListA = new DoublyLinkedSortedList<Map.Entry<String, SAXRecord>>(2, this.cAscending);
        testListA.addElement(this.entrySmallest);
        testListA.addElement(this.entryLargest);
        testListA.addElement(this.entryMed);
        Iterator<Map.Entry<String, SAXRecord>> i = testListA.iterator();
        Map.Entry<String, SAXRecord> e = i.next();
        Assert.assertTrue("assert add element success", e.getKey().equals(this.entrySmallest.getKey()));
        e = i.next();
        Assert.assertTrue("assert add element success", e.getKey().equals(this.entryMed.getKey()));
        Assert.assertFalse("assert the list size", i.hasNext());
    }

    @Test
    public void testComparatorDescending() {
        DoublyLinkedSortedList<Map.Entry<String, SAXRecord>> testListD = new DoublyLinkedSortedList<Map.Entry<String, SAXRecord>>(3, this.cDescending);
        testListD.addElement(this.entrySmallest);
        testListD.addElement(this.entryLargest);
        testListD.addElement(this.entryMed);
        Iterator<Map.Entry<String, SAXRecord>> i = testListD.iterator();
        Map.Entry<String, SAXRecord> e = i.next();
        Assert.assertTrue("assert add element success", e.getKey().equals(this.entryLargest.getKey()));
        e = i.next();
        Assert.assertTrue("assert add element success", e.getKey().equals(this.entryMed.getKey()));
        e = i.next();
        Assert.assertTrue("assert add element success", e.getKey().equals(this.entrySmallest.getKey()));
    }
}

