/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.sax.datastructure;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class SAXRecord
implements Comparable<SAXRecord> {
    private char[] saxString;
    private HashSet<Integer> occurrences;

    private SAXRecord() {
    }

    public SAXRecord(char[] str, int idx) {
        this.saxString = (char[])str.clone();
        this.occurrences = new HashSet();
        this.addIndex(idx);
    }

    public void addIndex(int idx) {
        this.occurrences.add(idx);
    }

    public void removeIndex(Integer idx) {
        this.occurrences.remove(idx);
    }

    public char[] getPayload() {
        return this.saxString;
    }

    public Set<Integer> getIndexes() {
        return this.occurrences;
    }

    @Override
    public int compareTo(SAXRecord o) {
        int b;
        int a = this.occurrences.size();
        if (a == (b = o.getIndexes().size())) {
            return 0;
        }
        if (a > b) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object o) {
        SAXRecord other;
        if (o instanceof SAXRecord && Arrays.equals((other = (SAXRecord)o).getPayload(), this.saxString) && other.getIndexes().size() == this.occurrences.size()) {
            for (Integer e : this.occurrences) {
                if (other.getIndexes().contains(e)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        int num0 = 0;
        if (null == this.saxString || 0 == this.saxString.length) {
            num0 = 32;
        } else {
            for (int i = 0; i < this.saxString.length; ++i) {
                num0 += Character.getNumericValue(this.saxString[i]);
            }
        }
        int num1 = 0;
        if (this.occurrences.isEmpty()) {
            num1 = 17;
        } else {
            for (Integer i : this.occurrences) {
                num1 += i.intValue();
            }
        }
        hash = num0 + hash * num1;
        return hash;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.saxString).append(" -> ").append(this.occurrences.toString());
        return sb.toString();
    }
}

