/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.sax.bitmap;

import com.beust.jcommander.JCommander;
import java.awt.Color;
import java.awt.Dimension;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.seninp.jmotif.sax.SAXException;
import net.seninp.jmotif.sax.SAXProcessor;
import net.seninp.jmotif.sax.bitmap.BitmapParameters;
import net.seninp.util.HeatChart;
import net.seninp.util.UCRUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UCRdataBitmapPrinter {
    private static final String QUOTE = "'";
    private static final String COMMA = ",";
    private static final String CR = "\n";
    private static final SAXProcessor sp = new SAXProcessor();
    private static final Logger LOGGER = LoggerFactory.getLogger(UCRdataBitmapPrinter.class);

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) throws SAXException, IOException {
        BitmapParameters params = new BitmapParameters();
        JCommander jct = new JCommander((Object)params, args);
        if (0 == args.length) {
            jct.usage();
        } else {
            void var10_22;
            void var10_20;
            StringBuilder sb = new StringBuilder(1024);
            sb.append("SAXBitmap CLI converter v.1").append(CR);
            sb.append("parameters:").append(CR);
            sb.append("  input file:                  ").append(BitmapParameters.IN_FILE).append(CR);
            sb.append("  output file:                 ").append(BitmapParameters.OUT_FILE).append(CR);
            sb.append("  SAX sliding window size:     ").append(BitmapParameters.SAX_WINDOW_SIZE).append(CR);
            sb.append("  SAX PAA size:                ").append(BitmapParameters.SAX_PAA_SIZE).append(CR);
            sb.append("  SAX alphabet size:           ").append(BitmapParameters.SAX_ALPHABET_SIZE).append(CR);
            sb.append("  SAX numerosity reduction:    ").append((Object)BitmapParameters.SAX_NR_STRATEGY).append(CR);
            sb.append("  SAX normalization threshold: ").append(BitmapParameters.SAX_NORM_THRESHOLD).append(CR);
            sb.append("  Bitmap shingle size:         ").append(BitmapParameters.SHINGLE_SIZE).append(CR);
            if (null == BitmapParameters.BITMAP_FILE) {
                sb.append("  No bitmap will be produced").append(BitmapParameters.SHINGLE_SIZE).append(CR);
            } else {
                sb.append("  Bitmap filename specified:   ").append(BitmapParameters.BITMAP_FILE).append(CR);
            }
            sb.append(CR);
            LOGGER.info("{}", (Object)sb.toString());
            Map<String, List<double[]>> data = UCRUtils.readUCRData(BitmapParameters.IN_FILE);
            LOGGER.info("read from {}", (Object)BitmapParameters.IN_FILE);
            LOGGER.info("{}", (Object)UCRUtils.datasetStats(data, ""));
            HashMap res = new HashMap();
            TreeSet<String> shinglesSet = null;
            for (Map.Entry<String, List<double[]>> entry : data.entrySet()) {
                String string = entry.getKey();
                for (double[] series : entry.getValue()) {
                    Map<String, Integer> map = sp.ts2Shingles(series, BitmapParameters.SAX_WINDOW_SIZE, BitmapParameters.SAX_PAA_SIZE, BitmapParameters.SAX_ALPHABET_SIZE, BitmapParameters.SAX_NR_STRATEGY, BitmapParameters.SAX_NORM_THRESHOLD, BitmapParameters.SHINGLE_SIZE);
                    if (!res.containsKey(string)) {
                        res.put(string, new ArrayList());
                    }
                    if (null == shinglesSet) {
                        shinglesSet = new TreeSet<String>(map.keySet());
                    }
                    Object arr = new Integer[shinglesSet.size()];
                    int i = 0;
                    for (String shingle : shinglesSet) {
                        arr[i] = map.get(shingle);
                        ++i;
                    }
                    ((List)res.get(string)).add(arr);
                }
            }
            LOGGER.info("writing shingled output...");
            StringBuffer shinglesStr = new StringBuffer(BitmapParameters.SHINGLE_SIZE * (shinglesSet.size() + 2));
            for (String string : shinglesSet) {
                shinglesStr.append(QUOTE).append(string).append(QUOTE).append(COMMA);
            }
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(new File(BitmapParameters.OUT_FILE)));
            bufferedWriter.write("'class_label'," + shinglesStr.delete(shinglesStr.length() - 1, shinglesStr.length()).toString());
            bufferedWriter.write(CR);
            for (Map.Entry entry : res.entrySet()) {
                String classLabel = (String)entry.getKey();
                for (Object arr : (List)entry.getValue()) {
                    String str = Arrays.toString((Object[])arr).replaceAll("[\\[\\]\\s]", "");
                    bufferedWriter.write(QUOTE + (String)classLabel + QUOTE + COMMA + str + CR);
                }
            }
            bufferedWriter.close();
            LOGGER.info("done!");
            if (null == BitmapParameters.BITMAP_FILE) {
                System.exit(10);
            }
            LOGGER.info("producing bitmap for the dataset");
            HashSet<Integer> hashSet = new HashSet<Integer>(shinglesSet.size());
            boolean bl = false;
            while (var10_20 < shinglesSet.size()) {
                hashSet.add((int)var10_20);
                ++var10_20;
            }
            boolean bl2 = false;
            for (Map.Entry entry : res.entrySet()) {
                var10_22 += ((List)entry.getValue()).size();
                for (Integer[] arr : (List)entry.getValue()) {
                    HashSet<Integer> tmpZeroes = new HashSet<Integer>();
                    for (int i = 0; i < arr.length; ++i) {
                        if (!arr[i].equals(0)) continue;
                        tmpZeroes.add(i);
                    }
                    hashSet.retainAll(tmpZeroes);
                }
            }
            ArrayList<String> prunedShingles = new ArrayList<String>();
            boolean bl3 = false;
            for (String shingle : shinglesSet) {
                void var12_30;
                if (hashSet.contains((int)var12_30)) {
                    prunedShingles.add(shingle);
                }
                ++var12_30;
            }
            LOGGER.info("dropped zero-column shingles: {}", (Object)Arrays.toString(prunedShingles.toArray(new String[prunedShingles.size()])));
            double[][] heatmapData = new double[var10_22][shinglesSet.size() - hashSet.size()];
            ArrayList<String> yLabels = new ArrayList<String>();
            int currRow = 0;
            for (Map.Entry e : res.entrySet()) {
                int currArrayIdx = 0;
                for (Integer[] arr : (List)e.getValue()) {
                    yLabels.add((String)e.getKey() + "_" + currArrayIdx);
                    heatmapData[currRow] = UCRdataBitmapPrinter.toDoubleAray(arr, hashSet);
                    ++currRow;
                    ++currArrayIdx;
                }
            }
            HeatChart chart = new HeatChart(heatmapData);
            chart.setAxisColour(Color.WHITE);
            chart.setAxisThickness(2);
            chart.setYValues(yLabels.toArray(new String[yLabels.size()]));
            chart.setShowYAxisValues(true);
            chart.setXValues(UCRdataBitmapPrinter.toShingleLabelsArray(shinglesSet.toArray(new String[shinglesSet.size()]), hashSet));
            chart.setShowXAxisValues(true);
            chart.setXValuesHorizontal(false);
            chart.setTitle(BitmapParameters.IN_FILE);
            chart.setCellSize(new Dimension(10, 10));
            chart.saveToFile(new File(BitmapParameters.BITMAP_FILE));
        }
    }

    private static String[] toShingleLabelsArray(String[] array, HashSet<Integer> zeroIndices) {
        String[] res = new String[array.length - zeroIndices.size()];
        int skip = 0;
        for (int i = 0; i < array.length; ++i) {
            if (zeroIndices.contains(i)) {
                ++skip;
                continue;
            }
            res[i - skip] = array[i];
        }
        return res;
    }

    private static double[] toDoubleAray(Integer[] intArray, HashSet<Integer> skipIndex) {
        double[] res = new double[intArray.length - skipIndex.size()];
        int skip = 0;
        for (int i = 0; i < intArray.length; ++i) {
            if (skipIndex.contains(i)) {
                ++skip;
                continue;
            }
            res[i - skip] = intArray[i].doubleValue();
        }
        return res;
    }
}

