/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.sax;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;
import net.seninp.jmotif.sax.SAXException;
import net.seninp.jmotif.sax.TSProcessor;
import net.seninp.jmotif.sax.alphabet.Alphabet;
import net.seninp.jmotif.sax.alphabet.NormalAlphabet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestTSProcessor {
    private static final String ts1File = "src/resources/test-data/timeseries01.csv";
    private static final String ts2File = "src/resources/test-data/timeseries02.csv";
    private static final String ts1NormFile = "src/resources/test-data/timeseries01.norm.csv";
    private static final String ts2NormFile = "src/resources/test-data/timeseries02.norm.csv";
    private static final String ts1PAAFile = "src/resources/test-data/timeseries01.PAA10.csv";
    private static final String ts2PAAFile = "src/resources/test-data/timeseries02.PAA10.csv";
    private static final int length = 15;
    private static final int PAAlength = 10;
    private static final double delta = 1.0E-6;
    private static final double ts1Max = 9.2;
    private static final double ts1Min = 1.34;
    private static final double ts2Max = 8.83;
    private static final double ts2Min = 0.5;
    private static final Alphabet normalA = new NormalAlphabet();
    TSProcessor tsp;
    private double[] ts1;
    private double[] ts2;

    @Before
    public void setUp() throws Exception {
        this.tsp = new TSProcessor();
        this.ts1 = this.tsp.readTS(ts1File, 15);
        this.ts2 = this.tsp.readTS(ts2File, 15);
    }

    @Test
    public void testExtremum() {
        Assert.assertEquals("max", 9.2, this.tsp.max(this.ts1), 1.0E-6);
        Assert.assertEquals("max", 8.83, this.tsp.max(this.ts2), 1.0E-6);
        Assert.assertEquals("min", 1.34, this.tsp.min(this.ts1), 1.0E-6);
        Assert.assertEquals("min", 0.5, this.tsp.min(this.ts2), 1.0E-6);
        this.ts1[1] = Double.NaN;
        this.ts2[2] = Double.NaN;
        Assert.assertEquals("max", 9.2, this.tsp.max(this.ts1), 1.0E-6);
        Assert.assertEquals("max", 8.83, this.tsp.max(this.ts2), 1.0E-6);
        Assert.assertEquals("min", 1.34, this.tsp.min(this.ts1), 1.0E-6);
        Assert.assertEquals("min", 0.5, this.tsp.min(this.ts2), 1.0E-6);
    }

    @Test
    public void testMedian() {
        Assert.assertEquals("testing the mean", 3.85, this.tsp.median(this.ts1), 1.0E-6);
        Assert.assertEquals("testing the mean", 3.83, this.tsp.median(this.ts2), 1.0E-6);
        Assert.assertEquals("testing the mean", 4.85, this.tsp.median(Arrays.copyOfRange(this.ts1, 0, 13)), 1.0E-6);
    }

    @Test
    public void testMean() {
        Assert.assertEquals("testing the mean", 4.606667, this.tsp.mean(this.ts1), 1.0E-6);
        Assert.assertEquals("testing the mean", 4.01, this.tsp.mean(this.ts2), 1.0E-6);
        double[] badArrayDouble = new double[]{};
        Assert.assertTrue("testing the mean", Double.isNaN(this.tsp.mean(badArrayDouble)));
        int[] arr = new int[]{1, 5, 8, 7, 6};
        Assert.assertEquals("testing the mean", 5.4, this.tsp.mean(arr), 1.0E-6);
        int[] badArrayInt = new int[]{};
        Assert.assertTrue("testing the mean", Double.isNaN(this.tsp.mean(badArrayInt)));
    }

    @Test
    public void testVar() {
        Assert.assertEquals("variance", 6.971267, this.tsp.var(this.ts1), 1.0E-6);
        Assert.assertEquals("variance", 7.409971, this.tsp.var(this.ts2), 1.0E-6);
        double[] badArray = new double[]{};
        Assert.assertTrue("testing the mean", Double.isNaN(this.tsp.var(badArray)));
    }

    @Test
    public void testStdev() {
        Assert.assertEquals("stdev", 2.640316, this.tsp.stDev(this.ts1), 1.0E-6);
    }

    @Test
    public void testZNormalize() throws Exception {
        int i;
        int i2;
        double[] ts1Norm = this.tsp.readTS(ts1NormFile, 15);
        double[] ts2Norm = this.tsp.readTS(ts2NormFile, 15);
        double[] ts1NormTest = this.tsp.znorm(this.ts1, 0.001);
        double[] ts2NormTest = this.tsp.znorm(this.ts2, 0.001);
        for (i2 = 0; i2 < ts1Norm.length; ++i2) {
            Assert.assertEquals("normalization", ts1Norm[i2], ts1NormTest[i2], 1.0E-6);
        }
        for (i2 = 0; i2 < ts2Norm.length; ++i2) {
            Assert.assertEquals("normalization", ts2Norm[i2], ts2NormTest[i2], 1.0E-6);
        }
        double[] ts1normOne = this.tsp.normOne(this.ts1);
        double[] ts2normOne = this.tsp.normOne(this.ts2);
        boolean seenOne = false;
        for (i = 0; i < ts1normOne.length; ++i) {
            Assert.assertTrue(ts1normOne[i] <= 1.0);
            if (ts1normOne[i] != 1.0) continue;
            seenOne = true;
        }
        Assert.assertTrue(seenOne);
        seenOne = false;
        for (i = 0; i < ts2normOne.length; ++i) {
            Assert.assertTrue(ts2normOne[i] <= 1.0);
            if (ts2normOne[i] != 1.0) continue;
            seenOne = true;
        }
        Assert.assertTrue(seenOne);
        double[] zeros = this.tsp.znorm(this.ts1, this.tsp.stDev(this.ts1) + 0.1);
        for (int i3 = 0; i3 < zeros.length; ++i3) {
            Assert.assertEquals(0.0, zeros[i3], 1.0E-5);
        }
    }

    @Test
    public void testPAA() throws Exception {
        int i;
        double[] ts1Norm = this.tsp.readTS(ts1NormFile, 15);
        double[] ts2Norm = this.tsp.readTS(ts2NormFile, 15);
        double[] ts1PAA10 = this.tsp.readTS(ts1PAAFile, 10);
        double[] ts2PAA10 = this.tsp.readTS(ts2PAAFile, 10);
        double[] ts1PAATest = this.tsp.paa(ts1Norm, 10);
        double[] ts2PAATest = this.tsp.paa(ts2Norm, 10);
        for (i = 0; i < ts1PAA10.length; ++i) {
            Assert.assertEquals("PAA", ts1PAA10[i], ts1PAATest[i], 1.0E-6);
        }
        for (i = 0; i < ts2PAA10.length; ++i) {
            Assert.assertEquals("PAA", ts2PAA10[i], ts2PAATest[i], 1.0E-6);
        }
        try {
            double[] failedPAA = this.tsp.paa(ts1Norm, ts1Norm.length + 1);
            Assert.fail("exception should be thrown!");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testNum2Char() throws SAXException {
        Assert.assertEquals("test num2char", 97L, this.tsp.num2char(-0.5, normalA.getCuts(2)));
        Assert.assertEquals("test num2char", 98L, this.tsp.num2char(0.5, normalA.getCuts(2)));
        Assert.assertEquals("test num2char", 98L, this.tsp.num2char(0.0, normalA.getCuts(2)));
        double[] ts0 = new double[]{-0.5, 0.5, 0.0};
        Assert.assertTrue("test num2char", "abb".equalsIgnoreCase(new String(this.tsp.ts2String(ts0, normalA.getCuts(2)))));
        Assert.assertEquals("test num2char", 100L, this.tsp.num2char(-0.179, normalA.getCuts(7)));
        Assert.assertEquals("test num2char", 100L, this.tsp.num2char(-0.18, normalA.getCuts(7)));
        Assert.assertEquals("test num2char", 99L, this.tsp.num2char(-0.1801, normalA.getCuts(7)));
        double[] ts1 = new double[]{-0.179, -0.18, -0.1801};
        Assert.assertTrue("test num2char", "ddc".equalsIgnoreCase(new String(this.tsp.ts2String(ts1, normalA.getCuts(7)))));
        Assert.assertEquals("test num2char", 97L, this.tsp.num2char(0));
    }

    @Test
    public void testTS2Index() throws Exception {
        double[] ts1PAA10 = this.tsp.readTS(ts1PAAFile, 10);
        int[] idx1 = this.tsp.ts2Index(ts1PAA10, normalA.getCuts(10));
        Assert.assertEquals("Testing ts2index", (Object)idx1[1], (Object)2);
        Assert.assertEquals("Testing ts2index", (Object)idx1[3], (Object)9);
        Assert.assertEquals("Testing ts2index", (Object)idx1[7], (Object)4);
    }

    @Test
    public void testSeries2String() {
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
        DecimalFormat df = (DecimalFormat)nf;
        df.applyPattern("#.0");
        double[] formattedTs = new double[]{-1.07, -0.57, -0.18, 0.18, 0.57, 1.07};
        String seriesAsString = this.tsp.seriesToString(formattedTs, df);
        Assert.assertTrue(seriesAsString.contains("-1.1"));
        Assert.assertTrue(seriesAsString.contains(".6"));
        Assert.assertTrue(seriesAsString.contains("-.6"));
    }

    @Test
    public void series2String() throws SAXException, IOException {
        double[] ts1Norm = this.tsp.readTS(ts1NormFile, 15);
        double[] ts2Norm = this.tsp.readTS(ts2NormFile, 15);
        double[] cp1 = this.tsp.subseriesByCopy(ts1Norm, 3, 7);
        for (int i = 3; i < 7; ++i) {
            Assert.assertEquals("testing copy routines", cp1[i - 3], ts1Norm[i], 1.0E-6);
        }
        try {
            double[] cp2 = this.tsp.subseriesByCopy(ts2Norm, 3, 755);
            Assert.assertEquals("testing copy routines", cp2[1], ts1Norm[3], 1.0E-6);
            Assert.fail("Exception is not thrown");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testFileLoadExceptions() {
        double[] dat2;
        try {
            dat2 = this.tsp.readTS("non-existent-file", 0);
            Assert.fail("exception should be thrown!");
        }
        catch (Exception dat2) {
            // empty catch block
        }
        try {
            dat2 = TSProcessor.readFileColumn("non-existent-file", 0, 0);
            Assert.fail("exception should be thrown!");
        }
        catch (Exception dat3) {
            // empty catch block
        }
        try {
            dat2 = TSProcessor.readFileColumn("src//resources//dataset//asys40.txt", 3, 0);
            Assert.fail("exception should be thrown!");
        }
        catch (Exception dat4) {
            // empty catch block
        }
        try {
            dat2 = TSProcessor.readFileColumn("src//resources//dataset//asys40.txt", 0, 0);
            Assert.assertEquals(7500L, dat2.length);
        }
        catch (Exception e) {
            Assert.fail("exception should not be thrown!");
        }
    }
}

