/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.sax;

import net.seninp.jmotif.sax.SAXProcessor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestApproxDistance {
    private static final double[] series = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0};
    private static final double[] series2 = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0};
    private SAXProcessor sp;

    @Before
    public void setUp() throws Exception {
        this.sp = new SAXProcessor();
    }

    @Test
    public void test() {
        try {
            double dist = this.sp.approximationDistancePAA(series, 15, 7, 5.0);
            Assert.assertEquals("testing approx distance", 0.53333333, dist, 1.0E-6);
            dist = this.sp.approximationDistancePAA(series2, 15, 7, 5.0);
            Assert.assertEquals("testing approx distance", 0.53333333, dist, 1.0E-6);
            double distZnorm = this.sp.approximationDistancePAA(series, 15, 7, 0.01);
            distZnorm = this.sp.approximationDistancePAA(series2, 15, 7, 0.01);
            Assert.assertEquals("testing approx distance", 0.1192569, distZnorm, 1.0E-6);
            double newApproximationDistance = this.sp.approximationDistanceAlphabet(series, 15, 7, 3, 0.01);
            Assert.assertEquals("testing approx distance", 0.2764062, newApproximationDistance, 0.01);
        }
        catch (Exception e) {
            Assert.fail("exception shall not be thrown!");
        }
    }
}

