/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.distance;

public final class EuclideanDistance {
    public double distance(double p1, double p2) {
        double d = (p1 - p2) * (p1 - p2);
        return Math.sqrt(d);
    }

    public double distance(double[] point1, double[] point2) throws Exception {
        return Math.sqrt(this.distance2(point1, point2));
    }

    public double distance(int[] point1, int[] point2) throws Exception {
        return Math.sqrt(Long.valueOf(this.distance2(point1, point2)).doubleValue());
    }

    public double distance2(double p1, double p2) {
        return (p1 - p2) * (p1 - p2);
    }

    public double distance2(double[] point1, double[] point2) throws Exception {
        if (point1.length == point2.length) {
            Double sum = 0.0;
            for (int i = 0; i < point1.length; ++i) {
                double tmp = point2[i] - point1[i];
                sum = sum + tmp * tmp;
            }
            return sum;
        }
        throw new Exception("Exception in Euclidean distance: array lengths are not equal");
    }

    public long distance2(int[] point1, int[] point2) throws Exception {
        if (point1.length == point2.length) {
            long sum = 0L;
            for (int i = 0; i < point1.length; ++i) {
                sum += (long)((point2[i] - point1[i]) * (point2[i] - point1[i]));
            }
            return sum;
        }
        throw new Exception("Exception in Euclidean distance: array lengths are not equal");
    }

    public double seriesDistance(double[][] series1, double[][] series2) throws Exception {
        if (series1.length == series2.length) {
            Double res = 0.0;
            for (int i = 0; i < series1.length; ++i) {
                res = res + this.distance2(series1[i], series2[i]);
            }
            return Math.sqrt(res);
        }
        throw new Exception("Exception in Euclidean distance: array lengths are not equal");
    }

    public double normalizedDistance(double[] point1, double[] point2) throws Exception {
        return Math.sqrt(this.distance2(point1, point2)) / (double)point1.length;
    }

    public Double earlyAbandonedDistance(double[] series1, double[] series2, double cutoff) throws Exception {
        if (series1.length == series2.length) {
            double cutOff2 = cutoff;
            if (Double.MAX_VALUE != cutoff) {
                cutOff2 = cutoff * cutoff;
            }
            Double res = 0.0;
            for (int i = 0; i < series1.length; ++i) {
                if (!((res = Double.valueOf(res + this.distance2(series1[i], series2[i]))) > cutOff2)) continue;
                return Double.NaN;
            }
            return Math.sqrt(res);
        }
        throw new Exception("Exception in Euclidean distance: array lengths are not equal");
    }
}

