/*
 * Decompiled with CFR 0.152.
 */
package org.happy.concurrent.synchronizers.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicLong;
import org.happy.commons.patterns.Lockable_1x0;
import org.happy.commons.patterns.executable.Executable_1x2;
import org.happy.commons.util.Pair_1x0;
import org.happy.concurrent.synchronizers.MultiLock_1x3;
import org.happy.concurrent.synchronizers.Synchronizer_1x3;
import org.happy.concurrent.synchronizers.exception.MultiLockException_1x3;
import org.happy.concurrent.synchronizers.impl.AbstractMultiLock_1x3;

public abstract class AbstractSynchronizer_1x3<L>
implements Synchronizer_1x3<L>,
Lockable_1x0 {
    protected final MultiLockLevelComparator multiLockLevelComparator = new MultiLockLevelComparator();
    private static AtomicLong idGenerator = new AtomicLong(0L);
    private Map<Thread, Stack<AbstractMultiLock_1x3<L>>> threadStackMap;
    private Map<L, SortedSet<AbstractMultiLock_1x3<L>>> locksMap;
    private Long id;
    private Object lock = new Object();

    public AbstractSynchronizer_1x3() {
        this.id = idGenerator.incrementAndGet();
        this.threadStackMap = new HashMap<Thread, Stack<AbstractMultiLock_1x3<L>>>();
        this.locksMap = new HashMap<L, SortedSet<AbstractMultiLock_1x3<L>>>();
    }

    protected Map<Thread, Stack<AbstractMultiLock_1x3<L>>> getThreadStackMap() {
        return this.threadStackMap;
    }

    protected Map<L, SortedSet<AbstractMultiLock_1x3<L>>> getLocksMap() {
        return this.locksMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <R> R synchronize(Map<L, MultiLock_1x3.Permission_1x3> locksMap, Executable_1x2<R, MultiLock_1x3<L>> command) throws MultiLockException_1x3 {
        AbstractMultiLock_1x3<L> mLock = null;
        Object object = this.lock;
        synchronized (object) {
            this.validateLocks(locksMap);
            AbstractMultiLock_1x3<L> parent = null;
            Thread currentThread = Thread.currentThread();
            Stack<AbstractMultiLock_1x3<Object>> lockStack = this.getThreadStackMap().get(currentThread);
            if (lockStack == null) {
                lockStack = new Stack();
                this.getThreadStackMap().put(currentThread, lockStack);
            } else {
                parent = lockStack.peek();
            }
            Preconditions.checkNotNull(lockStack);
            mLock = this.createMultiLock(parent);
            mLock.getLocksMap().putAll(locksMap);
            Preconditions.checkNotNull(mLock);
            lockStack.push(mLock);
        }
        this.lock(mLock);
        R res = command.execute(mLock);
        this.release(mLock);
        return res;
    }

    protected abstract void lock(AbstractMultiLock_1x3<L> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release(MultiLock_1x3<L> mLock) {
        Object object = this.lock;
        synchronized (object) {
            Thread t = Thread.currentThread();
            Stack<AbstractMultiLock_1x3<L>> lockStack = this.threadStackMap.get(t);
            if (lockStack == null) {
                return;
            }
            Preconditions.checkArgument((!lockStack.isEmpty() ? 1 : 0) != 0);
            if (lockStack.peek().equals(mLock)) {
                if (lockStack.size() == 1) {
                    lockStack.clear();
                    this.threadStackMap.remove(t);
                } else {
                    lockStack.pop();
                }
            }
            Map<L, SortedSet<AbstractMultiLock_1x3<L>>> locksSetMap = this.getLocksMap();
            for (L lock : mLock.getLocksMap().keySet()) {
                SortedSet<AbstractMultiLock_1x3<L>> set = locksSetMap.get(lock);
                if (set == null) continue;
                set.remove(mLock);
                if (!set.isEmpty()) continue;
                locksSetMap.remove(lock);
            }
        }
        mLock.unlock();
    }

    private void validateLocks(Map<L, MultiLock_1x3.Permission_1x3> newLocksMap) throws MultiLockException_1x3 {
        Set<Map.Entry<L, MultiLock_1x3.Permission_1x3>> newEntrySet = newLocksMap.entrySet();
        if (newEntrySet.isEmpty()) {
            throw new IllegalArgumentException("MultiLock doesn't lock any locks and makes no sense to be executed!");
        }
        Thread t = Thread.currentThread();
        Stack<AbstractMultiLock_1x3<L>> lockStack = this.threadStackMap.get(t);
        if (lockStack == null) {
            return;
        }
        MultiLock_1x3 parentMultiLock = lockStack.peek();
        Map currentLocksMap = parentMultiLock.getLocksMap();
        for (Map.Entry<L, MultiLock_1x3.Permission_1x3> entry : newEntrySet) {
            MultiLock_1x3.Permission_1x3 newPermison = currentLocksMap.get(entry.getKey());
            if (newPermison == null) {
                throw new MultiLockException_1x3("The lock: " + entry.getKey() + " was not locked in parent MultiLock: " + parentMultiLock.toString() + "!");
            }
            if (newPermison.ordinal() <= entry.getValue().ordinal()) continue;
            throw new MultiLockException_1x3("The permission for lock: " + entry.getKey() + " was " + (Object)((Object)entry.getValue()) + "but in the parent MultiLock " + parentMultiLock.toString() + " it was " + (Object)((Object)entry.getValue()) + ". New permission is to restrective! You have to reduce the Permission to the most restrictiveness of the parent MultiLock!");
        }
    }

    @Override
    public Long getID() {
        return this.id;
    }

    @Override
    public Float getVersion() {
        return Float.valueOf(1.3f);
    }

    @Override
    public Object getLockObject() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLockObject(Object lockObject) {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkNotNull((Object)lockObject);
            Preconditions.checkArgument((boolean)this.locksMap.isEmpty(), (Object)"Scheduler executes code and use the lock, thus it can't be seted!");
            this.lock = lockObject;
        }
    }

    protected abstract AbstractMultiLock_1x3<L> createMultiLock(AbstractMultiLock_1x3<L> var1);

    protected boolean dependencyExists(MultiLock_1x3.Permission_1x3 requiredPerm, MultiLock_1x3.Permission_1x3 currentPerm) {
        Preconditions.checkNotNull((Object)((Object)requiredPerm));
        Preconditions.checkNotNull((Object)((Object)currentPerm));
        switch (requiredPerm) {
            case Unlocked: {
                return false;
            }
            case Read: {
                switch (currentPerm) {
                    case Unlocked: {
                        return false;
                    }
                    case Read: {
                        return false;
                    }
                }
                return true;
            }
            case Write: {
                switch (currentPerm) {
                    case Unlocked: {
                        return false;
                    }
                }
                return true;
            }
        }
        throw new IllegalStateException(requiredPerm.name() + " is not supported!");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractSynchronizer_1x3 other = (AbstractSynchronizer_1x3)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "AbstractSynchronizer_1x3 [id=" + this.id + "]";
    }

    @Override
    public final <R> R synchronize(L l1, MultiLock_1x3.Permission_1x3 p1, Executable_1x2<R, MultiLock_1x3<L>> command) throws MultiLockException_1x3 {
        Preconditions.checkNotNull(l1);
        Preconditions.checkNotNull((Object)((Object)p1));
        Preconditions.checkNotNull(command);
        ImmutableMap map = ImmutableMap.of(l1, (Object)((Object)p1));
        return this.synchronize((Map<L, MultiLock_1x3.Permission_1x3>)map, command);
    }

    @Override
    public final <R> R synchronize(L l1, MultiLock_1x3.Permission_1x3 p1, L l2, MultiLock_1x3.Permission_1x3 p2, Executable_1x2<R, MultiLock_1x3<L>> command) throws MultiLockException_1x3 {
        Preconditions.checkNotNull(l1);
        Preconditions.checkNotNull((Object)((Object)p1));
        Preconditions.checkNotNull(l2);
        Preconditions.checkNotNull((Object)((Object)p2));
        Preconditions.checkNotNull(command);
        ImmutableList locksList = ImmutableList.of(Pair_1x0.of(l1, p1), Pair_1x0.of(l2, p2));
        Map<L, MultiLock_1x3.Permission_1x3> map = this.createMap((List<Pair_1x0<L, MultiLock_1x3.Permission_1x3>>)locksList);
        return this.synchronize(map, command);
    }

    protected Map<L, MultiLock_1x3.Permission_1x3> createMap(List<Pair_1x0<L, MultiLock_1x3.Permission_1x3>> locksList) {
        HashMap<L, MultiLock_1x3.Permission_1x3> map = new HashMap<L, MultiLock_1x3.Permission_1x3>();
        for (Pair_1x0<L, MultiLock_1x3.Permission_1x3> pair : locksList) {
            L lock = pair.getFst();
            MultiLock_1x3.Permission_1x3 perm = pair.getSnd();
            MultiLock_1x3.Permission_1x3 currentPerm = (MultiLock_1x3.Permission_1x3)((Object)map.get(lock));
            if (currentPerm == null) {
                map.put(lock, perm);
                continue;
            }
            if (currentPerm.getPriority() >= perm.getPriority()) continue;
            map.put(lock, perm);
        }
        return map;
    }

    @Override
    public final <R> R synchronize(L l1, MultiLock_1x3.Permission_1x3 p1, L l2, MultiLock_1x3.Permission_1x3 p2, L l3, MultiLock_1x3.Permission_1x3 p3, Executable_1x2<R, MultiLock_1x3<L>> command) throws MultiLockException_1x3 {
        Preconditions.checkNotNull(l1);
        Preconditions.checkNotNull((Object)((Object)p1));
        Preconditions.checkNotNull(l2);
        Preconditions.checkNotNull((Object)((Object)p2));
        Preconditions.checkNotNull(l3);
        Preconditions.checkNotNull((Object)((Object)p3));
        Preconditions.checkNotNull(command);
        ImmutableList locksList = ImmutableList.of(Pair_1x0.of(l1, p1), Pair_1x0.of(l2, p2), Pair_1x0.of(l3, p3));
        Map<L, MultiLock_1x3.Permission_1x3> map = this.createMap((List<Pair_1x0<L, MultiLock_1x3.Permission_1x3>>)locksList);
        return this.synchronize(map, command);
    }

    @Override
    public final <R> R synchronize(L l1, MultiLock_1x3.Permission_1x3 p1, L l2, MultiLock_1x3.Permission_1x3 p2, L l3, MultiLock_1x3.Permission_1x3 p3, L l4, MultiLock_1x3.Permission_1x3 p4, Executable_1x2<R, MultiLock_1x3<L>> command) throws MultiLockException_1x3 {
        Preconditions.checkNotNull(l1);
        Preconditions.checkNotNull((Object)((Object)p1));
        Preconditions.checkNotNull(l2);
        Preconditions.checkNotNull((Object)((Object)p2));
        Preconditions.checkNotNull(l3);
        Preconditions.checkNotNull((Object)((Object)p3));
        Preconditions.checkNotNull(l4);
        Preconditions.checkNotNull((Object)((Object)p4));
        Preconditions.checkNotNull(command);
        ImmutableList locksList = ImmutableList.of(Pair_1x0.of(l1, p1), Pair_1x0.of(l2, p2), Pair_1x0.of(l3, p3), Pair_1x0.of(l4, p4));
        Map<L, MultiLock_1x3.Permission_1x3> map = this.createMap((List<Pair_1x0<L, MultiLock_1x3.Permission_1x3>>)locksList);
        return this.synchronize(map, command);
    }

    @Override
    public final <R> R synchronize(L l1, MultiLock_1x3.Permission_1x3 p1, L l2, MultiLock_1x3.Permission_1x3 p2, L l3, MultiLock_1x3.Permission_1x3 p3, L l4, MultiLock_1x3.Permission_1x3 p4, L l5, MultiLock_1x3.Permission_1x3 p5, Executable_1x2<R, MultiLock_1x3<L>> command) throws MultiLockException_1x3 {
        Preconditions.checkNotNull(l1);
        Preconditions.checkNotNull((Object)((Object)p1));
        Preconditions.checkNotNull(l2);
        Preconditions.checkNotNull((Object)((Object)p2));
        Preconditions.checkNotNull(l3);
        Preconditions.checkNotNull((Object)((Object)p3));
        Preconditions.checkNotNull(l4);
        Preconditions.checkNotNull((Object)((Object)p4));
        Preconditions.checkNotNull(l5);
        Preconditions.checkNotNull((Object)((Object)p5));
        Preconditions.checkNotNull(command);
        ImmutableList locksList = ImmutableList.of(Pair_1x0.of(l1, p1), Pair_1x0.of(l2, p2), Pair_1x0.of(l3, p3), Pair_1x0.of(l4, p4), Pair_1x0.of(l5, p5));
        Map<L, MultiLock_1x3.Permission_1x3> map = this.createMap((List<Pair_1x0<L, MultiLock_1x3.Permission_1x3>>)locksList);
        return this.synchronize(map, command);
    }

    protected class MultiLockLevelComparator
    implements Comparator<AbstractMultiLock_1x3<?>> {
        protected MultiLockLevelComparator() {
        }

        @Override
        public int compare(AbstractMultiLock_1x3<?> o1, AbstractMultiLock_1x3<?> o2) {
            return (int)(o1.getLevel() - o2.getLevel());
        }
    }
}

