/*
 * Decompiled with CFR 0.152.
 */
package org.happy.commons.patterns;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public interface Generator_1x0<T> {
    public T generate();

    public static class Utils {
        public static <T> List<T> generateList(Generator_1x0<T> g, int size) {
            Preconditions.checkNotNull(g);
            Preconditions.checkArgument((0 < size ? 1 : 0) != 0);
            ArrayList<T> list = new ArrayList<T>();
            for (int i = 0; i < size; ++i) {
                Preconditions.checkState((boolean)list.add(g.generate()));
            }
            return list;
        }

        public static <T> Set<T> generateSet(Generator_1x0<T> g, int size) {
            Preconditions.checkNotNull(g);
            Preconditions.checkArgument((0 < size ? 1 : 0) != 0);
            HashSet<T> set = new HashSet<T>();
            int counter = 0;
            while (set.size() < size) {
                set.add(g.generate());
                if (size * 10 >= ++counter) continue;
                throw new IllegalStateException("It seems to be that generator: " + g.toString() + " can't generate enogh diffrent elements and runs in endless loop!");
            }
            return set;
        }
    }
}

