/*
 * Decompiled with CFR 0.152.
 */
package org.happy.commons.io.streams.decorators;

import com.google.common.base.Preconditions;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Timer;
import org.happy.commons.io.streams.decorators.OutputStreamDecorator_1x2;
import org.happy.commons.patterns.observer.Delegate_1x0;
import org.happy.commons.patterns.observer.Delegate_1x0Impl;
import org.happy.commons.patterns.observer.event.ActionEventAfter_1x0;

public class EventOutputStream_1x2
extends OutputStreamDecorator_1x2 {
    private int fireAfterByteNumber;
    private AtomicInteger byteCounter = new AtomicInteger(0);
    private AtomicInteger allByteCounter = new AtomicInteger(0);
    private AtomicBoolean isSubMethodCall = new AtomicBoolean(false);
    private AtomicInteger idCounter = new AtomicInteger(0);
    private Delegate_1x0<ActionEventAfter_1x0<Integer>> onWriteEvent;
    private int timeDelay = 5;
    private Timer timer;
    private AtomicInteger maxByteNumber = new AtomicInteger(-1);

    public static EventOutputStream_1x2 of(OutputStream os, int fireAfterByteNumber, int timeDalay) {
        Preconditions.checkNotNull((Object)os);
        return new EventOutputStream_1x2(os, fireAfterByteNumber, timeDalay);
    }

    public EventOutputStream_1x2(OutputStream os, int fireAfterByteNumber) {
        this(os, fireAfterByteNumber, 5);
    }

    public EventOutputStream_1x2(OutputStream os, int fireAfterByteNumber, int timeDalay) {
        super(os);
        Preconditions.checkArgument((0 < fireAfterByteNumber ? 1 : 0) != 0);
        Preconditions.checkArgument((0 < timeDalay ? 1 : 0) != 0);
        this.timeDelay = timeDalay;
        this.fireAfterByteNumber = fireAfterByteNumber;
        this.onWriteEvent = new Delegate_1x0Impl<ActionEventAfter_1x0<Integer>>();
        this.timer = new Timer(this.timeDelay, new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                int count = 0;
                AtomicInteger atomicInteger = EventOutputStream_1x2.this.byteCounter;
                synchronized (atomicInteger) {
                    count = EventOutputStream_1x2.this.allByteCounter.addAndGet(EventOutputStream_1x2.this.byteCounter.get());
                    EventOutputStream_1x2.this.byteCounter.set(0);
                }
                if (0 < count) {
                    EventOutputStream_1x2.this.fireOnWriteEventEvent(count);
                }
            }
        });
        this.timer.setRepeats(false);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.isSubMethodCall.get()) {
            this.decorated.write(b);
        } else {
            this.isSubMethodCall.set(true);
            this.decorated.write(b);
            this.isSubMethodCall.set(false);
            this.tryToFireEvent(1);
        }
    }

    @Override
    public void write(byte[] buffer, int offset, int count) throws IOException {
        if (offset > buffer.length || offset < 0 || count < 0 || count > buffer.length - offset) {
            throw new IndexOutOfBoundsException("OutStream could not be written because buffer overflow!");
        }
        for (int i = offset; i < offset + count; ++i) {
            this.write(buffer[i]);
        }
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tryToFireEvent(int bytesNumber) {
        this.timer.restart();
        int count = 0;
        int allBytesCount = -1;
        AtomicInteger atomicInteger = this.byteCounter;
        synchronized (atomicInteger) {
            count = this.byteCounter.addAndGet(bytesNumber);
            if (this.fireAfterByteNumber <= count) {
                allBytesCount = this.allByteCounter.addAndGet(count);
                this.byteCounter.set(0);
            }
        }
        if (this.fireAfterByteNumber <= count) {
            this.fireOnWriteEventEvent(allBytesCount);
        }
    }

    private void fireOnWriteEventEvent(int count) {
        if (this.onWriteEvent == null) {
            return;
        }
        if (this.maxByteNumber.get() >= count) {
            return;
        }
        this.maxByteNumber.set(count);
        this.onWriteEvent.fire(new ActionEventAfter_1x0<Integer>((Object)this, this.idCounter.getAndIncrement(), "READ BYTES NUMBER", new Integer(count)));
    }

    public Delegate_1x0<ActionEventAfter_1x0<Integer>> getOnWriteEvent() {
        if (this.onWriteEvent == null) {
            this.onWriteEvent = new Delegate_1x0Impl<ActionEventAfter_1x0<Integer>>();
        }
        return this.onWriteEvent;
    }

    public int getTimeDelay() {
        return this.timeDelay;
    }
}

