/*
 * Decompiled with CFR 0.152.
 */
package org.happy.commons.io.streams.decorators;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.happy.commons.io.streams.decorators.OutputStreamDecorator_1x2;

public class BlockingOutputStream_1x2
extends OutputStreamDecorator_1x2 {
    AtomicBoolean closedMutex = new AtomicBoolean(false);

    public static BlockingOutputStream_1x2 of(OutputStream os) {
        return new BlockingOutputStream_1x2(os);
    }

    public BlockingOutputStream_1x2(OutputStream os) {
        super(os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        super.close();
        AtomicBoolean atomicBoolean = this.closedMutex;
        synchronized (atomicBoolean) {
            this.closedMutex.set(true);
            this.closedMutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void block() throws InterruptedException {
        AtomicBoolean atomicBoolean = this.closedMutex;
        synchronized (atomicBoolean) {
            while (!this.closedMutex.get()) {
                this.closedMutex.wait();
            }
        }
    }
}

