/*
 * Decompiled with CFR 0.152.
 */
package org.happy.commons.generators;

import java.util.Random;
import org.happy.commons.generators.RandomCharGenerator_1x0;
import org.happy.commons.generators.RandomIntegerGenerator_1x0;
import org.happy.commons.patterns.Generator_1x0;
import org.happy.commons.patterns.version.Version_1x0;

public class RandomStringGenerator_1x0
implements Generator_1x0<String>,
Version_1x0<Float> {
    RandomCharGenerator_1x0 randomCharGenerator;
    RandomIntegerGenerator_1x0 randomIntegerGenerator;

    public RandomStringGenerator_1x0(int maxLength) {
        this(0, maxLength);
    }

    public RandomStringGenerator_1x0(int length, Random random) {
        this(0, length, random);
    }

    public RandomStringGenerator_1x0(int length, char minCharValue, char maxCharValue) {
        this(0, length + 1, minCharValue, maxCharValue);
    }

    public RandomStringGenerator_1x0(int minStringLength, int maxStringLength) {
        this(minStringLength, maxStringLength, '\u0000', '\uffff');
    }

    public RandomStringGenerator_1x0(int minStringLength, int maxStringLength, Random random) {
        this(minStringLength, maxStringLength, '\u0000', '\uffff', random);
    }

    public RandomStringGenerator_1x0(int minStringLength, int maxStringLength, char minCharValue, char maxCharValue) {
        this(minStringLength, maxStringLength, minCharValue, maxCharValue, null);
    }

    public RandomStringGenerator_1x0(int minStringLength, int maxStringLength, char minCharValue, char maxCharValue, Random random) {
        if (minStringLength < 0) {
            throw new IllegalArgumentException("minStringLength should be bigger the zero");
        }
        if (maxStringLength < minStringLength) {
            throw new IllegalArgumentException("maxStringLength should be bigger or equal to maxStringLength");
        }
        if (maxCharValue < minCharValue) {
            throw new IllegalArgumentException("minCharValue should be bigger or equal to maxCharValue");
        }
        this.randomIntegerGenerator = new RandomIntegerGenerator_1x0(minStringLength, maxStringLength, random);
        this.randomCharGenerator = new RandomCharGenerator_1x0(minCharValue, maxCharValue, random);
    }

    public RandomStringGenerator_1x0(RandomIntegerGenerator_1x0 randomIntegerGenerator, RandomCharGenerator_1x0 randomCharGenerator) {
        if (this.randomIntegerGenerator == null) {
            throw new IllegalArgumentException("randomIntegerGenerator can't be null!");
        }
        if (this.randomCharGenerator == null) {
            throw new IllegalArgumentException("randomCharGenerator can't be null!");
        }
        this.randomIntegerGenerator = randomIntegerGenerator;
        this.randomCharGenerator = randomCharGenerator;
    }

    @Override
    public String generate() {
        String str = "";
        int length = this.randomIntegerGenerator.generate();
        for (int i = 0; i < length; ++i) {
            Character ch = new Character(this.randomCharGenerator.generate().charValue());
            str = str + ch;
        }
        return str;
    }

    public RandomCharGenerator_1x0 getRandomCharGenerator() {
        return this.randomCharGenerator;
    }

    public void setRandomCharGenerator(RandomCharGenerator_1x0 randomCharGenerator) {
        this.randomCharGenerator = randomCharGenerator;
    }

    public RandomIntegerGenerator_1x0 getRandomIntegerGenerator() {
        return this.randomIntegerGenerator;
    }

    public void setRandomIntegerGenerator(RandomIntegerGenerator_1x0 randomIntegerGenerator) {
        this.randomIntegerGenerator = randomIntegerGenerator;
    }

    @Override
    public Float getVersion() {
        return Float.valueOf(1.0f);
    }

    public String toString() {
        return "RandomStringGenerator_1x0 [randomCharGenerator=" + this.randomCharGenerator + ", randomIntegerGenerator=" + this.randomIntegerGenerator + "]";
    }
}

