/*
 * Decompiled with CFR 0.152.
 */
package org.happy.collections.maps.decorators;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.happy.collections.maps.decorators.MapDecorator_1x0;
import org.happy.collections.sets.decorators.SynchronizedSet_1x2;
import org.happy.commons.patterns.Lockable_1x0;

public class SynchronizedMap_1x2<K, V>
extends MapDecorator_1x0<K, V>
implements Lockable_1x0 {
    private Object lockObject;

    public static <K, V> SynchronizedMap_1x2<K, V> of(Map<K, V> map) {
        return new SynchronizedMap_1x2<K, V>(map);
    }

    public static <K, V> SynchronizedMap_1x2<K, V> of(Map<K, V> map, Object lockObject) {
        return new SynchronizedMap_1x2<K, V>(map, lockObject);
    }

    public SynchronizedMap_1x2(Map<K, V> decorateable) {
        super(decorateable);
        this.setLockObject(this);
    }

    public SynchronizedMap_1x2(Map<K, V> decorateable, Object lockObject) {
        super(decorateable);
        this.setLockObject(lockObject);
    }

    @Override
    public Object getLockObject() {
        return this.lockObject;
    }

    @Override
    public void setLockObject(Object lockObject) {
        if (lockObject == null) {
            throw new IllegalArgumentException("The lockObject can't be null!");
        }
        this.lockObject = lockObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lockObject;
        synchronized (object) {
            ((Map)this.decorated).clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        Object object = this.lockObject;
        synchronized (object) {
            return ((Map)this.decorated).containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        Object object = this.lockObject;
        synchronized (object) {
            return ((Map)this.decorated).containsValue(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Object object = this.lockObject;
        synchronized (object) {
            return ((Map)this.decorated).entrySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        Object object = this.lockObject;
        synchronized (object) {
            return ((Map)this.decorated).get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.lockObject;
        synchronized (object) {
            return ((Map)this.decorated).isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<K> keySet() {
        Object object = this.lockObject;
        synchronized (object) {
            return SynchronizedSet_1x2.of(((Map)this.decorated).keySet(), this.lockObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        Object object = this.lockObject;
        synchronized (object) {
            return ((Map)this.decorated).put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        Object object = this.lockObject;
        synchronized (object) {
            ((Map)this.decorated).putAll(m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        Object object = this.lockObject;
        synchronized (object) {
            return ((Map)this.decorated).remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.lockObject;
        synchronized (object) {
            return ((Map)this.decorated).size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<V> values() {
        Object object = this.lockObject;
        synchronized (object) {
            return SynchronizedSet_1x2.of(((Map)this.decorated).values(), this.lockObject);
        }
    }
}

