/*
 * Decompiled with CFR 0.152.
 */
package org.happy.collections.iterators;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.management.RuntimeOperationsException;
import org.happy.commons.patterns.executable.Executable_1x2;
import org.happy.commons.patterns.version.Version_1x0;

public class ConditionIterator1x2<E>
implements Version_1x0<Float>,
Iterator<E> {
    private Set<Executable_1x2<Boolean, E>> conditionSet = new HashSet<Executable_1x2<Boolean, E>>();
    protected E currentElement = null;
    private Iterator<E> itPrivate = null;
    private boolean started;

    public ConditionIterator1x2(Iterator<E> it) {
        this.setIterator(it);
    }

    @Override
    public boolean hasNext() {
        Iterator<E> it = this.getIterator();
        return it.hasNext();
    }

    protected boolean checkConditions(E e) {
        for (Executable_1x2<Boolean, E> condition : this.conditionSet) {
            if (condition.execute(e).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public E next() {
        E e;
        Iterator<E> it = this.getIterator();
        this.setStarted(true);
        do {
            if (it.hasNext()) continue;
            throw new NoSuchElementException("iteration has no more elements.");
        } while (!this.checkConditions(e = it.next()));
        this.currentElement = e;
        return this.currentElement;
    }

    @Override
    public void remove() {
        Iterator<E> it = this.getIterator();
        it.remove();
    }

    protected Iterator<E> getIterator() {
        return this.itPrivate;
    }

    @Override
    public Float getVersion() {
        return Float.valueOf(1.2f);
    }

    public void setIterator(Iterator<E> it) {
        this.itPrivate = it;
        this.setStarted(false);
        this.currentElement = null;
    }

    public Set<Executable_1x2<Boolean, E>> getConditionSet() {
        if (this.isStarted()) {
            return Collections.unmodifiableSet(this.conditionSet);
        }
        return this.conditionSet;
    }

    public void setConditionSet(Set<Executable_1x2<Boolean, E>> conditionSet) {
        if (this.isStarted()) {
            String msg = "the iterator has started, thus you can't change the conditionSet, reset the iterator and try again!";
            throw new RuntimeOperationsException(new RuntimeException("the iterator has started, thus you can't change the conditionSet, reset the iterator and try again!"), "the iterator has started, thus you can't change the conditionSet, reset the iterator and try again!");
        }
        this.conditionSet = conditionSet;
    }

    protected boolean isStarted() {
        return this.started;
    }

    protected void setStarted(boolean hasStarted) {
        this.started = hasStarted;
    }
}

