/*
 * Decompiled with CFR 0.152.
 */
package lm;

import lm.LearnMotifs;

public class TestMotifDiscoveryMotifletsPaper {
    public static double[] parse(String s) {
        int length = (int)s.chars().filter(ch -> ch == 44).count() + 1;
        double[] output = new double[length];
        String listString = s.substring(1, s.length() - 1);
        int i = 0;
        for (String token : listString.split(",")) {
            output[i++] = Double.valueOf(token.trim());
        }
        return output;
    }

    public static void main(String[] args) {
        int numRandomRestarts = 10;
        int maxIter = 100;
        double eta = 0.3;
        double alpha = 2.0;
        int K = 2;
        String path = "/Users/bzcschae/workspace/motiflets/datasets/";
        String file_name = path + "ecg-heartbeat-av.txt";
        int w = 125;
        double[] radii = new double[]{1.0, 11.0, 21.0, 31.0, 41.0, 51.0, 61.0, 71.0, 81.0, 91.0, 101.0};
        if (args.length >= 1) {
            file_name = args[0];
        }
        if (args.length >= 2) {
            radii = TestMotifDiscoveryMotifletsPaper.parse(args[1]);
        }
        if (args.length >= 3) {
            w = Integer.valueOf(args[2]);
        }
        System.out.println("Learning Motifs");
        LearnMotifs lmParallel = new LearnMotifs();
        lmParallel.LoadSegments(file_name, w, 10000);
        System.out.println("[");
        block0: for (double motif_range : radii) {
            int i;
            lmParallel.K = K;
            lmParallel.maxIter = maxIter;
            lmParallel.eta = eta;
            lmParallel.alpha = alpha;
            lmParallel.T = motif_range;
            lmParallel.RunParallelRandomRestarts(numRandomRestarts);
            int bestFrequency = 0;
            int frequency = 0;
            for (i = 0; i < K; ++i) {
                frequency = lmParallel.ComputeHardFrequency(lmParallel.bestM[i]);
                if (bestFrequency >= frequency) continue;
                bestFrequency = frequency;
            }
            for (i = 0; i < K; ++i) {
                if (lmParallel.ComputeHardFrequency(lmParallel.bestM[i]) != bestFrequency) continue;
                lmParallel.PrintHardLocations(lmParallel.bestM[i]);
                continue block0;
            }
        }
        System.out.println("]");
    }
}

