/*
 * Decompiled with CFR 0.152.
 */
package org.happy.commons.sort.projection;

import java.util.Comparator;

public class ShellSortProjection_1x0 {
    private ShellSortProjection_1x0() {
    }

    public static <T> void sort(T[] a, int[] p, Comparator<T> comparator) {
        int h = 1;
        while (h * 3 + 1 < p.length) {
            h = 3 * h + 1;
        }
        while (h > 0) {
            for (int i = h - 1; i < p.length; ++i) {
                T tmp = a[p[i]];
                int j = i;
                for (j = i; j >= h && 0 < comparator.compare(a[p[j - h]], tmp); j -= h) {
                    a[p[j]] = a[p[j - h]];
                }
                a[p[j]] = tmp;
            }
            h /= 3;
        }
    }

    public static void sort(byte[] a, int[] p) {
        int h = 1;
        while (h * 3 + 1 < p.length) {
            h = 3 * h + 1;
        }
        while (h > 0) {
            for (int i = h - 1; i < p.length; ++i) {
                byte tmp = a[p[i]];
                int j = i;
                for (j = i; j >= h && tmp < a[p[j - h]]; j -= h) {
                    a[p[j]] = a[p[j - h]];
                }
                a[p[j]] = tmp;
            }
            h /= 3;
        }
    }

    public static void sort(short[] a, int[] p) {
        int h = 1;
        while (h * 3 + 1 < p.length) {
            h = 3 * h + 1;
        }
        while (h > 0) {
            for (int i = h - 1; i < p.length; ++i) {
                short tmp = a[p[i]];
                int j = i;
                for (j = i; j >= h && tmp < a[p[j - h]]; j -= h) {
                    a[p[j]] = a[p[j - h]];
                }
                a[p[j]] = tmp;
            }
            h /= 3;
        }
    }

    public static void sort(int[] a, int[] p) {
        int h = 1;
        while (h * 3 + 1 < p.length) {
            h = 3 * h + 1;
        }
        while (h > 0) {
            for (int i = h - 1; i < p.length; ++i) {
                int tmp = a[p[i]];
                int j = i;
                for (j = i; j >= h && tmp < a[p[j - h]]; j -= h) {
                    a[p[j]] = a[p[j - h]];
                }
                a[p[j]] = tmp;
            }
            h /= 3;
        }
    }

    public static void sort(long[] a, int[] p) {
        int h = 1;
        while (h * 3 + 1 < p.length) {
            h = 3 * h + 1;
        }
        while (h > 0) {
            for (int i = h - 1; i < p.length; ++i) {
                long tmp = a[p[i]];
                int j = i;
                for (j = i; j >= h && tmp < a[p[j - h]]; j -= h) {
                    a[p[j]] = a[p[j - h]];
                }
                a[p[j]] = tmp;
            }
            h /= 3;
        }
    }

    public static void sort(float[] a, int[] p) {
        int h = 1;
        while (h * 3 + 1 < p.length) {
            h = 3 * h + 1;
        }
        while (h > 0) {
            for (int i = h - 1; i < p.length; ++i) {
                float tmp = a[p[i]];
                int j = i;
                for (j = i; j >= h && tmp < a[p[j - h]]; j -= h) {
                    a[p[j]] = a[p[j - h]];
                }
                a[p[j]] = tmp;
            }
            h /= 3;
        }
    }

    public static void sort(double[] a, int[] p) {
        int h = 1;
        while (h * 3 + 1 < p.length) {
            h = 3 * h + 1;
        }
        while (h > 0) {
            for (int i = h - 1; i < p.length; ++i) {
                double tmp = a[p[i]];
                int j = i;
                for (j = i; j >= h && tmp < a[p[j - h]]; j -= h) {
                    a[p[j]] = a[p[j - h]];
                }
                a[p[j]] = tmp;
            }
            h /= 3;
        }
    }

    public static void sort(char[] a, int[] p) {
        int h = 1;
        while (h * 3 + 1 < p.length) {
            h = 3 * h + 1;
        }
        while (h > 0) {
            for (int i = h - 1; i < p.length; ++i) {
                char tmp = a[p[i]];
                int j = i;
                for (j = i; j >= h && tmp < a[p[j - h]]; j -= h) {
                    a[p[j]] = a[p[j - h]];
                }
                a[p[j]] = tmp;
            }
            h /= 3;
        }
    }
}

