/*
 * Decompiled with CFR 0.152.
 */
package org.happy.commons.patterns.projector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.happy.commons.patterns.projector.IndexProjector_1x0;
import org.happy.commons.patterns.version.Version_1x0;

public abstract class IndexProjectorImpl_1x0<T>
implements IndexProjector_1x0<T>,
Version_1x0<Float> {
    private int itemsNumber;
    private int min;
    private int max;
    private T[] items;

    public IndexProjectorImpl_1x0(int itemsNumber, int min, int max) {
        this.itemsNumber = itemsNumber;
        this.min = min;
        this.max = max;
        ArrayList<T> itemsList = new ArrayList<T>();
        for (int i = 0; i < itemsNumber; ++i) {
            itemsList.add(this.createItem(i));
        }
        this.items = itemsList.toArray();
    }

    protected int projectIndexToItem(int index) {
        if (index < this.min || this.max < index) {
            throw new IllegalArgumentException("index is out of range");
        }
        int size = this.max - this.min;
        int i = index - this.min;
        int j = (int)((float)this.itemsNumber * ((float)i / (float)size));
        return j;
    }

    protected abstract T createItem(int var1);

    @Override
    public T getItem(int index) {
        return this.items[this.projectIndexToItem(index)];
    }

    @Override
    public Collection<T> getItems() {
        return Collections.unmodifiableCollection(Arrays.asList(this.items));
    }

    @Override
    public Float getVersion() {
        return Float.valueOf(1.0f);
    }
}

