/*
 * Decompiled with CFR 0.152.
 */
package org.happy.commons.io.streams.decorators;

import java.io.IOException;
import java.io.OutputStream;
import org.happy.commons.io.streams.decorators.OutputStreamDecorator_1x2;
import org.happy.commons.patterns.Cancelable_1x0;

public class CancelableOutputStream_1x2
extends OutputStreamDecorator_1x2
implements Cancelable_1x0<Boolean> {
    private boolean isCanceled = false;

    public static CancelableOutputStream_1x2 of(OutputStream os) {
        return new CancelableOutputStream_1x2(os);
    }

    public CancelableOutputStream_1x2(OutputStream os) {
        super(os);
    }

    @Override
    public Boolean cancel() {
        this.isCanceled = true;
        return true;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.isCanceled) {
            throw new IOException("the output stream was canceled, thus no more bytes can be written to it!");
        }
        this.decorated.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.isCanceled) {
            throw new IOException("the output stream was canceled, thus no more bytes can be written to it!");
        }
        this.decorated.write(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.isCanceled) {
            throw new IOException("the output stream was canceled, thus no more bytes can be written to it!");
        }
        this.decorated.write(b);
    }
}

