/*
 * Decompiled with CFR 0.152.
 */
package org.happy.commons.io.streams.decorators;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.happy.commons.io.streams.decorators.InputStreamDecorator_1x2;

public class BlockingInputStream_1x2
extends InputStreamDecorator_1x2 {
    AtomicBoolean closedMutex = new AtomicBoolean(false);

    public static BlockingInputStream_1x2 of(InputStream is) {
        return new BlockingInputStream_1x2(is);
    }

    public BlockingInputStream_1x2(InputStream is) {
        super(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        super.close();
        AtomicBoolean atomicBoolean = this.closedMutex;
        synchronized (atomicBoolean) {
            this.closedMutex.set(true);
            this.closedMutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void block() throws InterruptedException {
        AtomicBoolean atomicBoolean = this.closedMutex;
        synchronized (atomicBoolean) {
            while (!this.closedMutex.get()) {
                this.closedMutex.wait();
            }
        }
    }
}

