/*
 * Decompiled with CFR 0.152.
 */
package org.happy.commons.generators;

import java.util.Random;
import org.happy.commons.patterns.Generator_1x0;
import org.happy.commons.patterns.version.Version_1x0;
import org.happy.commons.util.Random_1x0;

public class RandomLongGenerator_1x0
implements Generator_1x0<Long>,
Version_1x0<Float> {
    private long min;
    private long max;
    Random random = null;

    public RandomLongGenerator_1x0(long min, long max) {
        if (min > max) {
            throw new IllegalArgumentException("MIN must be smaller or equals to MAX");
        }
        this.min = min;
        this.max = max;
    }

    public RandomLongGenerator_1x0(long min, long max, Random random) {
        this(min, max);
        this.random = random;
    }

    @Override
    public Long generate() {
        if (this.min == this.max) {
            return this.min;
        }
        if (this.random == null) {
            return this.min + Random_1x0.randomLong(this.max - this.min);
        }
        long n = this.max - this.min;
        return this.min + (long)(this.random.nextDouble() * (double)(n - 1L) + 0.5);
    }

    public long getMin() {
        return this.min;
    }

    public void setMin(long min) {
        this.min = min;
    }

    public long getMax() {
        return this.max;
    }

    public void setMax(long max) {
        this.max = max;
    }

    public Random getRandom() {
        return this.random;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    @Override
    public Float getVersion() {
        return Float.valueOf(1.0f);
    }

    public String toString() {
        return "RandomLongGenerator_1x0 [min=" + this.min + ", max=" + this.max + "]";
    }
}

