/*
 * Decompiled with CFR 0.152.
 */
package org.happy.collections.decorators;

import java.util.Collection;
import java.util.Iterator;
import org.happy.commons.patterns.decorator.Decorator_1x0Impl;

public abstract class CollectionDecorator_1x0<E, D extends Collection<E>>
extends Decorator_1x0Impl<D>
implements Collection<E> {
    private boolean decorateIterators = true;
    private boolean avoidLoop;

    public CollectionDecorator_1x0(D decorateable) {
        super(decorateable);
        if (decorateable == null) {
            throw new NullDecoratedCollectionException("the decorated collection can't be null");
        }
    }

    public CollectionDecorator_1x0(D decorateable, boolean decorateIterators) {
        this(decorateable);
        this.decorateIterators = decorateIterators;
    }

    @Override
    public boolean add(E e) {
        return ((Collection)this.decorated).add(e);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return ((Collection)this.decorated).addAll(c);
    }

    @Override
    public void clear() {
        ((Collection)this.decorated).clear();
    }

    @Override
    public boolean contains(Object o) {
        return ((Collection)this.decorated).contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return ((Collection)this.decorated).containsAll(c);
    }

    @Override
    public int hashCode() {
        return ((Collection)this.decorated).hashCode();
    }

    @Override
    public boolean isEmpty() {
        return ((Collection)this.decorated).isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        Iterator it = null;
        if (this.decorateIterators && !this.avoidLoop) {
            this.avoidLoop = true;
            it = this.iteratorImpl();
            this.avoidLoop = false;
        } else {
            it = ((Collection)this.decorated).iterator();
        }
        return it;
    }

    protected abstract Iterator<E> iteratorImpl();

    @Override
    public boolean remove(Object o) {
        return ((Collection)this.decorated).remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return ((Collection)this.decorated).removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return ((Collection)this.decorated).retainAll(c);
    }

    @Override
    public int size() {
        return ((Collection)this.decorated).size();
    }

    @Override
    public Object[] toArray() {
        return ((Collection)this.decorated).toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return ((Collection)this.decorated).toArray(a);
    }

    public boolean isDecorateIterators() {
        return this.decorateIterators;
    }

    public void setDecorateIterators(boolean decorateIterators) {
        this.decorateIterators = decorateIterators;
    }

    public String toString() {
        return ((Collection)this.decorated).toString();
    }

    public static class NullDecoratedCollectionException
    extends RuntimeException {
        private static final long serialVersionUID = -3492691934290321954L;

        public NullDecoratedCollectionException() {
        }

        public NullDecoratedCollectionException(String message, Throwable cause) {
            super(message, cause);
        }

        public NullDecoratedCollectionException(String message) {
            super(message);
        }

        public NullDecoratedCollectionException(Throwable cause) {
            super(cause);
        }
    }
}

