/*
 * Decompiled with CFR 0.152.
 */
package motifSets;

import java.util.ArrayList;
import java.util.Collections;
import motifSets.Distance;

public final class MK {
    private int[] locations;
    private double distance;

    public MK(double[][] data, int topK, int n) {
        if (topK > 0) {
            this.useMK(data, topK, n);
        } else {
            System.err.println("No. Refs must be greater than 0.");
        }
    }

    public final void useMK(double[][] data, int topK, int w) {
        double bestSoFar = Double.MAX_VALUE;
        int[] location = new int[]{-1, -1};
        int[] rand = new int[topK];
        for (int i = 0; i < topK; ++i) {
            rand[i] = (int)(Math.random() * (double)data.length);
        }
        RefObj order = new RefObj(topK);
        for (int i = 0; i < data.length; ++i) {
            double[] ref = new double[topK];
            for (int j = 0; j < topK; ++j) {
                ref[j] = Distance.distanceEuclidean(data[i], data[rand[j]]);
                if (!(ref[j] < bestSoFar) || i >= rand[j] - (w - 1) && i <= rand[j] + (w - 1)) continue;
                bestSoFar = ref[j];
                location[0] = rand[j];
                location[1] = i;
            }
            order.add(i, ref);
        }
        order.order();
        int offset = 0;
        boolean abandon = false;
        boolean reject = false;
        while (!abandon) {
            ++offset;
            abandon = true;
            for (int i = 0; i < order.size() - offset; ++i) {
                double current;
                if (order.get(i).getIndex() >= order.get(i + offset).getIndex() - (w - 1) && order.get(i).getIndex() <= order.get(i + offset).getIndex() + (w - 1)) continue;
                reject = false;
                for (int j = 0; j < topK; ++j) {
                    double lowerBound = Math.abs(order.get(i).getDistance(j) - order.get(i + offset).getDistance(j));
                    if (lowerBound >= bestSoFar) {
                        reject = true;
                        break;
                    }
                    if (j != order.getBest()) continue;
                    abandon = false;
                }
                if (reject || !((current = Distance.distAban(data[order.get(i).getIndex()], data[order.get(i + offset).getIndex()], bestSoFar)) < bestSoFar)) continue;
                bestSoFar = current;
                location[0] = order.get(i).getIndex();
                location[1] = order.get(i + offset).getIndex();
            }
        }
        this.locations = location;
        this.distance = bestSoFar;
    }

    public int[] getLocations() {
        return this.locations;
    }

    public double getDistance() {
        return this.distance;
    }

    public String toString() {
        return "Best match between index " + this.locations[0] + " and " + this.locations[1] + ". Distance = " + this.distance + ".";
    }

    public static class Ref
    implements Comparable {
        private int index;
        private double[] distances;
        private int best;

        public Ref(int index, double[] distances) {
            this.index = index;
            this.distances = distances;
            this.best = 0;
        }

        public int getIndex() {
            return this.index;
        }

        public double getDistance(int i) {
            return this.distances[i];
        }

        public void setBest(int in) {
            this.best = in;
        }

        public int compareTo(Object o) {
            Ref r = (Ref)o;
            int comp = 0;
            if (this.distances[this.best] > r.getDistance(this.best)) {
                comp = 1;
            }
            if (this.distances[this.best] < r.getDistance(this.best)) {
                comp = -1;
            }
            return comp;
        }
    }

    public static class RefObj {
        private int noOfRefs;
        private ArrayList<Ref> values;
        private int best;

        public RefObj(int noOfRefs) {
            this.noOfRefs = noOfRefs;
            this.values = new ArrayList();
        }

        public void add(int index, double[] distances) {
            Ref ref = new Ref(index, distances);
            this.values.add(ref);
        }

        public void order() {
            this.best = this.getBestSD();
            for (int i = 0; i < this.values.size(); ++i) {
                this.values.get(i).setBest(this.best);
            }
            Collections.sort(this.values);
        }

        public int getBest() {
            return this.best;
        }

        public int size() {
            return this.values.size();
        }

        public Ref get(int ind) {
            return this.values.get(ind);
        }

        public int getBestSD() {
            int i;
            int best1 = 0;
            double[] sds = new double[this.noOfRefs];
            double mean = 0.0;
            double sd = 0.0;
            if (this.noOfRefs == 1) {
                return best1;
            }
            for (i = 0; i < this.noOfRefs; ++i) {
                int j;
                mean = 0.0;
                sd = 0.0;
                for (j = 0; j < this.values.size(); ++j) {
                    mean += this.values.get(j).getDistance(i);
                }
                mean /= (double)this.values.size();
                for (j = 0; j < this.values.size(); ++j) {
                    double tmpSd = this.values.get(j).getDistance(i) - mean;
                    tmpSd *= tmpSd;
                    sd += tmpSd;
                }
                sds[i] = sd / (double)this.values.size();
            }
            for (i = 0; i < sds.length; ++i) {
                if (!(sds[i] > sds[best1])) continue;
                best1 = i;
            }
            return best1;
        }
    }
}

