/*
 * Decompiled with CFR 0.152.
 */
package lm;

import lm.BruteForceMotif;
import lm.LearnMotifs2;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public class Experiments {
    public static void main(String[] args) {
        int i;
        int numRandomRestarts = 10;
        int maxIter = 300;
        double eta = 0.3;
        double alpha = 2.0;
        String dataSet = "data/time_series_0.csv";
        int tsLength = 10000;
        int K = 3;
        int w = 50;
        double t = 1.6;
        for (String arg : args) {
            String[] argTokens = arg.split("=");
            if (argTokens[0].compareTo("eta") == 0) {
                eta = Double.parseDouble(argTokens[1]);
                continue;
            }
            if (argTokens[0].compareTo("maxIter") == 0) {
                maxIter = Integer.parseInt(argTokens[1]);
                continue;
            }
            if (argTokens[0].compareTo("numRandomRestarts") == 0) {
                numRandomRestarts = Integer.parseInt(argTokens[1]);
                continue;
            }
            if (argTokens[0].compareTo("alpha") == 0) {
                alpha = Double.parseDouble(argTokens[1]);
                continue;
            }
            if (argTokens[0].compareTo("dataSet") == 0) {
                dataSet = argTokens[1];
                continue;
            }
            if (argTokens[0].compareTo("tsLength") == 0) {
                tsLength = Integer.parseInt(argTokens[1]);
                continue;
            }
            if (argTokens[0].compareTo("w") == 0) {
                w = Integer.parseInt(argTokens[1]);
                continue;
            }
            if (argTokens[0].compareTo("K") == 0) {
                K = Integer.parseInt(argTokens[1]);
                continue;
            }
            if (argTokens[0].compareTo("t") != 0) continue;
            t = Double.parseDouble(argTokens[1]);
        }
        LearnMotifs2 lmParallel = new LearnMotifs2();
        lmParallel.K = K;
        lmParallel.maxIter = maxIter;
        lmParallel.eta = eta;
        lmParallel.alpha = alpha;
        lmParallel.LoadSegments(dataSet, tsLength, w);
        DescriptiveStatistics descStats = lmParallel.SegmentDistancesStats();
        lmParallel.T = descStats.getPercentile(0.1);
        System.out.println("T=" + lmParallel.T + ";");
        double lmHardFrequency = lmParallel.RunParallelRandomRestarts(numRandomRestarts);
        int bestFrequency = 0;
        int frequency = 0;
        for (i = 0; i < lmParallel.bestM.length; ++i) {
            System.out.println("F(" + i + ")=" + lmParallel.ComputeHardFrequency(lmParallel.bestM[i]));
        }
        for (i = 0; i < K; ++i) {
            frequency = lmParallel.ComputeHardFrequency(lmParallel.bestM[i]);
            if (bestFrequency >= frequency) continue;
            bestFrequency = frequency;
        }
        Boolean startFlag = false;
        for (int i2 = 0; i2 < K; ++i2) {
            if (lmParallel.ComputeHardFrequency(lmParallel.bestM[i2]) == bestFrequency) {
                if (startFlag.booleanValue()) {
                    System.out.println("next");
                } else {
                    startFlag = true;
                }
                lmParallel.PrintHardLocations(lmParallel.bestM[i2]);
            }
            if (i2 + 1 < K) continue;
            System.out.println("end");
        }
        BruteForceMotif bfm = new BruteForceMotif();
        bfm.T = lmParallel.T;
        bfm.S = lmParallel.S;
        bfm.J = lmParallel.J;
        bfm.L = lmParallel.L;
        bfm.K = K;
        int bfmHardFrequency = bfm.Search();
        System.out.print("BruteForceFrequencies=[");
        for (int k = 0; k < bfm.K; ++k) {
            System.out.print(bfm.ComputeHardFrequency(bfm.M[k]) + " ");
        }
        System.out.println("];");
        System.out.println("K=" + K + ", " + bfmHardFrequency + ", " + (int)lmHardFrequency + ", T=" + lmParallel.T + ", numRestarts=" + numRandomRestarts + ", J=" + lmParallel.J + ", maxIter=" + lmParallel.maxIter + ", eta=" + lmParallel.eta + ", alpha=" + lmParallel.alpha);
    }
}

