from typing import Dict, List

# NOTE(elyas): pydantic (or similar) may offer a more robust method of
# defining setting types. For example, JSON does not support storing Python
# tuples, but settings like ADMINS (i.e. List[Tuple[str, str]]) may require
# list elements to be cast to tuple.
_setting_types: Dict[str, List[type]] = {
    'ABSOLUTE_URL_OVERRIDES': [dict],
    'ADMINS': [list],
    'ALLOWED_HOSTS': [list],
    'APPEND_SLASH': [bool],
    'AUTHENTICATION_BACKENDS': [list],
    'AUTH_PASSWORD_VALIDATORS': [list],
    'AUTH_USER_MODEL': [str],
    'CACHES': [dict],
    'CACHE_MIDDLEWARE_ALIAS': [str],
    'CACHE_MIDDLEWARE_KEY_PREFIX': [str],
    'CACHE_MIDDLEWARE_SECONDS': [int],
    'CSRF_COOKIE_AGE': [type(None), int],
    'CSRF_COOKIE_DOMAIN': [type(None), str],
    'CSRF_COOKIE_HTTPONLY': [bool],
    'CSRF_COOKIE_NAME': [str],
    'CSRF_COOKIE_PATH': [str],
    'CSRF_COOKIE_SAMESITE': [str],  # 'None' is a valid str value, so don't coerce to NoneType  # noqa
    'CSRF_COOKIE_SECURE': [bool],
    'CSRF_FAILURE_VIEW': [str],
    'CSRF_HEADER_NAME': [str],
    'CSRF_TRUSTED_ORIGINS': [list],
    'CSRF_USE_SESSIONS': [bool],
    'DATABASES': [dict],
    'DATABASE_ROUTERS': [list],
    'DATA_UPLOAD_MAX_MEMORY_SIZE': [type(None), int],
    'DATA_UPLOAD_MAX_NUMBER_FIELDS': [type(None), int],
    'DATETIME_FORMAT': [str],
    'DATETIME_INPUT_FORMATS': [list],
    'DATE_FORMAT': [str],
    'DATE_INPUT_FORMATS': [list],
    'DEBUG': [bool],
    'DEBUG_PROPAGATE_EXCEPTIONS': [bool],
    'DECIMAL_SEPARATOR': [str],
    'DEFAULT_AUTO_FIELD': [str],
    'DEFAULT_CHARSET': [str],
    'DEFAULT_CONTENT_TYPE': [str],  # deprecated v2.0, removed v3.0
    'DEFAULT_EXCEPTION_REPORTER': [str],
    'DEFAULT_EXCEPTION_REPORTER_FILTER': [str],
    'DEFAULT_FILE_STORAGE': [str],
    'DEFAULT_FROM_EMAIL': [str],
    'DEFAULT_HASHING_ALGORITHM': [str],
    'DEFAULT_INDEX_TABLESPACE': [str],
    'DEFAULT_TABLESPACE': [str],
    'DISALLOWED_USER_AGENTS': [list],
    'EMAIL_BACKEND': [str],
    'EMAIL_HOST': [str],
    'EMAIL_HOST_PASSWORD': [str],
    'EMAIL_HOST_USER': [str],
    'EMAIL_PORT': [int],
    'EMAIL_SSL_CERTFILE': [type(None), str],
    'EMAIL_SSL_KEYFILE': [type(None), str],
    'EMAIL_SUBJECT_PREFIX': [str],
    'EMAIL_TIMEOUT': [type(None), int],
    'EMAIL_USE_LOCALTIME': [bool],
    'EMAIL_USE_SSL': [bool],
    'EMAIL_USE_TLS': [bool],
    'FILE_CHARSET': [str],  # deprecated v2.2, removed v3.1
    'FILE_UPLOAD_DIRECTORY_PERMISSIONS': [type(None), str],
    'FILE_UPLOAD_HANDLERS': [list],
    'FILE_UPLOAD_MAX_MEMORY_SIZE': [int],
    'FILE_UPLOAD_PERMISSIONS': [type(None), int],
    'FILE_UPLOAD_TEMP_DIR': [type(None), str],
    'FIRST_DAY_OF_WEEK': [int],
    'FIXTURE_DIRS': [list],
    'FORCE_SCRIPT_NAME': [type(None), str],
    'FORMAT_MODULE_PATH': [type(None), str, list],
    'FORM_RENDERER': [str],
    'IGNORABLE_404_URLS': [list],
    'INSTALLED_APPS': [list],
    'INTERNAL_IPS': [list],
    'LANGUAGES': [list],
    'LANGUAGES_BIDI': [list],
    'LANGUAGE_CODE': [str],
    'LANGUAGE_COOKIE_AGE': [type(None), int],
    'LANGUAGE_COOKIE_DOMAIN': [type(None), str],
    'LANGUAGE_COOKIE_HTTPONLY': [bool],
    'LANGUAGE_COOKIE_NAME': [str],
    'LANGUAGE_COOKIE_PATH': [str],
    'LANGUAGE_COOKIE_SAMESITE': [type(None), str],
    'LANGUAGE_COOKIE_SECURE': [bool],
    'LOCALE_PATHS': [list],
    'LOGGING': [dict],
    'LOGGING_CONFIG': [type(None), str],
    'LOGIN_REDIRECT_URL': [str],
    'LOGIN_URL': [str],
    'LOGOUT_REDIRECT_URL': [type(None), str],
    'MANAGERS': [list],
    'MEDIA_ROOT': [str],
    'MEDIA_URL': [str],
    'MESSAGE_STORAGE': [str],
    'MIDDLEWARE': [type(None), list],
    'MIDDLEWARE_CLASSES': [list],  # deprecated v1.10, removed v2.0
    'MIGRATION_MODULES': [dict],
    'MONTH_DAY_FORMAT': [str],
    'NUMBER_GROUPING': [int],
    'PASSWORD_HASHERS': [list],
    'PASSWORD_RESET_TIMEOUT': [int],
    'PASSWORD_RESET_TIMEOUT_DAYS': [int],
    'PREPEND_WWW': [bool],
    'SECRET_KEY': [str],
    'SECURE_BROWSER_XSS_FILTER': [bool],
    'SECURE_CONTENT_TYPE_NOSNIFF': [bool],
    'SECURE_HSTS_INCLUDE_SUBDOMAINS': [bool],
    'SECURE_HSTS_PRELOAD': [bool],
    'SECURE_HSTS_SECONDS': [int],
    'SECURE_PROXY_SSL_HEADER': [type(None), tuple],
    'SECURE_REDIRECT_EXEMPT': [list],
    'SECURE_REFERRER_POLICY': [type(None), str],  # v3.0 default None, v3.1 default str  # noqa
    'SECURE_SSL_HOST': [type(None), str],
    'SECURE_SSL_REDIRECT': [bool],
    'SERVER_EMAIL': [str],
    'SESSION_CACHE_ALIAS': [str],
    'SESSION_COOKIE_AGE': [int],
    'SESSION_COOKIE_DOMAIN': [type(None), str],
    'SESSION_COOKIE_HTTPONLY': [bool],
    'SESSION_COOKIE_NAME': [str],
    'SESSION_COOKIE_PATH': [str],
    'SESSION_COOKIE_SAMESITE': [str, bool],  # 'None' is a valid str value, so don't coerce to NoneType  # noqa
    'SESSION_COOKIE_SECURE': [bool],
    'SESSION_ENGINE': [str],
    'SESSION_EXPIRE_AT_BROWSER_CLOSE': [bool],
    'SESSION_FILE_PATH': [type(None), str],
    'SESSION_SAVE_EVERY_REQUEST': [bool],
    'SESSION_SERIALIZER': [str],
    'SHORT_DATETIME_FORMAT': [str],
    'SHORT_DATE_FORMAT': [str],
    'SIGNING_BACKEND': [str],
    'SILENCED_SYSTEM_CHECKS': [list],
    'STATICFILES_DIRS': [list],
    'STATICFILES_FINDERS': [list],
    'STATICFILES_STORAGE': [str],
    'STATIC_ROOT': [type(None), str],
    'STATIC_URL': [type(None), str],
    'TEMPLATES': [list],
    # 'TEMPLATE_DIRS': [list],  # deprecated v1.8, removed v1.10
    'TEST_NON_SERIALIZED_APPS': [list],
    'TEST_RUNNER': [str],
    'THOUSAND_SEPARATOR': [str],
    'TIME_FORMAT': [str],
    'TIME_INPUT_FORMATS': [list],
    'TIME_ZONE': [type(None), str],
    'USE_ETAGS': [bool],  # deprecated v1.11, removed v2.1
    'USE_I18N': [bool],
    'USE_L10N': [bool],
    'USE_THOUSAND_SEPARATOR': [bool],
    'USE_TZ': [bool],
    'USE_X_FORWARDED_HOST': [bool],
    'USE_X_FORWARDED_PORT': [bool],
    'WSGI_APPLICATION': [type(None), str],
    'X_FRAME_OPTIONS': [str],
    'YEAR_MONTH_FORMAT': [str],
}


def get_setting_types():
    return _setting_types.copy()
