#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os
import re
import sys
import codecs

from setuptools import setup, find_packages


if sys.argv[-1] == 'wheel':
    os.system('pip wheel --wheel-dir=wheelhouse .')
    sys.exit()

PYPI_RST_FILTERS = (
    # Replace code-blocks
    (r'\.\.\s? code-block::\s*(\w|\+)+',  '::'),
    # Remove travis ci badge
    (r'.*travis-ci\.org/.*', ''),
    # Remove pypip.in badges
    (r'.*pypip\.in/.*', ''),
    (r'.*crate\.io/.*', ''),
    (r'.*coveralls\.io/.*', ''),
)


def rst(filename):
    '''
    Load rst file and sanitize it for PyPI.
    Remove unsupported github tags:
     - code-block directive
     - travis ci build badge
    '''
    content = codecs.open(filename, encoding='utf-8').read()
    for regex, replacement in PYPI_RST_FILTERS:
        content = re.sub(regex, replacement, content)
    return content


long_description = '\n'.join((
    rst('README.rst'),
    rst('CHANGELOG.rst'),
    ''
))

install_requires = ['django']
if sys.version_info[0:2] < (2, 7):
    install_requires += ['argparse']

setup(
    name='django.js-ng',
    version=__import__('djangojs').__version__,
    description=__import__('djangojs').__description__,
    long_description=long_description,
    url='https://github.com/Robert-Chiang/django.js',
    download_url='http://pypi.python.org/pypi/django.js-ng',
    author='Robert Chiang',
    author_email='robert@streetvoice.com',
    packages=find_packages(),
    include_package_data=True,
    install_requires=install_requires,
    license='LGPL',
    keywords='django javascript test url reverse helpers',
    classifiers=[
        "Framework :: Django",
        "Development Status :: 4 - Beta",
        "Programming Language :: Python",
        "Environment :: Web Environment",
        "Operating System :: OS Independent",
        "Intended Audience :: Developers",
        "Topic :: System :: Software Distribution",
        "Programming Language :: Python",
        'Programming Language :: Python :: 3',
        "Topic :: Software Development :: Libraries :: Python Modules",
        'License :: OSI Approved :: GNU Library or Lesser General Public License (LGPL)',
    ],
)
