# 个人小工具集

## 时间类
### 定时器
```python
from metools import timer_decorator


# 每2秒执行一次，只执行3次
@timer_decorator(interval=2.0, repeat=3)
def limited_task():
    print("定时任务执行中!")


# 每1.5秒执行一次，无限重复
@timer_decorator(interval=1.5)
def infinite_task():
    print("无限任务")


# 启动定时器并获取停止事件
stop_event = infinite_task()

# 在需要时停止定时任务
stop_event.set()  # 这将停止定时器

```

## 许可证

```text
MIT License

Copyright (c) [2025] [111hgx]

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
```