import { Stack, StackProps } from 'aws-cdk-lib';
import { IChainable } from 'aws-cdk-lib/aws-stepfunctions/lib/types';
import { Construct } from 'constructs';
export interface DeploymentPlanProps {
    readonly definition: IChainable;
}
export declare abstract class AttiniDeploymentPlanStack extends Stack {
    protected constructor(scope: Construct, id: string, props?: StackProps);
}
export declare class DeploymentPlan extends Construct {
    constructor(scope: Construct, id: string, props: DeploymentPlanProps);
}
export declare class PropsUtil {
    static fixCase(props: any): object;
}
export declare enum CfnAction {
    DEPLOY = 0,
    DELETE = 1
}
export * from './attini-state';
export * from './attini-merge';
export * from './attini-runner-job';
export * from './attini-cfn';
export * from './attini-manual-approval';
export * from './attini-import';
export * from './attini-lambda-invoke';
export * from './attini-sam';
export * from './attini-task';
export * from './attini-runner';
export * from './attini-cdk';
export * from './attini-runtime-variables';
export * from './attini-payload';
