"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AttiniTask = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_stepfunctions_1 = require("aws-cdk-lib/aws-stepfunctions");
const attini_state_1 = require("./attini-state");
class AttiniTask extends attini_state_1.AttiniState {
    /**
     *
     * Get the json path to this steps output. Convenience
     * method that will return a string with the following format
     * $.output.<id>.<path>.<path>
     *
     * @param {string[]} [paths] - The path to the value from the outputs root.
     *
     */
    getOutputPath(...paths) {
        if (paths.length !== 0) {
            let path = paths.join('.');
            return '$.output.' + this.id + '.' + path;
        }
        return '$.output.' + this.id;
    }
    /**
     *
     * Get a string value from the steps output.
     * This method can only be used as the value for a key/value pair in another Attini or
     * StepFunction step.
     *
     * @example
     * Valid examples:
     *
     * {my-key: step.getOutput()}
     * {my-key: step.getOutput('path','to','key')}
     *
     * @example
     * Invalid examples:
     *
     * {my-key: 'test'+ step.getOutput()}
     * {my-key: '[step.getOutput()]}
     *
     * @param {string[]} [paths] - The path to the value from the outputs root.
     *
     */
    getOutput(...paths) {
        return aws_stepfunctions_1.JsonPath.stringAt(this.getOutputPath(...paths));
    }
}
exports.AttiniTask = AttiniTask;
_a = JSII_RTTI_SYMBOL_1;
AttiniTask[_a] = { fqn: "@attini/cdk.AttiniTask", version: "1.2.2" };
//# sourceMappingURL=data:application/json;base64,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