/**
 * Environment variables that are available when deploying
 * a CDK app with Attini.
 *
 */
export declare abstract class AttiniRuntimeVariables {
    /**
     *  Environment variable that contains the current environment name.
     */
    static readonly ENVIRONMENT: string;
    /**
     *  Environment variable that contains the current distribution name.
     */
    static readonly DISTRIBUTION_NAME: string;
    /**
     *  Environment variable that contains the current distribution id
     */
    static readonly DISTRIBUTION_ID: string;
    /**
     *  Environment variable that contains the current step name.
     */
    static readonly STEP_NAME: string;
    /**
     *  Environment variable that contains the path to the steps input file. Contains the steps input.
     */
    static readonly INPUT_FILE_PATH: string;
    /**
     * Environment variable that contains the path to the steps output file. Anything written to this file will be passed as the steps output.
     */
    static readonly OUTPUT_FILE_PATH: string;
}
