"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AttiniPayload = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_stepfunctions_1 = require("aws-cdk-lib/aws-stepfunctions");
/**
 * Utility class for reading values from the payload of an Attini deployment plan.
 * Each method can only be used as the value of a key/value pair in an Attini or
 * StepFunction step.
 *
 * @example
 * Valid example:
 *
 * {my-key: AttiniPayload.environment()}
 *
 * @example
 * Invalid examples:
 *
 * {my-key: 'test'+ AttiniPayload.environment()}
 * {my-key: '[step.AttiniPayload.environment()]}
 *
 * @param {string[]} [paths] - The path to the value from the outputs root.
 *
 */
class AttiniPayload {
    static environment() {
        return aws_stepfunctions_1.JsonPath.stringAt(AttiniPayload.ENVIRONMENT_PATH);
    }
    static distributionName() {
        return aws_stepfunctions_1.JsonPath.stringAt(AttiniPayload.DISTRIBUTION_NAME_PATH);
    }
    static stackParameter(parameterName) {
        return aws_stepfunctions_1.JsonPath.stringAt(AttiniPayload.STACK_PARAMETERS_PATH + '.' + parameterName);
    }
    static version() {
        return aws_stepfunctions_1.JsonPath.stringAt(AttiniPayload.DISTRIBUTION_VERSION);
    }
}
exports.AttiniPayload = AttiniPayload;
_a = JSII_RTTI_SYMBOL_1;
AttiniPayload[_a] = { fqn: "@attini/cdk.AttiniPayload", version: "1.2.2" };
AttiniPayload.ENVIRONMENT_PATH = '$.deploymentOriginData.environment';
AttiniPayload.DISTRIBUTION_NAME_PATH = '$.deploymentOriginData.distributionName';
AttiniPayload.DISTRIBUTION_VERSION = '$.deploymentOriginData.version';
AttiniPayload.STACK_PARAMETERS_PATH = '$.stackParameters';
//# sourceMappingURL=data:application/json;base64,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