/**
 * Utility class for reading values from the payload of an Attini deployment plan.
 * Each method can only be used as the value of a key/value pair in an Attini or
 * StepFunction step.
 *
 * @example
 * Valid example:
 *
 * {my-key: AttiniPayload.environment()}
 *
 * @example
 * Invalid examples:
 *
 * {my-key: 'test'+ AttiniPayload.environment()}
 * {my-key: '[step.AttiniPayload.environment()]}
 *
 * @param {string[]} [paths] - The path to the value from the outputs root.
 *
 */
export declare class AttiniPayload {
    static readonly ENVIRONMENT_PATH: string;
    static readonly DISTRIBUTION_NAME_PATH: string;
    static readonly DISTRIBUTION_VERSION: string;
    static readonly STACK_PARAMETERS_PATH: string;
    static environment(): string;
    static distributionName(): string;
    static stackParameter(parameterName: string): string;
    static version(): string;
}
