"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AttiniCfn = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_stepfunctions_1 = require("aws-cdk-lib/aws-stepfunctions");
const attini_task_1 = require("./attini-task");
const index_1 = require("./index");
/**
 * The AttiniCfn step can create, update or delete a CloudFormation stack.
 */
class AttiniCfn extends attini_task_1.AttiniTask {
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        this.type = 'AttiniCfn';
    }
    renderProps() {
        let copy = { ...this.props };
        if (this.props.action && this.props.action.valueOf() === index_1.CfnAction.DEPLOY.valueOf()) {
            copy.action = 'Deploy';
        }
        else if (this.props.action && this.props.action.valueOf() === index_1.CfnAction.DELETE.valueOf()) {
            copy.action = 'Delete';
        }
        return {
            Properties: aws_stepfunctions_1.FieldUtils.renderObject(index_1.PropsUtil.fixCase(copy)),
        };
    }
}
exports.AttiniCfn = AttiniCfn;
_a = JSII_RTTI_SYMBOL_1;
AttiniCfn[_a] = { fqn: "@attini/cdk.AttiniCfn", version: "1.2.2" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXR0aW5pLWNmbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9hdHRpbmktY2ZuLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEscUVBQTJEO0FBRTNELCtDQUEyQztBQUMzQyxtQ0FBK0M7QUF1Ri9DOztHQUVHO0FBQ0gsTUFBYSxTQUFVLFNBQVEsd0JBQVU7SUFLdkMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBVSxLQUFxQjtRQUNyRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRCtCLFVBQUssR0FBTCxLQUFLLENBQWdCO1FBSHZFLFNBQUksR0FBVyxXQUFXLENBQUM7SUFLM0IsQ0FBQztJQUVTLFdBQVc7UUFFbkIsSUFBSSxJQUFJLEdBQVEsRUFBRSxHQUFHLElBQUksQ0FBQyxLQUFLLEVBQUUsQ0FBQztRQUVsQyxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsTUFBTSxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsTUFBTSxDQUFDLE9BQU8sRUFBRSxLQUFLLGlCQUFTLENBQUMsTUFBTSxDQUFDLE9BQU8sRUFBRSxFQUFFO1lBQ25GLElBQUksQ0FBQyxNQUFNLEdBQUcsUUFBUSxDQUFDO1NBQ3hCO2FBQU0sSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLE1BQU0sSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLE1BQU0sQ0FBQyxPQUFPLEVBQUUsS0FBSyxpQkFBUyxDQUFDLE1BQU0sQ0FBQyxPQUFPLEVBQUUsRUFBRTtZQUMxRixJQUFJLENBQUMsTUFBTSxHQUFHLFFBQVEsQ0FBQztTQUN4QjtRQUNELE9BQU87WUFDTCxVQUFVLEVBQUUsOEJBQVUsQ0FBQyxZQUFZLENBQUMsaUJBQVMsQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLENBQUM7U0FDN0QsQ0FBQztJQUNKLENBQUM7O0FBckJILDhCQXVCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEZpZWxkVXRpbHMgfSBmcm9tICdhd3MtY2RrLWxpYi9hd3Mtc3RlcGZ1bmN0aW9ucyc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IEF0dGluaVRhc2sgfSBmcm9tICcuL2F0dGluaS10YXNrJztcbmltcG9ydCB7IENmbkFjdGlvbiwgUHJvcHNVdGlsIH0gZnJvbSAnLi9pbmRleCc7XG5cblxuZXhwb3J0IGludGVyZmFjZSBBdHRpbmlDZm5Qcm9wcyB7XG5cbiAgLyoqXG4gICAqIFRoZSBwYXRoIHRvIHRoZSBDbG91ZEZvcm1hdGlvbiB0ZW1wbGF0ZS4gQ2FuIGVpdGhlciBiZTpcbiAgICpcbiAgICogMS4gQSBwYXRoIHRvIGEgZmlsZSBpbiB0aGUgZGlzdHJpYnV0aW9uLiBUaGUgcGF0aCBzaG91bGQgYmUgZnJvbSB0aGUgcm9vdCBvZiB0aGUgcHJvamVjdCBhbmQgc3RhcnQgd2l0aCBhIFwiL1wiLlxuICAgKiAyLiBBIFVSTCB0byBhIHB1YmxpYyBTMyBmaWxlLCBzdGFydGluZyB3aXRoIFwiaHR0cHM6Ly9cIi5cbiAgICogMy4gQW4gUzMgcGF0aCwgc3RhcnRpbmcgd2l0aCBcInMzOi8vXCIuXG4gICAqXG4gICAqIFJlcXVpcmVkIGlmIGl0IGlzIG5vdCBzcGVjaWZpZWQgaW4ge0BsaW5rIGNvbmZpZ0ZpbGV9XG4gICAqL1xuICByZWFkb25seSB0ZW1wbGF0ZT86IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIG5hbWUgdGhhdCBzaG91bGQgYmUgZ2l2ZW4gdG8gdGhlIHN0YWNrIHdoZW4gZGVwbG95ZWQuIFRoZSBuYW1lIG11c3QgYmUgdW5pcXVlIGluIHRoZSBSZWdpb24gaW4gd2hpY2ggeW91IGFyZSBjcmVhdGluZyB0aGUgc3RhY2suXG4gICAqXG4gICAqIFJlcXVpcmVkIGlmIGl0IGlzIG5vdCBzcGVjaWZpZWQgaW4ge0BsaW5rIGNvbmZpZ0ZpbGV9XG4gICAqL1xuICByZWFkb25seSBzdGFja05hbWU/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFNwZWNpZmllcyBhIHBhdGggdG8gYSBjb25maWd1cmF0aW9uIGZpbGUgZm9yIHRoZSBzdGFjay5cbiAgICpcbiAgICogRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSB0aGUge0BsaW5rIGh0dHBzOi8vZG9jcy5hdHRpbmkuaW8vYXBpLXJlZmVyZW5jZS9jbG91ZGZvcm1hdGlvbi1jb25maWd1cmF0aW9uLmh0bWwjYXBpLXJlZmVyZW5jZS1jbG91ZGZvcm1hdGlvbi1jb25maWd1cmF0aW9uIGRvY3VtZW50YXRpb259XG4gICAqL1xuICByZWFkb25seSBjb25maWdGaWxlPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgQ2xvdWRGb3JtYXRpb24gcGFyYW1ldGVyc1xuICAgKi9cbiAgcmVhZG9ubHkgcGFyYW1ldGVycz86IHtba2V5OiBzdHJpbmddOiBzdHJpbmd9O1xuXG4gIC8qKlxuICAgKiBUaGUgQ2xvdWRGb3JtYXRpb24gdGFnc1xuICAgKi9cbiAgcmVhZG9ubHkgdGFncz86IHtba2V5OiBzdHJpbmddOiBzdHJpbmd9O1xuXG4gIC8qKlxuICAgKiBUaGUgYXJuIG9mIHRoZSBTdGFja1JvbGUsIGZpbmQgbW9yZSBpbmZvIGhlcmU6IHtAbGluayBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS91c2luZy1pYW0tc2VydmljZXJvbGUuaHRtbCBBV1MgQ2xvdWRGb3JtYXRpb24gc2VydmljZSByb2xlfVxuICAgKi9cbiAgcmVhZG9ubHkgc3RhY2tSb2xlQXJuPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgcm9sZSB0aGF0IHNob3VsZCBiZSBhc3N1bWVkIHdoZW4gdGhlIEF0dGluaSBGcmFtZXdvcmsgZGVwbG95cyB0aGUgQ2xvdWRGb3JtYXRpb24gc3RhY2suXG4gICAqXG4gICAqIFRoZSBFeGVjdXRpb25Sb2xlIGhhcyB0byB0cnVzdCB0aGUgZm9sbG93aW5nIHJvbGUgc28gdGhhdCBpdCBjYW4gYmUgYXNzdW1lZDpcbiAgICogYGBgXG4gICBhcm46YXdzOmlhbTo6e0FjY291bnRJZH06cm9sZS9hdHRpbmkvYXR0aW5pLWFjdGlvbi1yb2xlLXtSZWdpb259XG4gICAqIGBgYFxuICAgKi9cbiAgcmVhZG9ubHkgZXhlY3V0aW9uUm9sZUFybj86IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIHJlZ2lvbiB0aGF0IHRoZSB0ZW1wbGF0ZSBzaG91bGQgYmUgZGVwbG95ZWQgdG8uXG4gICAqL1xuICByZWFkb25seSByZWdpb24/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIEFuIG9wdGlvbmFsIGZpZWxkIG5hbWUgdGhhdCB0aGUgQ2xvdWRGb3JtYXRpb25zIG91dHB1dCBzaG91bGQgYmUgcGxhY2VkIHVuZGVyIGluIHRoZSBkZXBsb3ltZW50IHBsYW4gcGF5bG9hZC5cbiAgICovXG4gIHJlYWRvbmx5IG91dHB1dFBhdGg/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFZhcmlhYmxlcyB0aGF0IHNob3VsZCBiZSBwYXNzZWQgdG8gYW55IHtAbGluayBjb25maWdGaWxlfSB0aGF0IGlzIGNvbmZpZ3VyZWQuXG4gICAqIFZhcmlhYmxlcyBjYW4gYmUgcmVmZXJlbmNlZCBpbiB0aGUgY29uZmlndXJhdGlvbiBmaWxlIGFuZCBjYW4gYmUgdXNlZCB0byBwYXNzIGRhdGEgZnJvbSB0aGUgcGF5bG9hZCB0byB0aGUgY29uZmlndXJhdGlvbi5cbiAgICovXG4gIHJlYWRvbmx5IHZhcmlhYmxlcz86IHtba2V5OiBzdHJpbmddOiBzdHJpbmd9O1xuXG4gIC8qKlxuICAgKiBTcGVjaWZ5IGlmIHRoZSBzdGFjayBzaG91bGQgYmUgY3JlYXRlZC91cGRhdGVkIG9yIGRlbGV0ZWQuXG4gICAqXG4gICAqL1xuICByZWFkb25seSBhY3Rpb24/OiBDZm5BY3Rpb247XG5cbiAgLyoqXG4gICAqIFNwZWNpZnkgaWYgdGVybWluYXRpb24gcHJvdGVjdGlvbiBzaG91bGQgYmUgZW5hYmxlZCBmb3IgdGhlIHN0YWNrLlxuICAgKlxuICAgKiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIHRoZSB7QGxpbmsgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvdXNpbmctY2ZuLXByb3RlY3Qtc3RhY2tzLmh0bWwgQVdTIGRvY3VtZW50YXRpb259LlxuICAgKlxuICAgKi9cbiAgcmVhZG9ubHkgZW5hYmxlVGVybWluYXRpb25Qcm90ZWN0aW9uPzogYm9vbGVhbjtcbn1cblxuXG4vKipcbiAqIFRoZSBBdHRpbmlDZm4gc3RlcCBjYW4gY3JlYXRlLCB1cGRhdGUgb3IgZGVsZXRlIGEgQ2xvdWRGb3JtYXRpb24gc3RhY2suXG4gKi9cbmV4cG9ydCBjbGFzcyBBdHRpbmlDZm4gZXh0ZW5kcyBBdHRpbmlUYXNrIHtcblxuICB0eXBlOiBzdHJpbmcgPSAnQXR0aW5pQ2ZuJztcblxuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByaXZhdGUgcHJvcHM6IEF0dGluaUNmblByb3BzICkge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG4gIH1cblxuICBwcm90ZWN0ZWQgcmVuZGVyUHJvcHMoKTogb2JqZWN0IHtcblxuICAgIGxldCBjb3B5OiBhbnkgPSB7IC4uLnRoaXMucHJvcHMgfTtcblxuICAgIGlmICh0aGlzLnByb3BzLmFjdGlvbiAmJiB0aGlzLnByb3BzLmFjdGlvbi52YWx1ZU9mKCkgPT09IENmbkFjdGlvbi5ERVBMT1kudmFsdWVPZigpKSB7XG4gICAgICBjb3B5LmFjdGlvbiA9ICdEZXBsb3knO1xuICAgIH0gZWxzZSBpZiAodGhpcy5wcm9wcy5hY3Rpb24gJiYgdGhpcy5wcm9wcy5hY3Rpb24udmFsdWVPZigpID09PSBDZm5BY3Rpb24uREVMRVRFLnZhbHVlT2YoKSkge1xuICAgICAgY29weS5hY3Rpb24gPSAnRGVsZXRlJztcbiAgICB9XG4gICAgcmV0dXJuIHtcbiAgICAgIFByb3BlcnRpZXM6IEZpZWxkVXRpbHMucmVuZGVyT2JqZWN0KFByb3BzVXRpbC5maXhDYXNlKGNvcHkpKSxcbiAgICB9O1xuICB9XG5cbn1cbiJdfQ==