from importlib.metadata import version

import pkg_resources

APP_TITLE = "KafkaesCLI"
APP_PACKAGE = "kafkaescli"

try:
    APP_VERSION = pkg_resources.get_distribution(APP_PACKAGE).version
except pkg_resources.DistributionNotFound:
    APP_VERSION = 'development'

DEFAULT_BOOTSTRAP_SERVERS = "localhost:9092"
DEFAULT_CONFIG_FILE_PATH = "~/.kafkaescli/config.json"

DOT_PATH_RE = r'^([A-z_][0-9A-z_]*)(\.[A-z_][0-9A-z_]*)*$'

# general config env vars
KAFKAESCLI_PROFILE = "KAFKAESCLI_PROFILE"
KAFKAESCLI_CONFIG_FILE_PATH = "KAFKAESCLI_CONFIG_FILE_PATH"
KAFKAESCLI_BOOTSTRAP_SERVERS = "KAFKAESCLI_BOOTSTRAP_SERVERS"
KAFKAESCLI_MIDDLEWARE = "KAFKAESCLI_MIDDLEWARE"

# consumer config env vars
KAFKAESCLI_CONSUMER_TOPICS = "KAFKAESCLI_CONSUMER_TOPICS"
KAFKAESCLI_CONSUMER_METADATA = "KAFKAESCLI_CONSUMER_METADATA"
KAFKAESCLI_CONSUMER_ECHO = "KAFKAESCLI_CONSUMER_ECHO"
KAFKAESCLI_CONSUMER_GROUP_ID = "KAFKAESCLI_CONSUMER_GROUP_ID"
KAFKAESCLI_CONSUMER_WEBHOOK = "KAFKAESCLI_CONSUMER_WEBHOOK"
KAFKAESCLI_CONSUMER_LIMIT = "KAFKAESCLI_CONSUMER_LIMIT"

# producer config env vars
KAFKAESCLI_PRODUCER_TOPIC = "KAFKAESCLI_PRODUCER_TOPIC"
KAFKAESCLI_PRODUCER_VALUES = "KAFKAESCLI_PRODUCER_VALUES"
KAFKAESCLI_PRODUCER_FILE = "KAFKAESCLI_PRODUCER_FILE"
KAFKAESCLI_PRODUCER_STDIN = "KAFKAESCLI_PRODUCER_STDIN"
KAFKAESCLI_PRODUCER_METADATA = "KAFKAESCLI_PRODUCER_METADATA"
KAFKAESCLI_PRODUCER_ECHO = "KAFKAESCLI_PRODUCER_ECHO"

# web server config env vars
KAFKAESCLI_SERVER_HOST = "KAFKAESCLI_SERVER_HOST"
KAFKAESCLI_SERVER_PORT = "KAFKAESCLI_SERVER_PORT"
KAFKAESCLI_SERVER_AUTORELOAD = "KAFKAESCLI_SERVER_AUTORELOAD"
KAFKAESCLI_SERVER_WORKERS = "KAFKAESCLI_SERVER_WORKERS"
KAFKAESCLI_SEVER_LOG_LEVEL = "KAFKAESCLI_SEVER_LOG_LEVEL"
KAFKAESCLI_SEVER_LOG_CONFIG = "KAFKAESCLI_SEVER_LOG_CONFIG"
