#!/bin/sh
# -*- coding: utf-8 -*-
#
# This file is part of CERN Analysis Preservation Framework.
# Copyright (C) 2017 CERN.
#
# CERN Analysis Preservation Framework is free software; you can redistribute
# it and/or modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2 of the
# License, or (at your option) any later version.
#
# CERN Analysis Preservation Framework is distributed in the hope that it will
# be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with CERN Analysis Preservation Framework; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
# MA 02111-1307, USA.
#
# In applying this license, CERN does not
# waive the privileges and immunities granted to it by virtue of its status
# as an Intergovernmental Organization or submit itself to any jurisdiction.

# Quit on errors
set -o errexit

# Quit on unbound symbols
set -o nounset

check_script () {
    shellcheck run-tests.sh
}

check_pydocstyle () {
    pydocstyle cap_client
}

check_flake8 () {
    flake8 .
}

check_manifest () {
    check-manifest
}

check_pytest_unit () {
    python setup.py test
}

check_pytest_e2e () {
    pytest tests/e2e --vcr-record=all
}

check_pytest_e2e_vcr () {
    pytest tests/e2e --vcr-record=none
}

if [ $# -eq 0 ]; then
    check_script
    check_pydocstyle
    check_flake8
    check_manifest
    check_pytest_unit
    check_pytest_e2e
fi

for arg in "$@"
do
    case $arg in
        --check-shellscript) check_script;;
        --check-pydocstyle) check_pydocstyle;;
        --check-flake8) check_flake8;;
        --check-manifest) check_manifest;;
        --check-pytest-unit) check_pytest_unit;;
        --check-pytest-e2e) check_pytest_e2e;;
        --check-pytest-e2e-vcr) check_pytest_e2e_vcr;;
        *)
    esac
done
