#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Copyright (c) 2012, 2014 SMHI

# Author(s):

#   Martin Raspaud <martin.raspaud@smhi.se>

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

"""Testing publishing from posttroll.
"""

from posttroll.publisher import Publish
from posttroll.message import Message
from time import sleep
from datetime import datetime

#    """pytroll://PDS/0/norrköping/dev/polar/direct_readout file safusr.u@lxserv248.smhi.se 2014-08-27T07:57:53.0 v1.01 application/json {"satellite": "TERRA", "format": "PDS", "start_time": "2014-08-27T07:57:53", "level": "0", "orbit_number": 78142, "uri": "ssh://safe.smhi.se//san1/polar_in/direct_readout/eos/lvl0/P0420064AAAAAAAAAAAAAA14239075753001.PDS", "number": 1, "instrument": "modis", "end_time": "2014-08-27T08:08:35", "filename": "P0420064AAAAAAAAAAAAAA14239075753001.PDS", "type": "binary"}""",
#    """pytroll://PDS/0/norrköping/dev/polar/direct_readout file safusr.u@lxserv248.smhi.se 2014-08-27T07:57:53.0 v1.01 application/json {"satellite": "TERRA", "format": "PDS", "start_time": "2014-08-27T07:57:53.0", "level": "0", "orbit_number": 78142, "uri": "ssh://safe.smhi.se//san1/polar_in/direct_readout/eos/lvl0/P0420064AAAAAAAAAAAAAA14239075753000.PDS", "number": 0, "instrument": "modis", "end_time": "2014-08-27T08:08:35", "filename": "P0420064AAAAAAAAAAAAAA14239075753000.PDS", "type": "binary"}""",

msgs = [
    """pytroll://PDS/0/norrköping/dev/polar/direct_readout file safusr.u@lxserv248.smhi.se 2014-11-02T13:40:33.375380 v1.01 application/json {"uid": "P1540406AAAAAAAAAAAAAA14306133540001.PDS", "format": "PDS", "type": "binary", "start_time": "2014-11-02T13:35:40", "orbit_number": 66482, "uri": "ssh://safe.smhi.se//san1/polar_in/direct_readout/eos/lvl0/P1540406AAAAAAAAAAAAAA14306133540001.PDS", "platform_name": "EOS-Aqua", "end_time": "2014-11-02T13:40:28", "sensor": "airs", "data_processing_level": "0"}""",
    """pytroll://PDS/0/norrköping/dev/polar/direct_readout file safusr.u@lxserv248.smhi.se 2014-11-02T13:40:33.411860 v1.01 application/json {"uid": "P1540405AAAAAAAAAAAAAA14306133540000.PDS", "format": "PDS", "type": "binary", "start_time": "2014-11-02T13:35:40", "orbit_number": 66482, "uri": "ssh://safe.smhi.se//san1/polar_in/direct_readout/eos/lvl0/P1540405AAAAAAAAAAAAAA14306133540000.PDS", "platform_name": "EOS-Aqua", "end_time": "2014-11-02T13:40:28", "sensor": "airs", "data_processing_level": "0"}""",
    """pytroll://PDS/0/norrköping/dev/polar/direct_readout file safusr.u@lxserv248.smhi.se 2014-11-02T13:40:33.453141 v1.01 application/json {"uid": "P1540157AAAAAAAAAAAAAA14306133540001.PDS", "format": "PDS", "type": "binary", "start_time": "2014-11-02T13:35:40", "orbit_number": 66482, "uri": "ssh://safe.smhi.se//san1/polar_in/direct_readout/eos/lvl0/P1540157AAAAAAAAAAAAAA14306133540001.PDS", "platform_name": "EOS-Aqua", "end_time": "2014-11-02T13:40:28", "sensor": "ceres-y", "data_processing_level": "0"}""",
    """pytroll://PDS/0/norrköping/dev/polar/direct_readout file safusr.u@lxserv248.smhi.se 2014-11-02T13:40:33.492202 v1.01 application/json {"uid": "P1540342AAAAAAAAAAAAAA14306133540001.PDS", "format": "PDS", "type": "binary", "start_time": "2014-11-02T13:35:40", "orbit_number": 66482, "uri": "ssh://safe.smhi.se//san1/polar_in/direct_readout/eos/lvl0/P1540342AAAAAAAAAAAAAA14306133540001.PDS", "platform_name": "EOS-Aqua", "end_time": "2014-11-02T13:40:28", "sensor": "hsb", "data_processing_level": "0"}""",
    """pytroll://PDS/0/norrköping/dev/polar/direct_readout file safusr.u@lxserv248.smhi.se 2014-11-02T13:40:33.543295 v1.01 application/json {"uid": "P1540415AAAAAAAAAAAAAA14306133540001.PDS", "format": "PDS", "type": "binary", "start_time": "2014-11-02T13:35:40", "orbit_number": 66482, "uri": "ssh://safe.smhi.se//san1/polar_in/direct_readout/eos/lvl0/P1540415AAAAAAAAAAAAAA14306133540001.PDS", "platform_name": "EOS-Aqua", "end_time": "2014-11-02T13:40:28", "sensor": "airs", "data_processing_level": "0"}""",
    """pytroll://PDS/0/norrköping/dev/polar/direct_readout file safusr.u@lxserv248.smhi.se 2014-11-02T13:40:33.576734 v1.01 application/json {"uid": "P1540114AAAAAAAAAAAAAA14306133540000.PDS", "format": "PDS", "type": "binary", "start_time": "2014-11-02T13:35:40", "orbit_number": 66482, "uri": "ssh://safe.smhi.se//san1/polar_in/direct_readout/eos/lvl0/P1540114AAAAAAAAAAAAAA14306133540000.PDS", "platform_name": "EOS-Aqua", "end_time": "2014-11-02T13:40:28", "sensor": "0114", "data_processing_level": "0"}""",
    """pytroll://PDS/0/norrköping/dev/polar/direct_readout file safusr.u@lxserv248.smhi.se 2014-11-02T13:40:33.613781 v1.01 application/json {"uid": "P1540406AAAAAAAAAAAAAA14306133540000.PDS", "format": "PDS", "type": "binary", "start_time": "2014-11-02T13:35:40", "orbit_number": 66482, "uri": "ssh://safe.smhi.se//san1/polar_in/direct_readout/eos/lvl0/P1540406AAAAAAAAAAAAAA14306133540000.PDS", "platform_name": "EOS-Aqua", "end_time": "2014-11-02T13:40:28", "sensor": "airs", "data_processing_level": "0"}""",
    """pytroll://PDS/0/norrköping/dev/polar/direct_readout file safusr.u@lxserv248.smhi.se 2014-11-02T13:40:33.645608 v1.01 application/json {"uid": "P1540220AAAAAAAAAAAAAA14306133540000.PDS", "format": "PDS", "type": "binary", "start_time": "2014-11-02T13:35:40", "orbit_number": 66482, "uri": "ssh://safe.smhi.se//san1/polar_in/direct_readout/eos/lvl0/P1540220AAAAAAAAAAAAAA14306133540000.PDS", "platform_name": "EOS-Aqua", "end_time": "2014-11-02T13:40:28", "sensor": "0220", "data_processing_level": "0"}""",
    """pytroll://PDS/0/norrköping/dev/polar/direct_readout file safusr.u@lxserv248.smhi.se 2014-11-02T13:40:33.681020 v1.01 application/json {"uid": "P15409571540958154095914306133540000.PDS", "format": "PDS", "type": "binary", "start_time": "2014-11-02T13:35:40", "orbit_number": 66482, "uri": "ssh://safe.smhi.se//san1/polar_in/direct_readout/eos/lvl0/P15409571540958154095914306133540000.PDS", "platform_name": "EOS-Aqua", "end_time": "2014-11-02T13:40:28", "sensor": "gbad", "data_processing_level": "0"}""",
    """pytroll://PDS/0/norrköping/dev/polar/direct_readout file safusr.u@lxserv248.smhi.se 2014-11-02T13:40:33.718197 v1.01 application/json {"uid": "P1540064AAAAAAAAAAAAAA14306133540000.PDS", "format": "PDS", "type": "binary", "start_time": "2014-11-02T13:35:40", "orbit_number": 66482, "uri": "ssh://safe.smhi.se//san1/polar_in/direct_readout/eos/lvl0/P1540064AAAAAAAAAAAAAA14306133540000.PDS", "platform_name": "EOS-Aqua", "end_time": "2014-11-02T13:40:28", "sensor": "modis", "data_processing_level": "0"}""",
    """pytroll://PDS/0/norrköping/dev/polar/direct_readout file safusr.u@lxserv248.smhi.se 2014-11-02T13:40:33.752158 v1.01 application/json {"uid": "P1540141AAAAAAAAAAAAAA14306133540000.PDS", "format": "PDS", "type": "binary", "start_time": "2014-11-02T13:35:40", "orbit_number": 66482, "uri": "ssh://safe.smhi.se//san1/polar_in/direct_readout/eos/lvl0/P1540141AAAAAAAAAAAAAA14306133540000.PDS", "platform_name": "EOS-Aqua", "end_time": "2014-11-02T13:40:28", "sensor": "ceres+y", "data_processing_level": "0"}""",
    """pytroll://PDS/0/norrköping/dev/polar/direct_readout file safusr.u@lxserv248.smhi.se 2014-11-02T13:40:33.787323 v1.01 application/json {"uid": "P1540404AAAAAAAAAAAAAA14306133540000.PDS", "format": "PDS", "type": "binary", "start_time": "2014-11-02T13:35:40", "orbit_number": 66482, "uri": "ssh://safe.smhi.se//san1/polar_in/direct_readout/eos/lvl0/P1540404AAAAAAAAAAAAAA14306133540000.PDS", "platform_name": "EOS-Aqua", "end_time": "2014-11-02T13:40:28", "sensor": "airs", "data_processing_level": "0"}""",
    """pytroll://PDS/0/norrköping/dev/polar/direct_readout file safusr.u@lxserv248.smhi.se 2014-11-02T13:40:33.821965 v1.01 application/json {"uid": "P1540157AAAAAAAAAAAAAA14306133540000.PDS", "format": "PDS", "type": "binary", "start_time": "2014-11-02T13:35:40", "orbit_number": 66482, "uri": "ssh://safe.smhi.se//san1/polar_in/direct_readout/eos/lvl0/P1540157AAAAAAAAAAAAAA14306133540000.PDS", "platform_name": "EOS-Aqua", "end_time": "2014-11-02T13:40:28", "sensor": "ceres-y", "data_processing_level": "0"}""",
    """pytroll://PDS/0/norrköping/dev/polar/direct_readout file safusr.u@lxserv248.smhi.se 2014-11-02T13:40:43.571257 v1.01 application/json {"uid": "P1540064AAAAAAAAAAAAAA14306133540001.PDS", "format": "PDS", "type": "binary", "start_time": "2014-11-02T13:35:40", "orbit_number": 66482, "uri": "ssh://safe.smhi.se//san1/polar_in/direct_readout/eos/lvl0/P1540064AAAAAAAAAAAAAA14306133540001.PDS", "platform_name": "EOS-Aqua", "end_time": "2014-11-02T13:40:28", "sensor": "modis", "data_processing_level": "0"}""",
    """pytroll://PDS/0/norrköping/dev/polar/direct_readout file safusr.u@lxserv248.smhi.se 2014-11-02T13:40:43.843936 v1.01 application/json {"uid": "P15409571540958154095914306133540001.PDS", "format": "PDS", "type": "binary", "start_time": "2014-11-02T13:35:40", "orbit_number": 66482, "uri": "ssh://safe.smhi.se//san1/polar_in/direct_readout/eos/lvl0/P15409571540958154095914306133540001.PDS", "platform_name": "EOS-Aqua", "end_time": "2014-11-02T13:40:28", "sensor": "gbad", "data_processing_level": "0"}""",
    """pytroll://PDS/0/norrköping/dev/polar/direct_readout file safusr.u@lxserv248.smhi.se 2014-11-02T13:40:43.883777 v1.01 application/json {"uid": "P1540114AAAAAAAAAAAAAA14306133540001.PDS", "format": "PDS", "type": "binary", "start_time": "2014-11-02T13:35:40", "orbit_number": 66482, "uri": "ssh://safe.smhi.se//san1/polar_in/direct_readout/eos/lvl0/P1540114AAAAAAAAAAAAAA14306133540001.PDS", "platform_name": "EOS-Aqua", "end_time": "2014-11-02T13:40:28", "sensor": "0114", "data_processing_level": "0"}""",
    """pytroll://PDS/0/norrköping/dev/polar/direct_readout file safusr.u@lxserv248.smhi.se 2014-11-02T13:40:43.917033 v1.01 application/json {"uid": "P1540407AAAAAAAAAAAAAA14306133540000.PDS", "format": "PDS", "type": "binary", "start_time": "2014-11-02T13:35:40", "orbit_number": 66482, "uri": "ssh://safe.smhi.se//san1/polar_in/direct_readout/eos/lvl0/P1540407AAAAAAAAAAAAAA14306133540000.PDS", "platform_name": "EOS-Aqua", "end_time": "2014-11-02T13:40:28", "sensor": "airs", "data_processing_level": "0"}""",
    """pytroll://PDS/0/norrköping/dev/polar/direct_readout file safusr.u@lxserv248.smhi.se 2014-11-02T13:40:43.956814 v1.01 application/json {"uid": "P1540262AAAAAAAAAAAAAA14306133540001.PDS", "format": "PDS", "type": "binary", "start_time": "2014-11-02T13:35:40", "orbit_number": 66482, "uri": "ssh://safe.smhi.se//san1/polar_in/direct_readout/eos/lvl0/P1540262AAAAAAAAAAAAAA14306133540001.PDS", "platform_name": "EOS-Aqua", "end_time": "2014-11-02T13:40:28", "sensor": "amsu-a1", "data_processing_level": "0"}""",
    """pytroll://PDS/0/norrköping/dev/polar/direct_readout file safusr.u@lxserv248.smhi.se 2014-11-02T13:40:44.024826 v1.01 application/json {"uid": "P1540402AAAAAAAAAAAAAA14306133540001.PDS", "format": "PDS", "type": "binary", "start_time": "2014-11-02T13:35:40", "orbit_number": 66482, "uri": "ssh://safe.smhi.se//san1/polar_in/direct_readout/eos/lvl0/P1540402AAAAAAAAAAAAAA14306133540001.PDS", "platform_name": "EOS-Aqua", "end_time": "2014-11-02T13:40:28", "sensor": "amsr-e", "data_processing_level": "0"}""",
    """pytroll://PDS/0/norrköping/dev/polar/direct_readout file safusr.u@lxserv248.smhi.se 2014-11-02T13:40:44.062605 v1.01 application/json {"uid": "P1540402AAAAAAAAAAAAAA14306133540000.PDS", "format": "PDS", "type": "binary", "start_time": "2014-11-02T13:35:40", "orbit_number": 66482, "uri": "ssh://safe.smhi.se//san1/polar_in/direct_readout/eos/lvl0/P1540402AAAAAAAAAAAAAA14306133540000.PDS", "platform_name": "EOS-Aqua", "end_time": "2014-11-02T13:40:28", "sensor": "amsr-e", "data_processing_level": "0"}""",
    """pytroll://PDS/0/norrköping/dev/polar/direct_readout file safusr.u@lxserv248.smhi.se 2014-11-02T13:40:44.103493 v1.01 application/json {"uid": "P1540141AAAAAAAAAAAAAA14306133540001.PDS", "format": "PDS", "type": "binary", "start_time": "2014-11-02T13:35:40", "orbit_number": 66482, "uri": "ssh://safe.smhi.se//san1/polar_in/direct_readout/eos/lvl0/P1540141AAAAAAAAAAAAAA14306133540001.PDS", "platform_name": "EOS-Aqua", "end_time": "2014-11-02T13:40:28", "sensor": "ceres+y", "data_processing_level": "0"}""",
    """pytroll://PDS/0/norrköping/dev/polar/direct_readout file safusr.u@lxserv248.smhi.se 2014-11-02T13:40:44.155560 v1.01 application/json {"uid": "P1540405AAAAAAAAAAAAAA14306133540001.PDS", "format": "PDS", "type": "binary", "start_time": "2014-11-02T13:35:40", "orbit_number": 66482, "uri": "ssh://safe.smhi.se//san1/polar_in/direct_readout/eos/lvl0/P1540405AAAAAAAAAAAAAA14306133540001.PDS", "platform_name": "EOS-Aqua", "end_time": "2014-11-02T13:40:28", "sensor": "airs", "data_processing_level": "0"}""",
    """pytroll://PDS/0/norrköping/dev/polar/direct_readout file safusr.u@lxserv248.smhi.se 2014-11-02T13:40:44.192395 v1.01 application/json {"uid": "P1540415AAAAAAAAAAAAAA14306133540000.PDS", "format": "PDS", "type": "binary", "start_time": "2014-11-02T13:35:40", "orbit_number": 66482, "uri": "ssh://safe.smhi.se//san1/polar_in/direct_readout/eos/lvl0/P1540415AAAAAAAAAAAAAA14306133540000.PDS", "platform_name": "EOS-Aqua", "end_time": "2014-11-02T13:40:28", "sensor": "airs", "data_processing_level": "0"}""",
    """pytroll://PDS/0/norrköping/dev/polar/direct_readout file safusr.u@lxserv248.smhi.se 2014-11-02T13:40:44.232157 v1.01 application/json {"uid": "P1540261AAAAAAAAAAAAAA14306133540000.PDS", "format": "PDS", "type": "binary", "start_time": "2014-11-02T13:35:40", "orbit_number": 66482, "uri": "ssh://safe.smhi.se//san1/polar_in/direct_readout/eos/lvl0/P1540261AAAAAAAAAAAAAA14306133540000.PDS", "platform_name": "EOS-Aqua", "end_time": "2014-11-02T13:40:28", "sensor": "amsu-a1", "data_processing_level": "0"}""",
    """pytroll://PDS/0/norrköping/dev/polar/direct_readout file safusr.u@lxserv248.smhi.se 2014-11-02T13:40:44.266937 v1.01 application/json {"uid": "P1540290AAAAAAAAAAAAAA14306133540001.PDS", "format": "PDS", "type": "binary", "start_time": "2014-11-02T13:35:40", "orbit_number": 66482, "uri": "ssh://safe.smhi.se//san1/polar_in/direct_readout/eos/lvl0/P1540290AAAAAAAAAAAAAA14306133540001.PDS", "platform_name": "EOS-Aqua", "end_time": "2014-11-02T13:40:28", "sensor": "amsu-a2", "data_processing_level": "0"}""",
    """pytroll://PDS/0/norrköping/dev/polar/direct_readout file safusr.u@lxserv248.smhi.se 2014-11-02T13:40:44.302569 v1.01 application/json {"uid": "P1540262AAAAAAAAAAAAAA14306133540000.PDS", "format": "PDS", "type": "binary", "start_time": "2014-11-02T13:35:40", "orbit_number": 66482, "uri": "ssh://safe.smhi.se//san1/polar_in/direct_readout/eos/lvl0/P1540262AAAAAAAAAAAAAA14306133540000.PDS", "platform_name": "EOS-Aqua", "end_time": "2014-11-02T13:40:28", "sensor": "amsu-a1", "data_processing_level": "0"}""",
    """pytroll://PDS/0/norrköping/dev/polar/direct_readout file safusr.u@lxserv248.smhi.se 2014-11-02T13:40:44.337007 v1.01 application/json {"uid": "P1540266AAAAAAAAAAAAAA14306133540000.PDS", "format": "PDS", "type": "binary", "start_time": "2014-11-02T13:35:40", "orbit_number": 66482, "uri": "ssh://safe.smhi.se//san1/polar_in/direct_readout/eos/lvl0/P1540266AAAAAAAAAAAAAA14306133540000.PDS", "platform_name": "EOS-Aqua", "end_time": "2014-11-02T13:40:28", "sensor": "0266", "data_processing_level": "0"}""",
    """pytroll://PDS/0/norrköping/dev/polar/direct_readout file safusr.u@lxserv248.smhi.se 2014-11-02T13:40:44.370919 v1.01 application/json {"uid": "P1540220AAAAAAAAAAAAAA14306133540001.PDS", "format": "PDS", "type": "binary", "start_time": "2014-11-02T13:35:40", "orbit_number": 66482, "uri": "ssh://safe.smhi.se//san1/polar_in/direct_readout/eos/lvl0/P1540220AAAAAAAAAAAAAA14306133540001.PDS", "platform_name": "EOS-Aqua", "end_time": "2014-11-02T13:40:28", "sensor": "0220", "data_processing_level": "0"}""",
    """pytroll://PDS/0/norrköping/dev/polar/direct_readout file safusr.u@lxserv248.smhi.se 2014-11-02T13:40:44.406777 v1.01 application/json {"uid": "P1540266AAAAAAAAAAAAAA14306133540001.PDS", "format": "PDS", "type": "binary", "start_time": "2014-11-02T13:35:40", "orbit_number": 66482, "uri": "ssh://safe.smhi.se//san1/polar_in/direct_readout/eos/lvl0/P1540266AAAAAAAAAAAAAA14306133540001.PDS", "platform_name": "EOS-Aqua", "end_time": "2014-11-02T13:40:28", "sensor": "0266", "data_processing_level": "0"}""",
    """pytroll://PDS/0/norrköping/dev/polar/direct_readout file safusr.u@lxserv248.smhi.se 2014-11-02T13:40:44.445615 v1.01 application/json {"uid": "P1540290AAAAAAAAAAAAAA14306133540000.PDS", "format": "PDS", "type": "binary", "start_time": "2014-11-02T13:35:40", "orbit_number": 66482, "uri": "ssh://safe.smhi.se//san1/polar_in/direct_readout/eos/lvl0/P1540290AAAAAAAAAAAAAA14306133540000.PDS", "platform_name": "EOS-Aqua", "end_time": "2014-11-02T13:40:28", "sensor": "amsu-a2", "data_processing_level": "0"}""",
    """pytroll://PDS/0/norrköping/dev/polar/direct_readout file safusr.u@lxserv248.smhi.se 2014-11-02T13:40:44.576156 v1.01 application/json {"uid": "P1540407AAAAAAAAAAAAAA14306133540001.PDS", "format": "PDS", "type": "binary", "start_time": "2014-11-02T13:35:40", "orbit_number": 66482, "uri": "ssh://safe.smhi.se//san1/polar_in/direct_readout/eos/lvl0/P1540407AAAAAAAAAAAAAA14306133540001.PDS", "platform_name": "EOS-Aqua", "end_time": "2014-11-02T13:40:28", "sensor": "airs", "data_processing_level": "0"}""",
    """pytroll://PDS/0/norrköping/dev/polar/direct_readout file safusr.u@lxserv248.smhi.se 2014-11-02T13:40:44.687083 v1.01 application/json {"uid": "P1540342AAAAAAAAAAAAAA14306133540000.PDS", "format": "PDS", "type": "binary", "start_time": "2014-11-02T13:35:40", "orbit_number": 66482, "uri": "ssh://safe.smhi.se//san1/polar_in/direct_readout/eos/lvl0/P1540342AAAAAAAAAAAAAA14306133540000.PDS", "platform_name": "EOS-Aqua", "end_time": "2014-11-02T13:40:28", "sensor": "hsb", "data_processing_level": "0"}""",
    """pytroll://PDS/0/norrköping/dev/polar/direct_readout file safusr.u@lxserv248.smhi.se 2014-11-02T13:40:45.412891 v1.01 application/json {"uid": "P1540404AAAAAAAAAAAAAA14306133540001.PDS", "format": "PDS", "type": "binary", "start_time": "2014-11-02T13:35:40", "orbit_number": 66482, "uri": "ssh://safe.smhi.se//san1/polar_in/direct_readout/eos/lvl0/P1540404AAAAAAAAAAAAAA14306133540001.PDS", "platform_name": "EOS-Aqua", "end_time": "2014-11-02T13:40:28", "sensor": "airs", "data_processing_level": "0"}""",
    """pytroll://PDS/0/norrköping/dev/polar/direct_readout file safusr.u@lxserv248.smhi.se 2014-11-02T13:40:45.449433 v1.01 application/json {"uid": "P1540414AAAAAAAAAAAAAA14306133540000.PDS", "format": "PDS", "type": "binary", "start_time": "2014-11-02T13:35:40", "orbit_number": 66482, "uri": "ssh://safe.smhi.se//san1/polar_in/direct_readout/eos/lvl0/P1540414AAAAAAAAAAAAAA14306133540000.PDS", "platform_name": "EOS-Aqua", "end_time": "2014-11-02T13:40:28", "sensor": "airs", "data_processing_level": "0"}""",
    """pytroll://PDS/0/norrköping/dev/polar/direct_readout file safusr.u@lxserv248.smhi.se 2014-11-02T13:40:45.485407 v1.01 application/json {"uid": "P1540261AAAAAAAAAAAAAA14306133540001.PDS", "format": "PDS", "type": "binary", "start_time": "2014-11-02T13:35:40", "orbit_number": 66482, "uri": "ssh://safe.smhi.se//san1/polar_in/direct_readout/eos/lvl0/P1540261AAAAAAAAAAAAAA14306133540001.PDS", "platform_name": "EOS-Aqua", "end_time": "2014-11-02T13:40:28", "sensor": "amsu-a1", "data_processing_level": "0"}""",
    """pytroll://PDS/0/norrköping/dev/polar/direct_readout file safusr.u@lxserv248.smhi.se 2014-11-02T13:40:45.523234 v1.01 application/json {"uid": "P1540414AAAAAAAAAAAAAA14306133540001.PDS", "format": "PDS", "type": "binary", "start_time": "2014-11-02T13:35:40", "orbit_number": 66482, "uri": "ssh://safe.smhi.se//san1/polar_in/direct_readout/eos/lvl0/P1540414AAAAAAAAAAAAAA14306133540001.PDS", "platform_name": "EOS-Aqua", "end_time": "2014-11-02T13:40:28", "sensor": "airs", "data_processing_level": "0"}""",

]

with Publish("receiver", 0, ["PDS", ]) as pds_pub:
    while True:
        # msg = Message('/oper/polar/direct_readout/norrköping', "info",
        # "the time is now " + str(datetime.now())).encode()
        # idx = np.random.randint(0,3)
        # msg = TEST_MSG[idx]
        # hrpt_pub.send(msg)
        # pds_pub.send(msg)
        # print msg
        for msg in msgs:
            pds_pub.send(msg)
            sleep(3)

        # sleep(30)
        # msg = Message('/oper/polar/direct_readout/norrköping', "info",
        #               "the time is now " + str(datetime.now())).encode()
        # pds_pub.send(msg)
        # print msg
        # sleep(0.5)
        break
