
<img src="https://uploads-ssl.webflow.com/616e87dbb58bda5ac7435eb0/616ead050b8ac6154ca472a6_aeda-logo-web.svg" alt="mypic" style="width:1000px; height:400px"/>

![PyPi](https://img.shields.io/pypi/v/aeda?label=pypi%20package)

# Aeda API 
An Aeda service for getting detailed info for cars using registration number.

# Getting Started
## Installation process

### 1. Install from PyPi using:
```console
python -m pip install aeda
```

### 2. Add global variables

```
AEDA_API_CAR_USER
AEDA_API_CAR_PASSWORD
``` 

#### 2.1  Ubuntu

Run in console or add to `~/.bashrc` or `~/.zshrc` or other system command config files:
```console
export AEDA_API_CAR_USER=$(yq -r '.aeda.api.car.user' ~/.secrets/aeda.yaml)
```
Where `~/.secrets/aeda.yaml` is a YAML file containing
```
aeda:
    api:
        car:
            user: XXXXXXXX
            password: XXXXXXXXXXXXXX
```
Remember to install yq with
```console
apt install yq
```
#### 2.2 Windows


## Usage
Run either using command line or as a python library.

### 1. Command line
Run from command line using:
```console
python -m aeda.car.main --regnumber XXXXXXXXX
``` 
### 2. API
Run in a python script using:
```python
import aeda.car
aeda.car.get_car_from_reg_number("XXXXXXXXX")
``` 


## API references

Endpoint:
```
https://aedacar.azurewebsites.net/api/car?code=BzaCA1bdqU21cfZVn8r3KJwaoivzaOla7o6sLa-qD0elAzFulXlzyA==
```
Payload:
```
{'payload': {'username':    'XXXXXXX'.
             'apiKey':      'XXXXXXX',
             'regNumber':   'XXXXXXX'
            }
}
``` 

# Versions 
Using Calender Versioning: `YYYY.MM.PATCH`
- version "2022.12.11"
  - December 2022
  - update README.md  
- version "2022.12.1"
  - December 2022
  - first release  