# mypy-boto3-iot1click-devices

[![PyPI - mypy-boto3-iot1click-devices](https://img.shields.io/pypi/v/mypy-boto3-iot1click-devices.svg?color=blue)](https://pypi.org/project/mypy-boto3-iot1click-devices)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-iot1click-devices.svg?color=blue)](https://pypi.org/project/mypy-boto3-iot1click-devices)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.IoT1ClickDevicesService 1.16.27](https://boto3.amazonaws.com/v1/documentation/api/1.16.27/reference/services/iot1click-devices.html#IoT1ClickDevicesService) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 4.0.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-iot1click-devices](#mypy-boto3-iot1click-devices)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `IoT1ClickDevicesService` service.

```bash
python -m pip install boto3-stubs[iot1click-devices]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[iot1click-devices]` in your environment: `python -m pip install 'boto3-stubs[iot1click-devices]'`

Both type checking and auto-complete should work for `IoT1ClickDevicesService` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[iot1click-devices]` in your environment: `python -m pip install 'boto3-stubs[iot1click-devices]'`

Both type checking and auto-complete should work for `IoT1ClickDevicesService` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[iot1click-devices]` in your environment: `python -m pip install 'boto3-stubs[iot1click-devices]'`
- Run `mypy` as usual

Type checking should work for `IoT1ClickDevicesService` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[iot1click-devices]` in your environment: `python -m pip install 'boto3-stubs[iot1click-devices]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `IoT1ClickDevicesService` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`IoT1ClickDevicesServiceClient` provides annotations for `boto3.client("iot1click-devices")`.

```python
import boto3

from mypy_boto3_iot1click_devices import IoT1ClickDevicesServiceClient

client: IoT1ClickDevicesServiceClient = boto3.client("iot1click-devices")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: IoT1ClickDevicesServiceClient = session.client("iot1click-devices")
```

### Paginators annotations

`mypy_boto3_iot1click_devices.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_iot1click_devices import IoT1ClickDevicesServiceClient
from mypy_boto3_iot1click_devices.paginator import ListDeviceEventsPaginator, ListDevicesPaginator

client: IoT1ClickDevicesServiceClient = boto3.client("iot1click-devices")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_device_events_paginator: ListDeviceEventsPaginator = client.get_paginator("list_device_events")
list_devices_paginator: ListDevicesPaginator = client.get_paginator("list_devices")
```







### Typed dictionations

`mypy_boto3_iot1click_devices.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_iot1click_devices.type_defs import (
    ClaimDevicesByClaimCodeResponseTypeDef,
    DescribeDeviceResponseTypeDef,
    DeviceDescriptionTypeDef,
    DeviceEventTypeDef,
    DeviceMethodTypeDef,
    DeviceTypeDef,
    FinalizeDeviceClaimResponseTypeDef,
    GetDeviceMethodsResponseTypeDef,
    InitiateDeviceClaimResponseTypeDef,
    InvokeDeviceMethodResponseTypeDef,
    ListDeviceEventsResponseTypeDef,
    ListDevicesResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    PaginatorConfigTypeDef,
    UnclaimDeviceResponseTypeDef,
)

def get_structure() -> DeviceDescriptionTypeDef:
    return {
      ...
    }
```
