# coding: utf-8

"""
    fatcat

    Fatcat is a scalable, versioned, API-oriented catalog of bibliographic entities and file metadata.   # noqa: E501

    The version of the OpenAPI document: 0.3.1
    Contact: webservices@archive.org
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class EntityEdit(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'edit_id': 'str',
        'ident': 'str',
        'revision': 'str',
        'prev_revision': 'str',
        'redirect_ident': 'str',
        'editgroup_id': 'str',
        'extra': 'dict(str, object)'
    }

    attribute_map = {
        'edit_id': 'edit_id',
        'ident': 'ident',
        'revision': 'revision',
        'prev_revision': 'prev_revision',
        'redirect_ident': 'redirect_ident',
        'editgroup_id': 'editgroup_id',
        'extra': 'extra'
    }

    def __init__(self, edit_id=None, ident=None, revision=None, prev_revision=None, redirect_ident=None, editgroup_id=None, extra=None):  # noqa: E501
        """EntityEdit - a model defined in OpenAPI"""  # noqa: E501

        self._edit_id = None
        self._ident = None
        self._revision = None
        self._prev_revision = None
        self._redirect_ident = None
        self._editgroup_id = None
        self._extra = None
        self.discriminator = None

        self.edit_id = edit_id
        self.ident = ident
        if revision is not None:
            self.revision = revision
        if prev_revision is not None:
            self.prev_revision = prev_revision
        if redirect_ident is not None:
            self.redirect_ident = redirect_ident
        self.editgroup_id = editgroup_id
        if extra is not None:
            self.extra = extra

    @property
    def edit_id(self):
        """Gets the edit_id of this EntityEdit.  # noqa: E501

        Unique UUID for this specific edit object.   # noqa: E501

        :return: The edit_id of this EntityEdit.  # noqa: E501
        :rtype: str
        """
        return self._edit_id

    @edit_id.setter
    def edit_id(self, edit_id):
        """Sets the edit_id of this EntityEdit.

        Unique UUID for this specific edit object.   # noqa: E501

        :param edit_id: The edit_id of this EntityEdit.  # noqa: E501
        :type: str
        """
        if edit_id is None:
            raise ValueError("Invalid value for `edit_id`, must not be `None`")  # noqa: E501
        if edit_id is not None and len(edit_id) > 36:
            raise ValueError("Invalid value for `edit_id`, length must be less than or equal to `36`")  # noqa: E501
        if edit_id is not None and len(edit_id) < 36:
            raise ValueError("Invalid value for `edit_id`, length must be greater than or equal to `36`")  # noqa: E501
        if edit_id is not None and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', edit_id):  # noqa: E501
            raise ValueError(r"Invalid value for `edit_id`, must be a follow pattern or equal to `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501

        self._edit_id = edit_id

    @property
    def ident(self):
        """Gets the ident of this EntityEdit.  # noqa: E501

        Fatcat identifier of the entity this edit is mutating.   # noqa: E501

        :return: The ident of this EntityEdit.  # noqa: E501
        :rtype: str
        """
        return self._ident

    @ident.setter
    def ident(self, ident):
        """Sets the ident of this EntityEdit.

        Fatcat identifier of the entity this edit is mutating.   # noqa: E501

        :param ident: The ident of this EntityEdit.  # noqa: E501
        :type: str
        """
        if ident is None:
            raise ValueError("Invalid value for `ident`, must not be `None`")  # noqa: E501
        if ident is not None and len(ident) > 26:
            raise ValueError("Invalid value for `ident`, length must be less than or equal to `26`")  # noqa: E501
        if ident is not None and len(ident) < 26:
            raise ValueError("Invalid value for `ident`, length must be greater than or equal to `26`")  # noqa: E501
        if ident is not None and not re.search(r'[a-zA-Z2-7]{26}', ident):  # noqa: E501
            raise ValueError(r"Invalid value for `ident`, must be a follow pattern or equal to `/[a-zA-Z2-7]{26}/`")  # noqa: E501

        self._ident = ident

    @property
    def revision(self):
        """Gets the revision of this EntityEdit.  # noqa: E501

        Entity revision that this edit will set the entity to. May be `null` in the case of deletions.   # noqa: E501

        :return: The revision of this EntityEdit.  # noqa: E501
        :rtype: str
        """
        return self._revision

    @revision.setter
    def revision(self, revision):
        """Sets the revision of this EntityEdit.

        Entity revision that this edit will set the entity to. May be `null` in the case of deletions.   # noqa: E501

        :param revision: The revision of this EntityEdit.  # noqa: E501
        :type: str
        """
        if revision is not None and len(revision) > 36:
            raise ValueError("Invalid value for `revision`, length must be less than or equal to `36`")  # noqa: E501
        if revision is not None and len(revision) < 36:
            raise ValueError("Invalid value for `revision`, length must be greater than or equal to `36`")  # noqa: E501
        if revision is not None and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', revision):  # noqa: E501
            raise ValueError(r"Invalid value for `revision`, must be a follow pattern or equal to `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501

        self._revision = revision

    @property
    def prev_revision(self):
        """Gets the prev_revision of this EntityEdit.  # noqa: E501

        Revision of entity just before this edit. May be used in the future to prevent edit race conditions.   # noqa: E501

        :return: The prev_revision of this EntityEdit.  # noqa: E501
        :rtype: str
        """
        return self._prev_revision

    @prev_revision.setter
    def prev_revision(self, prev_revision):
        """Sets the prev_revision of this EntityEdit.

        Revision of entity just before this edit. May be used in the future to prevent edit race conditions.   # noqa: E501

        :param prev_revision: The prev_revision of this EntityEdit.  # noqa: E501
        :type: str
        """
        if prev_revision is not None and len(prev_revision) > 36:
            raise ValueError("Invalid value for `prev_revision`, length must be less than or equal to `36`")  # noqa: E501
        if prev_revision is not None and len(prev_revision) < 36:
            raise ValueError("Invalid value for `prev_revision`, length must be greater than or equal to `36`")  # noqa: E501
        if prev_revision is not None and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', prev_revision):  # noqa: E501
            raise ValueError(r"Invalid value for `prev_revision`, must be a follow pattern or equal to `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501

        self._prev_revision = prev_revision

    @property
    def redirect_ident(self):
        """Gets the redirect_ident of this EntityEdit.  # noqa: E501

        When an edit is to merge entities (redirect one to another), this is the entity fatcat identifier for the target entity.   # noqa: E501

        :return: The redirect_ident of this EntityEdit.  # noqa: E501
        :rtype: str
        """
        return self._redirect_ident

    @redirect_ident.setter
    def redirect_ident(self, redirect_ident):
        """Sets the redirect_ident of this EntityEdit.

        When an edit is to merge entities (redirect one to another), this is the entity fatcat identifier for the target entity.   # noqa: E501

        :param redirect_ident: The redirect_ident of this EntityEdit.  # noqa: E501
        :type: str
        """
        if redirect_ident is not None and len(redirect_ident) > 26:
            raise ValueError("Invalid value for `redirect_ident`, length must be less than or equal to `26`")  # noqa: E501
        if redirect_ident is not None and len(redirect_ident) < 26:
            raise ValueError("Invalid value for `redirect_ident`, length must be greater than or equal to `26`")  # noqa: E501
        if redirect_ident is not None and not re.search(r'[a-zA-Z2-7]{26}', redirect_ident):  # noqa: E501
            raise ValueError(r"Invalid value for `redirect_ident`, must be a follow pattern or equal to `/[a-zA-Z2-7]{26}/`")  # noqa: E501

        self._redirect_ident = redirect_ident

    @property
    def editgroup_id(self):
        """Gets the editgroup_id of this EntityEdit.  # noqa: E501

        Editgroup identifier that this edit is part of.   # noqa: E501

        :return: The editgroup_id of this EntityEdit.  # noqa: E501
        :rtype: str
        """
        return self._editgroup_id

    @editgroup_id.setter
    def editgroup_id(self, editgroup_id):
        """Sets the editgroup_id of this EntityEdit.

        Editgroup identifier that this edit is part of.   # noqa: E501

        :param editgroup_id: The editgroup_id of this EntityEdit.  # noqa: E501
        :type: str
        """
        if editgroup_id is None:
            raise ValueError("Invalid value for `editgroup_id`, must not be `None`")  # noqa: E501
        if editgroup_id is not None and len(editgroup_id) > 26:
            raise ValueError("Invalid value for `editgroup_id`, length must be less than or equal to `26`")  # noqa: E501
        if editgroup_id is not None and len(editgroup_id) < 26:
            raise ValueError("Invalid value for `editgroup_id`, length must be greater than or equal to `26`")  # noqa: E501
        if editgroup_id is not None and not re.search(r'[a-zA-Z2-7]{26}', editgroup_id):  # noqa: E501
            raise ValueError(r"Invalid value for `editgroup_id`, must be a follow pattern or equal to `/[a-zA-Z2-7]{26}/`")  # noqa: E501

        self._editgroup_id = editgroup_id

    @property
    def extra(self):
        """Gets the extra of this EntityEdit.  # noqa: E501


        :return: The extra of this EntityEdit.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._extra

    @extra.setter
    def extra(self, extra):
        """Sets the extra of this EntityEdit.


        :param extra: The extra of this EntityEdit.  # noqa: E501
        :type: dict(str, object)
        """

        self._extra = extra

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EntityEdit):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
