# coding: utf-8

"""
    fatcat

    Fatcat is a scalable, versioned, API-oriented catalog of bibliographic entities and file metadata.   # noqa: E501

    The version of the OpenAPI document: 0.3.1
    Contact: webservices@archive.org
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class Editgroup(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'editgroup_id': 'str',
        'editor_id': 'str',
        'editor': 'Editor',
        'changelog_index': 'int',
        'created': 'datetime',
        'submitted': 'datetime',
        'description': 'str',
        'extra': 'dict(str, object)',
        'annotations': 'list[EditgroupAnnotation]',
        'edits': 'EditgroupEdits'
    }

    attribute_map = {
        'editgroup_id': 'editgroup_id',
        'editor_id': 'editor_id',
        'editor': 'editor',
        'changelog_index': 'changelog_index',
        'created': 'created',
        'submitted': 'submitted',
        'description': 'description',
        'extra': 'extra',
        'annotations': 'annotations',
        'edits': 'edits'
    }

    def __init__(self, editgroup_id=None, editor_id=None, editor=None, changelog_index=None, created=None, submitted=None, description=None, extra=None, annotations=None, edits=None):  # noqa: E501
        """Editgroup - a model defined in OpenAPI"""  # noqa: E501

        self._editgroup_id = None
        self._editor_id = None
        self._editor = None
        self._changelog_index = None
        self._created = None
        self._submitted = None
        self._description = None
        self._extra = None
        self._annotations = None
        self._edits = None
        self.discriminator = None

        if editgroup_id is not None:
            self.editgroup_id = editgroup_id
        if editor_id is not None:
            self.editor_id = editor_id
        if editor is not None:
            self.editor = editor
        if changelog_index is not None:
            self.changelog_index = changelog_index
        if created is not None:
            self.created = created
        if submitted is not None:
            self.submitted = submitted
        if description is not None:
            self.description = description
        if extra is not None:
            self.extra = extra
        if annotations is not None:
            self.annotations = annotations
        if edits is not None:
            self.edits = edits

    @property
    def editgroup_id(self):
        """Gets the editgroup_id of this Editgroup.  # noqa: E501

        Fatcat identifier for this editgroup. Assigned on creation.   # noqa: E501

        :return: The editgroup_id of this Editgroup.  # noqa: E501
        :rtype: str
        """
        return self._editgroup_id

    @editgroup_id.setter
    def editgroup_id(self, editgroup_id):
        """Sets the editgroup_id of this Editgroup.

        Fatcat identifier for this editgroup. Assigned on creation.   # noqa: E501

        :param editgroup_id: The editgroup_id of this Editgroup.  # noqa: E501
        :type: str
        """
        if editgroup_id is not None and len(editgroup_id) > 26:
            raise ValueError("Invalid value for `editgroup_id`, length must be less than or equal to `26`")  # noqa: E501
        if editgroup_id is not None and len(editgroup_id) < 26:
            raise ValueError("Invalid value for `editgroup_id`, length must be greater than or equal to `26`")  # noqa: E501
        if editgroup_id is not None and not re.search(r'[a-zA-Z2-7]{26}', editgroup_id):  # noqa: E501
            raise ValueError(r"Invalid value for `editgroup_id`, must be a follow pattern or equal to `/[a-zA-Z2-7]{26}/`")  # noqa: E501

        self._editgroup_id = editgroup_id

    @property
    def editor_id(self):
        """Gets the editor_id of this Editgroup.  # noqa: E501

        Fatcat identifer of editor that created this editgroup.   # noqa: E501

        :return: The editor_id of this Editgroup.  # noqa: E501
        :rtype: str
        """
        return self._editor_id

    @editor_id.setter
    def editor_id(self, editor_id):
        """Sets the editor_id of this Editgroup.

        Fatcat identifer of editor that created this editgroup.   # noqa: E501

        :param editor_id: The editor_id of this Editgroup.  # noqa: E501
        :type: str
        """
        if editor_id is not None and len(editor_id) > 26:
            raise ValueError("Invalid value for `editor_id`, length must be less than or equal to `26`")  # noqa: E501
        if editor_id is not None and len(editor_id) < 26:
            raise ValueError("Invalid value for `editor_id`, length must be greater than or equal to `26`")  # noqa: E501
        if editor_id is not None and not re.search(r'[a-zA-Z2-7]{26}', editor_id):  # noqa: E501
            raise ValueError(r"Invalid value for `editor_id`, must be a follow pattern or equal to `/[a-zA-Z2-7]{26}/`")  # noqa: E501

        self._editor_id = editor_id

    @property
    def editor(self):
        """Gets the editor of this Editgroup.  # noqa: E501


        :return: The editor of this Editgroup.  # noqa: E501
        :rtype: Editor
        """
        return self._editor

    @editor.setter
    def editor(self, editor):
        """Sets the editor of this Editgroup.


        :param editor: The editor of this Editgroup.  # noqa: E501
        :type: Editor
        """

        self._editor = editor

    @property
    def changelog_index(self):
        """Gets the changelog_index of this Editgroup.  # noqa: E501

        For accepted/merged editgroups, the changelog index that the accept occured at. WARNING: not populated in all contexts that an editgroup could be included in a response.   # noqa: E501

        :return: The changelog_index of this Editgroup.  # noqa: E501
        :rtype: int
        """
        return self._changelog_index

    @changelog_index.setter
    def changelog_index(self, changelog_index):
        """Sets the changelog_index of this Editgroup.

        For accepted/merged editgroups, the changelog index that the accept occured at. WARNING: not populated in all contexts that an editgroup could be included in a response.   # noqa: E501

        :param changelog_index: The changelog_index of this Editgroup.  # noqa: E501
        :type: int
        """

        self._changelog_index = changelog_index

    @property
    def created(self):
        """Gets the created of this Editgroup.  # noqa: E501

        Timestamp when this editgroup was first created.   # noqa: E501

        :return: The created of this Editgroup.  # noqa: E501
        :rtype: datetime
        """
        return self._created

    @created.setter
    def created(self, created):
        """Sets the created of this Editgroup.

        Timestamp when this editgroup was first created.   # noqa: E501

        :param created: The created of this Editgroup.  # noqa: E501
        :type: datetime
        """

        self._created = created

    @property
    def submitted(self):
        """Gets the submitted of this Editgroup.  # noqa: E501

        Timestamp when this editgroup was most recently submitted for review. If withdrawn, or never submitted, will be `null`.   # noqa: E501

        :return: The submitted of this Editgroup.  # noqa: E501
        :rtype: datetime
        """
        return self._submitted

    @submitted.setter
    def submitted(self, submitted):
        """Sets the submitted of this Editgroup.

        Timestamp when this editgroup was most recently submitted for review. If withdrawn, or never submitted, will be `null`.   # noqa: E501

        :param submitted: The submitted of this Editgroup.  # noqa: E501
        :type: datetime
        """

        self._submitted = submitted

    @property
    def description(self):
        """Gets the description of this Editgroup.  # noqa: E501

        Comment describing the changes in this editgroup. Can be updated with PUT request.   # noqa: E501

        :return: The description of this Editgroup.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Editgroup.

        Comment describing the changes in this editgroup. Can be updated with PUT request.   # noqa: E501

        :param description: The description of this Editgroup.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def extra(self):
        """Gets the extra of this Editgroup.  # noqa: E501

        Free-form JSON metadata attached to this editgroup. Eg, metadata provenance, or script user-agent details. See guide for (unenforced) schema norms.   # noqa: E501

        :return: The extra of this Editgroup.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._extra

    @extra.setter
    def extra(self, extra):
        """Sets the extra of this Editgroup.

        Free-form JSON metadata attached to this editgroup. Eg, metadata provenance, or script user-agent details. See guide for (unenforced) schema norms.   # noqa: E501

        :param extra: The extra of this Editgroup.  # noqa: E501
        :type: dict(str, object)
        """

        self._extra = extra

    @property
    def annotations(self):
        """Gets the annotations of this Editgroup.  # noqa: E501

        Only included in GET responses, and not in all contexts. Do not include this field in PUT or POST requests.   # noqa: E501

        :return: The annotations of this Editgroup.  # noqa: E501
        :rtype: list[EditgroupAnnotation]
        """
        return self._annotations

    @annotations.setter
    def annotations(self, annotations):
        """Sets the annotations of this Editgroup.

        Only included in GET responses, and not in all contexts. Do not include this field in PUT or POST requests.   # noqa: E501

        :param annotations: The annotations of this Editgroup.  # noqa: E501
        :type: list[EditgroupAnnotation]
        """

        self._annotations = annotations

    @property
    def edits(self):
        """Gets the edits of this Editgroup.  # noqa: E501


        :return: The edits of this Editgroup.  # noqa: E501
        :rtype: EditgroupEdits
        """
        return self._edits

    @edits.setter
    def edits(self, edits):
        """Sets the edits of this Editgroup.


        :param edits: The edits of this Editgroup.  # noqa: E501
        :type: EditgroupEdits
        """

        self._edits = edits

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Editgroup):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
