# coding: utf-8

"""
    fatcat

    Fatcat is a scalable, versioned, API-oriented catalog of bibliographic entities and file metadata.   # noqa: E501

    The version of the OpenAPI document: 0.4.0
    Contact: webservices@archive.org
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from fatcat_openapi_client.api_client import ApiClient
from fatcat_openapi_client.exceptions import (
    ApiTypeError,
    ApiValueError
)


class DefaultApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def accept_editgroup(self, editgroup_id, **kwargs):  # noqa: E501
        """accept_editgroup  # noqa: E501

        Accept (\"merge\") the given editgroup into the catalog. The editgroup must be open (not already accepted), and the editor making this request must have the `admin` role.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.accept_editgroup(editgroup_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: base32-encoded unique identifier (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Success
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.accept_editgroup_with_http_info(editgroup_id, **kwargs)  # noqa: E501

    def accept_editgroup_with_http_info(self, editgroup_id, **kwargs):  # noqa: E501
        """accept_editgroup  # noqa: E501

        Accept (\"merge\") the given editgroup into the catalog. The editgroup must be open (not already accepted), and the editor making this request must have the `admin` role.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.accept_editgroup_with_http_info(editgroup_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: base32-encoded unique identifier (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Success, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['editgroup_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method accept_editgroup" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'editgroup_id' is set
        if ('editgroup_id' not in local_var_params or
                local_var_params['editgroup_id'] is None):
            raise ApiValueError("Missing the required parameter `editgroup_id` when calling `accept_editgroup`")  # noqa: E501

        if ('editgroup_id' in local_var_params and
                len(local_var_params['editgroup_id']) > 26):
            raise ApiValueError("Invalid value for parameter `editgroup_id` when calling `accept_editgroup`, length must be less than or equal to `26`")  # noqa: E501
        if ('editgroup_id' in local_var_params and
                len(local_var_params['editgroup_id']) < 26):
            raise ApiValueError("Invalid value for parameter `editgroup_id` when calling `accept_editgroup`, length must be greater than or equal to `26`")  # noqa: E501
        if 'editgroup_id' in local_var_params and not re.search(r'[a-zA-Z2-7]{26}', local_var_params['editgroup_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `editgroup_id` when calling `accept_editgroup`, must conform to the pattern `/[a-zA-Z2-7]{26}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'editgroup_id' in local_var_params:
            path_params['editgroup_id'] = local_var_params['editgroup_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/editgroup/{editgroup_id}/accept', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Success',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def auth_check(self, **kwargs):  # noqa: E501
        """auth_check  # noqa: E501

        Verify that authentication (API token) is working as expected. The optional `role` parameter can be used to verify that the current account (editor) has permissions for the given role.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.auth_check(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str role:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Success
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.auth_check_with_http_info(**kwargs)  # noqa: E501

    def auth_check_with_http_info(self, **kwargs):  # noqa: E501
        """auth_check  # noqa: E501

        Verify that authentication (API token) is working as expected. The optional `role` parameter can be used to verify that the current account (editor) has permissions for the given role.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.auth_check_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str role:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Success, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['role']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method auth_check" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'role' in local_var_params:
            query_params.append(('role', local_var_params['role']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/auth/check', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Success',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def auth_oidc(self, oidc_params, **kwargs):  # noqa: E501
        """auth_oidc  # noqa: E501

        Login or create editor account using OIDC metadata (internal method).  This method is used by privileged front-end tools (like the web interface service) to process editor logins using OpenID Connect (OIDC) and/or OAuth. Most accounts (including tool and bot accounts) do not have sufficient privileges to call this method, which requires the `admin` role.  The method returns an API token; the HTTP status code indicates whether an existing account was logged in, or a new account was created.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.auth_oidc(oidc_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param AuthOidc oidc_params: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AuthOidcResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.auth_oidc_with_http_info(oidc_params, **kwargs)  # noqa: E501

    def auth_oidc_with_http_info(self, oidc_params, **kwargs):  # noqa: E501
        """auth_oidc  # noqa: E501

        Login or create editor account using OIDC metadata (internal method).  This method is used by privileged front-end tools (like the web interface service) to process editor logins using OpenID Connect (OIDC) and/or OAuth. Most accounts (including tool and bot accounts) do not have sufficient privileges to call this method, which requires the `admin` role.  The method returns an API token; the HTTP status code indicates whether an existing account was logged in, or a new account was created.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.auth_oidc_with_http_info(oidc_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param AuthOidc oidc_params: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AuthOidcResult, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['oidc_params']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method auth_oidc" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'oidc_params' is set
        if ('oidc_params' not in local_var_params or
                local_var_params['oidc_params'] is None):
            raise ApiValueError("Missing the required parameter `oidc_params` when calling `auth_oidc`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'oidc_params' in local_var_params:
            body_params = local_var_params['oidc_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/auth/oidc', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AuthOidcResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_auth_token(self, editor_id, **kwargs):  # noqa: E501
        """create_auth_token  # noqa: E501

        Generate a new auth token for a given editor (internal method).  This method is used by the web interface to generate API tokens for users. It can not be called by editors (human or bot) to generate new tokens for themselves, at least at this time.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_auth_token(editor_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editor_id: (required)
        :param int duration_seconds: How long API token should be valid for (in seconds)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AuthTokenResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_auth_token_with_http_info(editor_id, **kwargs)  # noqa: E501

    def create_auth_token_with_http_info(self, editor_id, **kwargs):  # noqa: E501
        """create_auth_token  # noqa: E501

        Generate a new auth token for a given editor (internal method).  This method is used by the web interface to generate API tokens for users. It can not be called by editors (human or bot) to generate new tokens for themselves, at least at this time.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_auth_token_with_http_info(editor_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editor_id: (required)
        :param int duration_seconds: How long API token should be valid for (in seconds)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AuthTokenResult, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['editor_id', 'duration_seconds']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_auth_token" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'editor_id' is set
        if ('editor_id' not in local_var_params or
                local_var_params['editor_id'] is None):
            raise ApiValueError("Missing the required parameter `editor_id` when calling `create_auth_token`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'editor_id' in local_var_params:
            path_params['editor_id'] = local_var_params['editor_id']  # noqa: E501

        query_params = []
        if 'duration_seconds' in local_var_params:
            query_params.append(('duration_seconds', local_var_params['duration_seconds']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/auth/token/{editor_id}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AuthTokenResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_container(self, editgroup_id, entity, **kwargs):  # noqa: E501
        """create_container  # noqa: E501

        Create a single Container entity as part of an existing editgroup.  Editgroup must be mutable (aka, not accepted) and editor must have permission (aka, have created the editgroup or have `admin` role).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_container(editgroup_id, entity, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param ContainerEntity entity: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EntityEdit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_container_with_http_info(editgroup_id, entity, **kwargs)  # noqa: E501

    def create_container_with_http_info(self, editgroup_id, entity, **kwargs):  # noqa: E501
        """create_container  # noqa: E501

        Create a single Container entity as part of an existing editgroup.  Editgroup must be mutable (aka, not accepted) and editor must have permission (aka, have created the editgroup or have `admin` role).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_container_with_http_info(editgroup_id, entity, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param ContainerEntity entity: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EntityEdit, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['editgroup_id', 'entity']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_container" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'editgroup_id' is set
        if ('editgroup_id' not in local_var_params or
                local_var_params['editgroup_id'] is None):
            raise ApiValueError("Missing the required parameter `editgroup_id` when calling `create_container`")  # noqa: E501
        # verify the required parameter 'entity' is set
        if ('entity' not in local_var_params or
                local_var_params['entity'] is None):
            raise ApiValueError("Missing the required parameter `entity` when calling `create_container`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'editgroup_id' in local_var_params:
            path_params['editgroup_id'] = local_var_params['editgroup_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'entity' in local_var_params:
            body_params = local_var_params['entity']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/editgroup/{editgroup_id}/container', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EntityEdit',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_container_auto_batch(self, auto_batch, **kwargs):  # noqa: E501
        """create_container_auto_batch  # noqa: E501

        Create a set of Container entities as part of a new editgroup, and accept that editgroup in the same atomic request.  This method is mostly useful for bulk import of new entities by carefully written bots. This method is more efficient than creating an editgroup, several entities, then accepting the editgroup, both in terms of API requests required and database load. Requires `admin` role.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_container_auto_batch(auto_batch, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param ContainerAutoBatch auto_batch: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Editgroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_container_auto_batch_with_http_info(auto_batch, **kwargs)  # noqa: E501

    def create_container_auto_batch_with_http_info(self, auto_batch, **kwargs):  # noqa: E501
        """create_container_auto_batch  # noqa: E501

        Create a set of Container entities as part of a new editgroup, and accept that editgroup in the same atomic request.  This method is mostly useful for bulk import of new entities by carefully written bots. This method is more efficient than creating an editgroup, several entities, then accepting the editgroup, both in terms of API requests required and database load. Requires `admin` role.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_container_auto_batch_with_http_info(auto_batch, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param ContainerAutoBatch auto_batch: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Editgroup, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['auto_batch']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_container_auto_batch" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'auto_batch' is set
        if ('auto_batch' not in local_var_params or
                local_var_params['auto_batch'] is None):
            raise ApiValueError("Missing the required parameter `auto_batch` when calling `create_container_auto_batch`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'auto_batch' in local_var_params:
            body_params = local_var_params['auto_batch']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/editgroup/auto/container/batch', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Editgroup',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_creator(self, editgroup_id, entity, **kwargs):  # noqa: E501
        """create_creator  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_creator(editgroup_id, entity, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param CreatorEntity entity: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EntityEdit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_creator_with_http_info(editgroup_id, entity, **kwargs)  # noqa: E501

    def create_creator_with_http_info(self, editgroup_id, entity, **kwargs):  # noqa: E501
        """create_creator  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_creator_with_http_info(editgroup_id, entity, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param CreatorEntity entity: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EntityEdit, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['editgroup_id', 'entity']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_creator" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'editgroup_id' is set
        if ('editgroup_id' not in local_var_params or
                local_var_params['editgroup_id'] is None):
            raise ApiValueError("Missing the required parameter `editgroup_id` when calling `create_creator`")  # noqa: E501
        # verify the required parameter 'entity' is set
        if ('entity' not in local_var_params or
                local_var_params['entity'] is None):
            raise ApiValueError("Missing the required parameter `entity` when calling `create_creator`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'editgroup_id' in local_var_params:
            path_params['editgroup_id'] = local_var_params['editgroup_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'entity' in local_var_params:
            body_params = local_var_params['entity']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/editgroup/{editgroup_id}/creator', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EntityEdit',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_creator_auto_batch(self, auto_batch, **kwargs):  # noqa: E501
        """create_creator_auto_batch  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_creator_auto_batch(auto_batch, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreatorAutoBatch auto_batch: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Editgroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_creator_auto_batch_with_http_info(auto_batch, **kwargs)  # noqa: E501

    def create_creator_auto_batch_with_http_info(self, auto_batch, **kwargs):  # noqa: E501
        """create_creator_auto_batch  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_creator_auto_batch_with_http_info(auto_batch, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreatorAutoBatch auto_batch: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Editgroup, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['auto_batch']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_creator_auto_batch" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'auto_batch' is set
        if ('auto_batch' not in local_var_params or
                local_var_params['auto_batch'] is None):
            raise ApiValueError("Missing the required parameter `auto_batch` when calling `create_creator_auto_batch`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'auto_batch' in local_var_params:
            body_params = local_var_params['auto_batch']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/editgroup/auto/creator/batch', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Editgroup',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_editgroup(self, editgroup, **kwargs):  # noqa: E501
        """create_editgroup  # noqa: E501

        Creates a new editgroup. By default the editor making this request will be the author of the editgroup.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_editgroup(editgroup, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Editgroup editgroup: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Editgroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_editgroup_with_http_info(editgroup, **kwargs)  # noqa: E501

    def create_editgroup_with_http_info(self, editgroup, **kwargs):  # noqa: E501
        """create_editgroup  # noqa: E501

        Creates a new editgroup. By default the editor making this request will be the author of the editgroup.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_editgroup_with_http_info(editgroup, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Editgroup editgroup: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Editgroup, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['editgroup']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_editgroup" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'editgroup' is set
        if ('editgroup' not in local_var_params or
                local_var_params['editgroup'] is None):
            raise ApiValueError("Missing the required parameter `editgroup` when calling `create_editgroup`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'editgroup' in local_var_params:
            body_params = local_var_params['editgroup']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/editgroup', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Editgroup',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_editgroup_annotation(self, editgroup_id, annotation, **kwargs):  # noqa: E501
        """create_editgroup_annotation  # noqa: E501

        Submits a new annotation to the specified editgroup.  The editgroup must be open (not already accepted). The annotation will automatically have authorship of the editor making this request.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_editgroup_annotation(editgroup_id, annotation, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: base32-encoded unique identifier (required)
        :param EditgroupAnnotation annotation: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EditgroupAnnotation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_editgroup_annotation_with_http_info(editgroup_id, annotation, **kwargs)  # noqa: E501

    def create_editgroup_annotation_with_http_info(self, editgroup_id, annotation, **kwargs):  # noqa: E501
        """create_editgroup_annotation  # noqa: E501

        Submits a new annotation to the specified editgroup.  The editgroup must be open (not already accepted). The annotation will automatically have authorship of the editor making this request.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_editgroup_annotation_with_http_info(editgroup_id, annotation, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: base32-encoded unique identifier (required)
        :param EditgroupAnnotation annotation: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EditgroupAnnotation, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['editgroup_id', 'annotation']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_editgroup_annotation" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'editgroup_id' is set
        if ('editgroup_id' not in local_var_params or
                local_var_params['editgroup_id'] is None):
            raise ApiValueError("Missing the required parameter `editgroup_id` when calling `create_editgroup_annotation`")  # noqa: E501
        # verify the required parameter 'annotation' is set
        if ('annotation' not in local_var_params or
                local_var_params['annotation'] is None):
            raise ApiValueError("Missing the required parameter `annotation` when calling `create_editgroup_annotation`")  # noqa: E501

        if ('editgroup_id' in local_var_params and
                len(local_var_params['editgroup_id']) > 26):
            raise ApiValueError("Invalid value for parameter `editgroup_id` when calling `create_editgroup_annotation`, length must be less than or equal to `26`")  # noqa: E501
        if ('editgroup_id' in local_var_params and
                len(local_var_params['editgroup_id']) < 26):
            raise ApiValueError("Invalid value for parameter `editgroup_id` when calling `create_editgroup_annotation`, length must be greater than or equal to `26`")  # noqa: E501
        if 'editgroup_id' in local_var_params and not re.search(r'[a-zA-Z2-7]{26}', local_var_params['editgroup_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `editgroup_id` when calling `create_editgroup_annotation`, must conform to the pattern `/[a-zA-Z2-7]{26}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'editgroup_id' in local_var_params:
            path_params['editgroup_id'] = local_var_params['editgroup_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'annotation' in local_var_params:
            body_params = local_var_params['annotation']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/editgroup/{editgroup_id}/annotation', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EditgroupAnnotation',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_file(self, editgroup_id, entity, **kwargs):  # noqa: E501
        """create_file  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_file(editgroup_id, entity, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param FileEntity entity: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EntityEdit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_file_with_http_info(editgroup_id, entity, **kwargs)  # noqa: E501

    def create_file_with_http_info(self, editgroup_id, entity, **kwargs):  # noqa: E501
        """create_file  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_file_with_http_info(editgroup_id, entity, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param FileEntity entity: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EntityEdit, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['editgroup_id', 'entity']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'editgroup_id' is set
        if ('editgroup_id' not in local_var_params or
                local_var_params['editgroup_id'] is None):
            raise ApiValueError("Missing the required parameter `editgroup_id` when calling `create_file`")  # noqa: E501
        # verify the required parameter 'entity' is set
        if ('entity' not in local_var_params or
                local_var_params['entity'] is None):
            raise ApiValueError("Missing the required parameter `entity` when calling `create_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'editgroup_id' in local_var_params:
            path_params['editgroup_id'] = local_var_params['editgroup_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'entity' in local_var_params:
            body_params = local_var_params['entity']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/editgroup/{editgroup_id}/file', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EntityEdit',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_file_auto_batch(self, auto_batch, **kwargs):  # noqa: E501
        """create_file_auto_batch  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_file_auto_batch(auto_batch, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param FileAutoBatch auto_batch: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Editgroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_file_auto_batch_with_http_info(auto_batch, **kwargs)  # noqa: E501

    def create_file_auto_batch_with_http_info(self, auto_batch, **kwargs):  # noqa: E501
        """create_file_auto_batch  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_file_auto_batch_with_http_info(auto_batch, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param FileAutoBatch auto_batch: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Editgroup, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['auto_batch']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_file_auto_batch" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'auto_batch' is set
        if ('auto_batch' not in local_var_params or
                local_var_params['auto_batch'] is None):
            raise ApiValueError("Missing the required parameter `auto_batch` when calling `create_file_auto_batch`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'auto_batch' in local_var_params:
            body_params = local_var_params['auto_batch']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/editgroup/auto/file/batch', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Editgroup',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_fileset(self, editgroup_id, entity, **kwargs):  # noqa: E501
        """create_fileset  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_fileset(editgroup_id, entity, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param FilesetEntity entity: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EntityEdit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_fileset_with_http_info(editgroup_id, entity, **kwargs)  # noqa: E501

    def create_fileset_with_http_info(self, editgroup_id, entity, **kwargs):  # noqa: E501
        """create_fileset  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_fileset_with_http_info(editgroup_id, entity, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param FilesetEntity entity: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EntityEdit, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['editgroup_id', 'entity']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_fileset" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'editgroup_id' is set
        if ('editgroup_id' not in local_var_params or
                local_var_params['editgroup_id'] is None):
            raise ApiValueError("Missing the required parameter `editgroup_id` when calling `create_fileset`")  # noqa: E501
        # verify the required parameter 'entity' is set
        if ('entity' not in local_var_params or
                local_var_params['entity'] is None):
            raise ApiValueError("Missing the required parameter `entity` when calling `create_fileset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'editgroup_id' in local_var_params:
            path_params['editgroup_id'] = local_var_params['editgroup_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'entity' in local_var_params:
            body_params = local_var_params['entity']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/editgroup/{editgroup_id}/fileset', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EntityEdit',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_fileset_auto_batch(self, auto_batch, **kwargs):  # noqa: E501
        """create_fileset_auto_batch  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_fileset_auto_batch(auto_batch, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param FilesetAutoBatch auto_batch: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Editgroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_fileset_auto_batch_with_http_info(auto_batch, **kwargs)  # noqa: E501

    def create_fileset_auto_batch_with_http_info(self, auto_batch, **kwargs):  # noqa: E501
        """create_fileset_auto_batch  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_fileset_auto_batch_with_http_info(auto_batch, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param FilesetAutoBatch auto_batch: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Editgroup, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['auto_batch']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_fileset_auto_batch" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'auto_batch' is set
        if ('auto_batch' not in local_var_params or
                local_var_params['auto_batch'] is None):
            raise ApiValueError("Missing the required parameter `auto_batch` when calling `create_fileset_auto_batch`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'auto_batch' in local_var_params:
            body_params = local_var_params['auto_batch']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/editgroup/auto/fileset/batch', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Editgroup',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_release(self, editgroup_id, entity, **kwargs):  # noqa: E501
        """create_release  # noqa: E501

        Create a single Release entity as part of an existing editgroup. If the `work_id` field is not set, a work entity will be created automatically and this field set pointing to the new work.  Editgroup must be mutable (aka, not accepted) and editor must have permission (aka, have created the editgrou p or have `admin` role).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_release(editgroup_id, entity, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param ReleaseEntity entity: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EntityEdit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_release_with_http_info(editgroup_id, entity, **kwargs)  # noqa: E501

    def create_release_with_http_info(self, editgroup_id, entity, **kwargs):  # noqa: E501
        """create_release  # noqa: E501

        Create a single Release entity as part of an existing editgroup. If the `work_id` field is not set, a work entity will be created automatically and this field set pointing to the new work.  Editgroup must be mutable (aka, not accepted) and editor must have permission (aka, have created the editgrou p or have `admin` role).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_release_with_http_info(editgroup_id, entity, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param ReleaseEntity entity: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EntityEdit, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['editgroup_id', 'entity']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_release" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'editgroup_id' is set
        if ('editgroup_id' not in local_var_params or
                local_var_params['editgroup_id'] is None):
            raise ApiValueError("Missing the required parameter `editgroup_id` when calling `create_release`")  # noqa: E501
        # verify the required parameter 'entity' is set
        if ('entity' not in local_var_params or
                local_var_params['entity'] is None):
            raise ApiValueError("Missing the required parameter `entity` when calling `create_release`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'editgroup_id' in local_var_params:
            path_params['editgroup_id'] = local_var_params['editgroup_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'entity' in local_var_params:
            body_params = local_var_params['entity']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/editgroup/{editgroup_id}/release', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EntityEdit',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_release_auto_batch(self, auto_batch, **kwargs):  # noqa: E501
        """create_release_auto_batch  # noqa: E501

        Create a set of Release entities as part of a new editgroup, and accept that editgroup in the same atomic request.  This method is mostly useful for bulk import of new entities by carefully written bots. This method is more efficient than creating an editgroup, several entities, then accepting the editgroup, both in terms of API requests required and database load. Requires `admin` role.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_release_auto_batch(auto_batch, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param ReleaseAutoBatch auto_batch: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Editgroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_release_auto_batch_with_http_info(auto_batch, **kwargs)  # noqa: E501

    def create_release_auto_batch_with_http_info(self, auto_batch, **kwargs):  # noqa: E501
        """create_release_auto_batch  # noqa: E501

        Create a set of Release entities as part of a new editgroup, and accept that editgroup in the same atomic request.  This method is mostly useful for bulk import of new entities by carefully written bots. This method is more efficient than creating an editgroup, several entities, then accepting the editgroup, both in terms of API requests required and database load. Requires `admin` role.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_release_auto_batch_with_http_info(auto_batch, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param ReleaseAutoBatch auto_batch: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Editgroup, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['auto_batch']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_release_auto_batch" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'auto_batch' is set
        if ('auto_batch' not in local_var_params or
                local_var_params['auto_batch'] is None):
            raise ApiValueError("Missing the required parameter `auto_batch` when calling `create_release_auto_batch`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'auto_batch' in local_var_params:
            body_params = local_var_params['auto_batch']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/editgroup/auto/release/batch', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Editgroup',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_webcapture(self, editgroup_id, entity, **kwargs):  # noqa: E501
        """create_webcapture  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_webcapture(editgroup_id, entity, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param WebcaptureEntity entity: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EntityEdit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_webcapture_with_http_info(editgroup_id, entity, **kwargs)  # noqa: E501

    def create_webcapture_with_http_info(self, editgroup_id, entity, **kwargs):  # noqa: E501
        """create_webcapture  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_webcapture_with_http_info(editgroup_id, entity, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param WebcaptureEntity entity: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EntityEdit, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['editgroup_id', 'entity']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_webcapture" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'editgroup_id' is set
        if ('editgroup_id' not in local_var_params or
                local_var_params['editgroup_id'] is None):
            raise ApiValueError("Missing the required parameter `editgroup_id` when calling `create_webcapture`")  # noqa: E501
        # verify the required parameter 'entity' is set
        if ('entity' not in local_var_params or
                local_var_params['entity'] is None):
            raise ApiValueError("Missing the required parameter `entity` when calling `create_webcapture`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'editgroup_id' in local_var_params:
            path_params['editgroup_id'] = local_var_params['editgroup_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'entity' in local_var_params:
            body_params = local_var_params['entity']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/editgroup/{editgroup_id}/webcapture', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EntityEdit',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_webcapture_auto_batch(self, auto_batch, **kwargs):  # noqa: E501
        """create_webcapture_auto_batch  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_webcapture_auto_batch(auto_batch, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param WebcaptureAutoBatch auto_batch: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Editgroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_webcapture_auto_batch_with_http_info(auto_batch, **kwargs)  # noqa: E501

    def create_webcapture_auto_batch_with_http_info(self, auto_batch, **kwargs):  # noqa: E501
        """create_webcapture_auto_batch  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_webcapture_auto_batch_with_http_info(auto_batch, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param WebcaptureAutoBatch auto_batch: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Editgroup, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['auto_batch']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_webcapture_auto_batch" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'auto_batch' is set
        if ('auto_batch' not in local_var_params or
                local_var_params['auto_batch'] is None):
            raise ApiValueError("Missing the required parameter `auto_batch` when calling `create_webcapture_auto_batch`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'auto_batch' in local_var_params:
            body_params = local_var_params['auto_batch']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/editgroup/auto/webcapture/batch', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Editgroup',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_work(self, editgroup_id, entity, **kwargs):  # noqa: E501
        """create_work  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_work(editgroup_id, entity, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param WorkEntity entity: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EntityEdit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_work_with_http_info(editgroup_id, entity, **kwargs)  # noqa: E501

    def create_work_with_http_info(self, editgroup_id, entity, **kwargs):  # noqa: E501
        """create_work  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_work_with_http_info(editgroup_id, entity, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param WorkEntity entity: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EntityEdit, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['editgroup_id', 'entity']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_work" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'editgroup_id' is set
        if ('editgroup_id' not in local_var_params or
                local_var_params['editgroup_id'] is None):
            raise ApiValueError("Missing the required parameter `editgroup_id` when calling `create_work`")  # noqa: E501
        # verify the required parameter 'entity' is set
        if ('entity' not in local_var_params or
                local_var_params['entity'] is None):
            raise ApiValueError("Missing the required parameter `entity` when calling `create_work`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'editgroup_id' in local_var_params:
            path_params['editgroup_id'] = local_var_params['editgroup_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'entity' in local_var_params:
            body_params = local_var_params['entity']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/editgroup/{editgroup_id}/work', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EntityEdit',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_work_auto_batch(self, auto_batch, **kwargs):  # noqa: E501
        """create_work_auto_batch  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_work_auto_batch(auto_batch, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param WorkAutoBatch auto_batch: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Editgroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_work_auto_batch_with_http_info(auto_batch, **kwargs)  # noqa: E501

    def create_work_auto_batch_with_http_info(self, auto_batch, **kwargs):  # noqa: E501
        """create_work_auto_batch  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_work_auto_batch_with_http_info(auto_batch, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param WorkAutoBatch auto_batch: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Editgroup, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['auto_batch']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_work_auto_batch" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'auto_batch' is set
        if ('auto_batch' not in local_var_params or
                local_var_params['auto_batch'] is None):
            raise ApiValueError("Missing the required parameter `auto_batch` when calling `create_work_auto_batch`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'auto_batch' in local_var_params:
            body_params = local_var_params['auto_batch']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/editgroup/auto/work/batch', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Editgroup',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_container(self, editgroup_id, ident, **kwargs):  # noqa: E501
        """delete_container  # noqa: E501

        Creates a new \"deletion\" edit for a specific entity as part of an existing editgroup.  This is not the method to use to remove an edit from an editgroup; for that use `delete_container_edit`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_container(editgroup_id, ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param str ident: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EntityEdit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_container_with_http_info(editgroup_id, ident, **kwargs)  # noqa: E501

    def delete_container_with_http_info(self, editgroup_id, ident, **kwargs):  # noqa: E501
        """delete_container  # noqa: E501

        Creates a new \"deletion\" edit for a specific entity as part of an existing editgroup.  This is not the method to use to remove an edit from an editgroup; for that use `delete_container_edit`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_container_with_http_info(editgroup_id, ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param str ident: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EntityEdit, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['editgroup_id', 'ident']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_container" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'editgroup_id' is set
        if ('editgroup_id' not in local_var_params or
                local_var_params['editgroup_id'] is None):
            raise ApiValueError("Missing the required parameter `editgroup_id` when calling `delete_container`")  # noqa: E501
        # verify the required parameter 'ident' is set
        if ('ident' not in local_var_params or
                local_var_params['ident'] is None):
            raise ApiValueError("Missing the required parameter `ident` when calling `delete_container`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'editgroup_id' in local_var_params:
            path_params['editgroup_id'] = local_var_params['editgroup_id']  # noqa: E501
        if 'ident' in local_var_params:
            path_params['ident'] = local_var_params['ident']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/editgroup/{editgroup_id}/container/{ident}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EntityEdit',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_container_edit(self, editgroup_id, edit_id, **kwargs):  # noqa: E501
        """delete_container_edit  # noqa: E501

        Removes a single edit from the specified editgroup. The editgroup must be mutable (aka, not accepted/merged), and the editor making this request must have permission (aka, have created the editgroup or hold the `admin` role).  Not to be confused with the `delete_container` method, which *creates* a new edit in the given editgroup.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_container_edit(editgroup_id, edit_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param str edit_id: UUID (lower-case, dash-separated, hex-encoded 128-bit) (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Success
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_container_edit_with_http_info(editgroup_id, edit_id, **kwargs)  # noqa: E501

    def delete_container_edit_with_http_info(self, editgroup_id, edit_id, **kwargs):  # noqa: E501
        """delete_container_edit  # noqa: E501

        Removes a single edit from the specified editgroup. The editgroup must be mutable (aka, not accepted/merged), and the editor making this request must have permission (aka, have created the editgroup or hold the `admin` role).  Not to be confused with the `delete_container` method, which *creates* a new edit in the given editgroup.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_container_edit_with_http_info(editgroup_id, edit_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param str edit_id: UUID (lower-case, dash-separated, hex-encoded 128-bit) (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Success, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['editgroup_id', 'edit_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_container_edit" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'editgroup_id' is set
        if ('editgroup_id' not in local_var_params or
                local_var_params['editgroup_id'] is None):
            raise ApiValueError("Missing the required parameter `editgroup_id` when calling `delete_container_edit`")  # noqa: E501
        # verify the required parameter 'edit_id' is set
        if ('edit_id' not in local_var_params or
                local_var_params['edit_id'] is None):
            raise ApiValueError("Missing the required parameter `edit_id` when calling `delete_container_edit`")  # noqa: E501

        if ('edit_id' in local_var_params and
                len(local_var_params['edit_id']) > 36):
            raise ApiValueError("Invalid value for parameter `edit_id` when calling `delete_container_edit`, length must be less than or equal to `36`")  # noqa: E501
        if ('edit_id' in local_var_params and
                len(local_var_params['edit_id']) < 36):
            raise ApiValueError("Invalid value for parameter `edit_id` when calling `delete_container_edit`, length must be greater than or equal to `36`")  # noqa: E501
        if 'edit_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['edit_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `edit_id` when calling `delete_container_edit`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'editgroup_id' in local_var_params:
            path_params['editgroup_id'] = local_var_params['editgroup_id']  # noqa: E501
        if 'edit_id' in local_var_params:
            path_params['edit_id'] = local_var_params['edit_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/editgroup/{editgroup_id}/container/edit/{edit_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Success',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_creator(self, editgroup_id, ident, **kwargs):  # noqa: E501
        """delete_creator  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_creator(editgroup_id, ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param str ident: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EntityEdit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_creator_with_http_info(editgroup_id, ident, **kwargs)  # noqa: E501

    def delete_creator_with_http_info(self, editgroup_id, ident, **kwargs):  # noqa: E501
        """delete_creator  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_creator_with_http_info(editgroup_id, ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param str ident: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EntityEdit, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['editgroup_id', 'ident']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_creator" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'editgroup_id' is set
        if ('editgroup_id' not in local_var_params or
                local_var_params['editgroup_id'] is None):
            raise ApiValueError("Missing the required parameter `editgroup_id` when calling `delete_creator`")  # noqa: E501
        # verify the required parameter 'ident' is set
        if ('ident' not in local_var_params or
                local_var_params['ident'] is None):
            raise ApiValueError("Missing the required parameter `ident` when calling `delete_creator`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'editgroup_id' in local_var_params:
            path_params['editgroup_id'] = local_var_params['editgroup_id']  # noqa: E501
        if 'ident' in local_var_params:
            path_params['ident'] = local_var_params['ident']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/editgroup/{editgroup_id}/creator/{ident}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EntityEdit',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_creator_edit(self, editgroup_id, edit_id, **kwargs):  # noqa: E501
        """delete_creator_edit  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_creator_edit(editgroup_id, edit_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param str edit_id: UUID (lower-case, dash-separated, hex-encoded 128-bit) (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Success
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_creator_edit_with_http_info(editgroup_id, edit_id, **kwargs)  # noqa: E501

    def delete_creator_edit_with_http_info(self, editgroup_id, edit_id, **kwargs):  # noqa: E501
        """delete_creator_edit  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_creator_edit_with_http_info(editgroup_id, edit_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param str edit_id: UUID (lower-case, dash-separated, hex-encoded 128-bit) (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Success, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['editgroup_id', 'edit_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_creator_edit" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'editgroup_id' is set
        if ('editgroup_id' not in local_var_params or
                local_var_params['editgroup_id'] is None):
            raise ApiValueError("Missing the required parameter `editgroup_id` when calling `delete_creator_edit`")  # noqa: E501
        # verify the required parameter 'edit_id' is set
        if ('edit_id' not in local_var_params or
                local_var_params['edit_id'] is None):
            raise ApiValueError("Missing the required parameter `edit_id` when calling `delete_creator_edit`")  # noqa: E501

        if ('edit_id' in local_var_params and
                len(local_var_params['edit_id']) > 36):
            raise ApiValueError("Invalid value for parameter `edit_id` when calling `delete_creator_edit`, length must be less than or equal to `36`")  # noqa: E501
        if ('edit_id' in local_var_params and
                len(local_var_params['edit_id']) < 36):
            raise ApiValueError("Invalid value for parameter `edit_id` when calling `delete_creator_edit`, length must be greater than or equal to `36`")  # noqa: E501
        if 'edit_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['edit_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `edit_id` when calling `delete_creator_edit`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'editgroup_id' in local_var_params:
            path_params['editgroup_id'] = local_var_params['editgroup_id']  # noqa: E501
        if 'edit_id' in local_var_params:
            path_params['edit_id'] = local_var_params['edit_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/editgroup/{editgroup_id}/creator/edit/{edit_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Success',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_file(self, editgroup_id, ident, **kwargs):  # noqa: E501
        """delete_file  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_file(editgroup_id, ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param str ident: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EntityEdit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_file_with_http_info(editgroup_id, ident, **kwargs)  # noqa: E501

    def delete_file_with_http_info(self, editgroup_id, ident, **kwargs):  # noqa: E501
        """delete_file  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_file_with_http_info(editgroup_id, ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param str ident: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EntityEdit, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['editgroup_id', 'ident']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'editgroup_id' is set
        if ('editgroup_id' not in local_var_params or
                local_var_params['editgroup_id'] is None):
            raise ApiValueError("Missing the required parameter `editgroup_id` when calling `delete_file`")  # noqa: E501
        # verify the required parameter 'ident' is set
        if ('ident' not in local_var_params or
                local_var_params['ident'] is None):
            raise ApiValueError("Missing the required parameter `ident` when calling `delete_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'editgroup_id' in local_var_params:
            path_params['editgroup_id'] = local_var_params['editgroup_id']  # noqa: E501
        if 'ident' in local_var_params:
            path_params['ident'] = local_var_params['ident']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/editgroup/{editgroup_id}/file/{ident}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EntityEdit',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_file_edit(self, editgroup_id, edit_id, **kwargs):  # noqa: E501
        """delete_file_edit  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_file_edit(editgroup_id, edit_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param str edit_id: UUID (lower-case, dash-separated, hex-encoded 128-bit) (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Success
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_file_edit_with_http_info(editgroup_id, edit_id, **kwargs)  # noqa: E501

    def delete_file_edit_with_http_info(self, editgroup_id, edit_id, **kwargs):  # noqa: E501
        """delete_file_edit  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_file_edit_with_http_info(editgroup_id, edit_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param str edit_id: UUID (lower-case, dash-separated, hex-encoded 128-bit) (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Success, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['editgroup_id', 'edit_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_file_edit" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'editgroup_id' is set
        if ('editgroup_id' not in local_var_params or
                local_var_params['editgroup_id'] is None):
            raise ApiValueError("Missing the required parameter `editgroup_id` when calling `delete_file_edit`")  # noqa: E501
        # verify the required parameter 'edit_id' is set
        if ('edit_id' not in local_var_params or
                local_var_params['edit_id'] is None):
            raise ApiValueError("Missing the required parameter `edit_id` when calling `delete_file_edit`")  # noqa: E501

        if ('edit_id' in local_var_params and
                len(local_var_params['edit_id']) > 36):
            raise ApiValueError("Invalid value for parameter `edit_id` when calling `delete_file_edit`, length must be less than or equal to `36`")  # noqa: E501
        if ('edit_id' in local_var_params and
                len(local_var_params['edit_id']) < 36):
            raise ApiValueError("Invalid value for parameter `edit_id` when calling `delete_file_edit`, length must be greater than or equal to `36`")  # noqa: E501
        if 'edit_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['edit_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `edit_id` when calling `delete_file_edit`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'editgroup_id' in local_var_params:
            path_params['editgroup_id'] = local_var_params['editgroup_id']  # noqa: E501
        if 'edit_id' in local_var_params:
            path_params['edit_id'] = local_var_params['edit_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/editgroup/{editgroup_id}/file/edit/{edit_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Success',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_fileset(self, editgroup_id, ident, **kwargs):  # noqa: E501
        """delete_fileset  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_fileset(editgroup_id, ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param str ident: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EntityEdit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_fileset_with_http_info(editgroup_id, ident, **kwargs)  # noqa: E501

    def delete_fileset_with_http_info(self, editgroup_id, ident, **kwargs):  # noqa: E501
        """delete_fileset  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_fileset_with_http_info(editgroup_id, ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param str ident: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EntityEdit, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['editgroup_id', 'ident']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_fileset" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'editgroup_id' is set
        if ('editgroup_id' not in local_var_params or
                local_var_params['editgroup_id'] is None):
            raise ApiValueError("Missing the required parameter `editgroup_id` when calling `delete_fileset`")  # noqa: E501
        # verify the required parameter 'ident' is set
        if ('ident' not in local_var_params or
                local_var_params['ident'] is None):
            raise ApiValueError("Missing the required parameter `ident` when calling `delete_fileset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'editgroup_id' in local_var_params:
            path_params['editgroup_id'] = local_var_params['editgroup_id']  # noqa: E501
        if 'ident' in local_var_params:
            path_params['ident'] = local_var_params['ident']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/editgroup/{editgroup_id}/fileset/{ident}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EntityEdit',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_fileset_edit(self, editgroup_id, edit_id, **kwargs):  # noqa: E501
        """delete_fileset_edit  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_fileset_edit(editgroup_id, edit_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param str edit_id: UUID (lower-case, dash-separated, hex-encoded 128-bit) (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Success
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_fileset_edit_with_http_info(editgroup_id, edit_id, **kwargs)  # noqa: E501

    def delete_fileset_edit_with_http_info(self, editgroup_id, edit_id, **kwargs):  # noqa: E501
        """delete_fileset_edit  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_fileset_edit_with_http_info(editgroup_id, edit_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param str edit_id: UUID (lower-case, dash-separated, hex-encoded 128-bit) (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Success, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['editgroup_id', 'edit_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_fileset_edit" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'editgroup_id' is set
        if ('editgroup_id' not in local_var_params or
                local_var_params['editgroup_id'] is None):
            raise ApiValueError("Missing the required parameter `editgroup_id` when calling `delete_fileset_edit`")  # noqa: E501
        # verify the required parameter 'edit_id' is set
        if ('edit_id' not in local_var_params or
                local_var_params['edit_id'] is None):
            raise ApiValueError("Missing the required parameter `edit_id` when calling `delete_fileset_edit`")  # noqa: E501

        if ('edit_id' in local_var_params and
                len(local_var_params['edit_id']) > 36):
            raise ApiValueError("Invalid value for parameter `edit_id` when calling `delete_fileset_edit`, length must be less than or equal to `36`")  # noqa: E501
        if ('edit_id' in local_var_params and
                len(local_var_params['edit_id']) < 36):
            raise ApiValueError("Invalid value for parameter `edit_id` when calling `delete_fileset_edit`, length must be greater than or equal to `36`")  # noqa: E501
        if 'edit_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['edit_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `edit_id` when calling `delete_fileset_edit`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'editgroup_id' in local_var_params:
            path_params['editgroup_id'] = local_var_params['editgroup_id']  # noqa: E501
        if 'edit_id' in local_var_params:
            path_params['edit_id'] = local_var_params['edit_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/editgroup/{editgroup_id}/fileset/edit/{edit_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Success',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_release(self, editgroup_id, ident, **kwargs):  # noqa: E501
        """delete_release  # noqa: E501

        Creates a new \"deletion\" edit for a specific entity as part of an existing editgroup.  This is not the method to use to remove an edit from an editgroup; for that use `delete_release_edit`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_release(editgroup_id, ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param str ident: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EntityEdit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_release_with_http_info(editgroup_id, ident, **kwargs)  # noqa: E501

    def delete_release_with_http_info(self, editgroup_id, ident, **kwargs):  # noqa: E501
        """delete_release  # noqa: E501

        Creates a new \"deletion\" edit for a specific entity as part of an existing editgroup.  This is not the method to use to remove an edit from an editgroup; for that use `delete_release_edit`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_release_with_http_info(editgroup_id, ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param str ident: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EntityEdit, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['editgroup_id', 'ident']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_release" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'editgroup_id' is set
        if ('editgroup_id' not in local_var_params or
                local_var_params['editgroup_id'] is None):
            raise ApiValueError("Missing the required parameter `editgroup_id` when calling `delete_release`")  # noqa: E501
        # verify the required parameter 'ident' is set
        if ('ident' not in local_var_params or
                local_var_params['ident'] is None):
            raise ApiValueError("Missing the required parameter `ident` when calling `delete_release`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'editgroup_id' in local_var_params:
            path_params['editgroup_id'] = local_var_params['editgroup_id']  # noqa: E501
        if 'ident' in local_var_params:
            path_params['ident'] = local_var_params['ident']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/editgroup/{editgroup_id}/release/{ident}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EntityEdit',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_release_edit(self, editgroup_id, edit_id, **kwargs):  # noqa: E501
        """delete_release_edit  # noqa: E501

        Removes a single edit from the specified editgroup. The editgroup must be mutable (aka, not accepted/merged), and the editor making this request must have permission (aka, have created the editgroup or hold the `admin` role).  Not to be confused with the `delete_container` method, which *creates* a new edit in the given editgroup.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_release_edit(editgroup_id, edit_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param str edit_id: UUID (lower-case, dash-separated, hex-encoded 128-bit) (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Success
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_release_edit_with_http_info(editgroup_id, edit_id, **kwargs)  # noqa: E501

    def delete_release_edit_with_http_info(self, editgroup_id, edit_id, **kwargs):  # noqa: E501
        """delete_release_edit  # noqa: E501

        Removes a single edit from the specified editgroup. The editgroup must be mutable (aka, not accepted/merged), and the editor making this request must have permission (aka, have created the editgroup or hold the `admin` role).  Not to be confused with the `delete_container` method, which *creates* a new edit in the given editgroup.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_release_edit_with_http_info(editgroup_id, edit_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param str edit_id: UUID (lower-case, dash-separated, hex-encoded 128-bit) (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Success, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['editgroup_id', 'edit_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_release_edit" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'editgroup_id' is set
        if ('editgroup_id' not in local_var_params or
                local_var_params['editgroup_id'] is None):
            raise ApiValueError("Missing the required parameter `editgroup_id` when calling `delete_release_edit`")  # noqa: E501
        # verify the required parameter 'edit_id' is set
        if ('edit_id' not in local_var_params or
                local_var_params['edit_id'] is None):
            raise ApiValueError("Missing the required parameter `edit_id` when calling `delete_release_edit`")  # noqa: E501

        if ('edit_id' in local_var_params and
                len(local_var_params['edit_id']) > 36):
            raise ApiValueError("Invalid value for parameter `edit_id` when calling `delete_release_edit`, length must be less than or equal to `36`")  # noqa: E501
        if ('edit_id' in local_var_params and
                len(local_var_params['edit_id']) < 36):
            raise ApiValueError("Invalid value for parameter `edit_id` when calling `delete_release_edit`, length must be greater than or equal to `36`")  # noqa: E501
        if 'edit_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['edit_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `edit_id` when calling `delete_release_edit`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'editgroup_id' in local_var_params:
            path_params['editgroup_id'] = local_var_params['editgroup_id']  # noqa: E501
        if 'edit_id' in local_var_params:
            path_params['edit_id'] = local_var_params['edit_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/editgroup/{editgroup_id}/release/edit/{edit_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Success',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_webcapture(self, editgroup_id, ident, **kwargs):  # noqa: E501
        """delete_webcapture  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_webcapture(editgroup_id, ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param str ident: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EntityEdit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_webcapture_with_http_info(editgroup_id, ident, **kwargs)  # noqa: E501

    def delete_webcapture_with_http_info(self, editgroup_id, ident, **kwargs):  # noqa: E501
        """delete_webcapture  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_webcapture_with_http_info(editgroup_id, ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param str ident: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EntityEdit, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['editgroup_id', 'ident']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_webcapture" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'editgroup_id' is set
        if ('editgroup_id' not in local_var_params or
                local_var_params['editgroup_id'] is None):
            raise ApiValueError("Missing the required parameter `editgroup_id` when calling `delete_webcapture`")  # noqa: E501
        # verify the required parameter 'ident' is set
        if ('ident' not in local_var_params or
                local_var_params['ident'] is None):
            raise ApiValueError("Missing the required parameter `ident` when calling `delete_webcapture`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'editgroup_id' in local_var_params:
            path_params['editgroup_id'] = local_var_params['editgroup_id']  # noqa: E501
        if 'ident' in local_var_params:
            path_params['ident'] = local_var_params['ident']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/editgroup/{editgroup_id}/webcapture/{ident}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EntityEdit',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_webcapture_edit(self, editgroup_id, edit_id, **kwargs):  # noqa: E501
        """delete_webcapture_edit  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_webcapture_edit(editgroup_id, edit_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param str edit_id: UUID (lower-case, dash-separated, hex-encoded 128-bit) (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Success
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_webcapture_edit_with_http_info(editgroup_id, edit_id, **kwargs)  # noqa: E501

    def delete_webcapture_edit_with_http_info(self, editgroup_id, edit_id, **kwargs):  # noqa: E501
        """delete_webcapture_edit  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_webcapture_edit_with_http_info(editgroup_id, edit_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param str edit_id: UUID (lower-case, dash-separated, hex-encoded 128-bit) (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Success, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['editgroup_id', 'edit_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_webcapture_edit" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'editgroup_id' is set
        if ('editgroup_id' not in local_var_params or
                local_var_params['editgroup_id'] is None):
            raise ApiValueError("Missing the required parameter `editgroup_id` when calling `delete_webcapture_edit`")  # noqa: E501
        # verify the required parameter 'edit_id' is set
        if ('edit_id' not in local_var_params or
                local_var_params['edit_id'] is None):
            raise ApiValueError("Missing the required parameter `edit_id` when calling `delete_webcapture_edit`")  # noqa: E501

        if ('edit_id' in local_var_params and
                len(local_var_params['edit_id']) > 36):
            raise ApiValueError("Invalid value for parameter `edit_id` when calling `delete_webcapture_edit`, length must be less than or equal to `36`")  # noqa: E501
        if ('edit_id' in local_var_params and
                len(local_var_params['edit_id']) < 36):
            raise ApiValueError("Invalid value for parameter `edit_id` when calling `delete_webcapture_edit`, length must be greater than or equal to `36`")  # noqa: E501
        if 'edit_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['edit_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `edit_id` when calling `delete_webcapture_edit`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'editgroup_id' in local_var_params:
            path_params['editgroup_id'] = local_var_params['editgroup_id']  # noqa: E501
        if 'edit_id' in local_var_params:
            path_params['edit_id'] = local_var_params['edit_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/editgroup/{editgroup_id}/webcapture/edit/{edit_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Success',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_work(self, editgroup_id, ident, **kwargs):  # noqa: E501
        """delete_work  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_work(editgroup_id, ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param str ident: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EntityEdit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_work_with_http_info(editgroup_id, ident, **kwargs)  # noqa: E501

    def delete_work_with_http_info(self, editgroup_id, ident, **kwargs):  # noqa: E501
        """delete_work  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_work_with_http_info(editgroup_id, ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param str ident: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EntityEdit, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['editgroup_id', 'ident']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_work" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'editgroup_id' is set
        if ('editgroup_id' not in local_var_params or
                local_var_params['editgroup_id'] is None):
            raise ApiValueError("Missing the required parameter `editgroup_id` when calling `delete_work`")  # noqa: E501
        # verify the required parameter 'ident' is set
        if ('ident' not in local_var_params or
                local_var_params['ident'] is None):
            raise ApiValueError("Missing the required parameter `ident` when calling `delete_work`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'editgroup_id' in local_var_params:
            path_params['editgroup_id'] = local_var_params['editgroup_id']  # noqa: E501
        if 'ident' in local_var_params:
            path_params['ident'] = local_var_params['ident']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/editgroup/{editgroup_id}/work/{ident}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EntityEdit',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_work_edit(self, editgroup_id, edit_id, **kwargs):  # noqa: E501
        """delete_work_edit  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_work_edit(editgroup_id, edit_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param str edit_id: UUID (lower-case, dash-separated, hex-encoded 128-bit) (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Success
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_work_edit_with_http_info(editgroup_id, edit_id, **kwargs)  # noqa: E501

    def delete_work_edit_with_http_info(self, editgroup_id, edit_id, **kwargs):  # noqa: E501
        """delete_work_edit  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_work_edit_with_http_info(editgroup_id, edit_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param str edit_id: UUID (lower-case, dash-separated, hex-encoded 128-bit) (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Success, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['editgroup_id', 'edit_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_work_edit" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'editgroup_id' is set
        if ('editgroup_id' not in local_var_params or
                local_var_params['editgroup_id'] is None):
            raise ApiValueError("Missing the required parameter `editgroup_id` when calling `delete_work_edit`")  # noqa: E501
        # verify the required parameter 'edit_id' is set
        if ('edit_id' not in local_var_params or
                local_var_params['edit_id'] is None):
            raise ApiValueError("Missing the required parameter `edit_id` when calling `delete_work_edit`")  # noqa: E501

        if ('edit_id' in local_var_params and
                len(local_var_params['edit_id']) > 36):
            raise ApiValueError("Invalid value for parameter `edit_id` when calling `delete_work_edit`, length must be less than or equal to `36`")  # noqa: E501
        if ('edit_id' in local_var_params and
                len(local_var_params['edit_id']) < 36):
            raise ApiValueError("Invalid value for parameter `edit_id` when calling `delete_work_edit`, length must be greater than or equal to `36`")  # noqa: E501
        if 'edit_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['edit_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `edit_id` when calling `delete_work_edit`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'editgroup_id' in local_var_params:
            path_params['editgroup_id'] = local_var_params['editgroup_id']  # noqa: E501
        if 'edit_id' in local_var_params:
            path_params['edit_id'] = local_var_params['edit_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/editgroup/{editgroup_id}/work/edit/{edit_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Success',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_changelog(self, **kwargs):  # noqa: E501
        """get_changelog  # noqa: E501

        Returns a list of the most recent changelog entries accepted (merged) into the catalog.  List is sorted by changelog index in descending order. Note that the accepted timestamp roughly corresponds to order, but not strictly; there exist out-of-order timestamps on the order of several seconds.  As a known database issue, it is technically possible for there to be a gap in changelog index numbers (aka, a missing changelog entry). There are no currently known gaps and this is considered a bug that will be addressed.  There are millions of entries; to paginate through all of them, use this method to discover the highest existing entry number, then request the entries using `get_changelog_entry` one at a time.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_changelog(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int limit: Maximum count of changelog entries to return in response
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[ChangelogEntry]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_changelog_with_http_info(**kwargs)  # noqa: E501

    def get_changelog_with_http_info(self, **kwargs):  # noqa: E501
        """get_changelog  # noqa: E501

        Returns a list of the most recent changelog entries accepted (merged) into the catalog.  List is sorted by changelog index in descending order. Note that the accepted timestamp roughly corresponds to order, but not strictly; there exist out-of-order timestamps on the order of several seconds.  As a known database issue, it is technically possible for there to be a gap in changelog index numbers (aka, a missing changelog entry). There are no currently known gaps and this is considered a bug that will be addressed.  There are millions of entries; to paginate through all of them, use this method to discover the highest existing entry number, then request the entries using `get_changelog_entry` one at a time.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_changelog_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int limit: Maximum count of changelog entries to return in response
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[ChangelogEntry], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_changelog" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in local_var_params:
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/changelog', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ChangelogEntry]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_changelog_entry(self, index, **kwargs):  # noqa: E501
        """get_changelog_entry  # noqa: E501

        Returns a single changelog entry.  As a known database issue, it is technically possible for there to be a gap in changelog index numbers (aka, a missing changelog entry). There are no currently known gaps and this is considered a bug that will be addressed.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_changelog_entry(index, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int index: Changelog index of entry to return (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ChangelogEntry
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_changelog_entry_with_http_info(index, **kwargs)  # noqa: E501

    def get_changelog_entry_with_http_info(self, index, **kwargs):  # noqa: E501
        """get_changelog_entry  # noqa: E501

        Returns a single changelog entry.  As a known database issue, it is technically possible for there to be a gap in changelog index numbers (aka, a missing changelog entry). There are no currently known gaps and this is considered a bug that will be addressed.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_changelog_entry_with_http_info(index, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int index: Changelog index of entry to return (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ChangelogEntry, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['index']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_changelog_entry" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'index' is set
        if ('index' not in local_var_params or
                local_var_params['index'] is None):
            raise ApiValueError("Missing the required parameter `index` when calling `get_changelog_entry`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'index' in local_var_params:
            path_params['index'] = local_var_params['index']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/changelog/{index}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ChangelogEntry',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_container(self, ident, **kwargs):  # noqa: E501
        """get_container  # noqa: E501

        Fetches a single container entity from the catalog.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_container(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param str expand: List of sub-entities to expand in response. For containers, none accepted (yet).
        :param str hide: List of entity fields to elide in response. For containers, none accepted (yet).
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ContainerEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_container_with_http_info(ident, **kwargs)  # noqa: E501

    def get_container_with_http_info(self, ident, **kwargs):  # noqa: E501
        """get_container  # noqa: E501

        Fetches a single container entity from the catalog.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_container_with_http_info(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param str expand: List of sub-entities to expand in response. For containers, none accepted (yet).
        :param str hide: List of entity fields to elide in response. For containers, none accepted (yet).
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ContainerEntity, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['ident', 'expand', 'hide']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_container" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ident' is set
        if ('ident' not in local_var_params or
                local_var_params['ident'] is None):
            raise ApiValueError("Missing the required parameter `ident` when calling `get_container`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ident' in local_var_params:
            path_params['ident'] = local_var_params['ident']  # noqa: E501

        query_params = []
        if 'expand' in local_var_params:
            query_params.append(('expand', local_var_params['expand']))  # noqa: E501
        if 'hide' in local_var_params:
            query_params.append(('hide', local_var_params['hide']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/container/{ident}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ContainerEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_container_edit(self, edit_id, **kwargs):  # noqa: E501
        """get_container_edit  # noqa: E501

        Returns the entity edit object with the given identifier. This method is expected to be used rarely.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_container_edit(edit_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str edit_id: UUID (lower-case, dash-separated, hex-encoded 128-bit) (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EntityEdit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_container_edit_with_http_info(edit_id, **kwargs)  # noqa: E501

    def get_container_edit_with_http_info(self, edit_id, **kwargs):  # noqa: E501
        """get_container_edit  # noqa: E501

        Returns the entity edit object with the given identifier. This method is expected to be used rarely.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_container_edit_with_http_info(edit_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str edit_id: UUID (lower-case, dash-separated, hex-encoded 128-bit) (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EntityEdit, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['edit_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_container_edit" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edit_id' is set
        if ('edit_id' not in local_var_params or
                local_var_params['edit_id'] is None):
            raise ApiValueError("Missing the required parameter `edit_id` when calling `get_container_edit`")  # noqa: E501

        if ('edit_id' in local_var_params and
                len(local_var_params['edit_id']) > 36):
            raise ApiValueError("Invalid value for parameter `edit_id` when calling `get_container_edit`, length must be less than or equal to `36`")  # noqa: E501
        if ('edit_id' in local_var_params and
                len(local_var_params['edit_id']) < 36):
            raise ApiValueError("Invalid value for parameter `edit_id` when calling `get_container_edit`, length must be greater than or equal to `36`")  # noqa: E501
        if 'edit_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['edit_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `edit_id` when calling `get_container_edit`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'edit_id' in local_var_params:
            path_params['edit_id'] = local_var_params['edit_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/container/edit/{edit_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EntityEdit',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_container_history(self, ident, **kwargs):  # noqa: E501
        """get_container_history  # noqa: E501

        Fetches the history of accepted edits (changelog entries) for a specific entity fatcat identifier.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_container_history(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param int limit: Maximum number of changelog entries to return
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[EntityHistoryEntry]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_container_history_with_http_info(ident, **kwargs)  # noqa: E501

    def get_container_history_with_http_info(self, ident, **kwargs):  # noqa: E501
        """get_container_history  # noqa: E501

        Fetches the history of accepted edits (changelog entries) for a specific entity fatcat identifier.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_container_history_with_http_info(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param int limit: Maximum number of changelog entries to return
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[EntityHistoryEntry], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['ident', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_container_history" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ident' is set
        if ('ident' not in local_var_params or
                local_var_params['ident'] is None):
            raise ApiValueError("Missing the required parameter `ident` when calling `get_container_history`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ident' in local_var_params:
            path_params['ident'] = local_var_params['ident']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params:
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/container/{ident}/history', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[EntityHistoryEntry]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_container_redirects(self, ident, **kwargs):  # noqa: E501
        """get_container_redirects  # noqa: E501

        Returns the set of entity identifiers which currently redirect to this identifier.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_container_redirects(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_container_redirects_with_http_info(ident, **kwargs)  # noqa: E501

    def get_container_redirects_with_http_info(self, ident, **kwargs):  # noqa: E501
        """get_container_redirects  # noqa: E501

        Returns the set of entity identifiers which currently redirect to this identifier.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_container_redirects_with_http_info(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[str], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['ident']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_container_redirects" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ident' is set
        if ('ident' not in local_var_params or
                local_var_params['ident'] is None):
            raise ApiValueError("Missing the required parameter `ident` when calling `get_container_redirects`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ident' in local_var_params:
            path_params['ident'] = local_var_params['ident']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/container/{ident}/redirects', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[str]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_container_revision(self, rev_id, **kwargs):  # noqa: E501
        """get_container_revision  # noqa: E501

        Fetches a specific entity revision. Note that the returned revision will not be associated with any particular fatcat identifier (even if one or more identifiers do currently point to this revision). The revision may even be part of an un-merged editgroup.  Revisions are immutable and can not be deleted or updated.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_container_revision(rev_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str rev_id: UUID (lower-case, dash-separated, hex-encoded 128-bit) (required)
        :param str expand: List of sub-entities to expand in response. See `get_container`.
        :param str hide: List of entity fields to elide in response. See `get_container`.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ContainerEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_container_revision_with_http_info(rev_id, **kwargs)  # noqa: E501

    def get_container_revision_with_http_info(self, rev_id, **kwargs):  # noqa: E501
        """get_container_revision  # noqa: E501

        Fetches a specific entity revision. Note that the returned revision will not be associated with any particular fatcat identifier (even if one or more identifiers do currently point to this revision). The revision may even be part of an un-merged editgroup.  Revisions are immutable and can not be deleted or updated.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_container_revision_with_http_info(rev_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str rev_id: UUID (lower-case, dash-separated, hex-encoded 128-bit) (required)
        :param str expand: List of sub-entities to expand in response. See `get_container`.
        :param str hide: List of entity fields to elide in response. See `get_container`.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ContainerEntity, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['rev_id', 'expand', 'hide']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_container_revision" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'rev_id' is set
        if ('rev_id' not in local_var_params or
                local_var_params['rev_id'] is None):
            raise ApiValueError("Missing the required parameter `rev_id` when calling `get_container_revision`")  # noqa: E501

        if ('rev_id' in local_var_params and
                len(local_var_params['rev_id']) > 36):
            raise ApiValueError("Invalid value for parameter `rev_id` when calling `get_container_revision`, length must be less than or equal to `36`")  # noqa: E501
        if ('rev_id' in local_var_params and
                len(local_var_params['rev_id']) < 36):
            raise ApiValueError("Invalid value for parameter `rev_id` when calling `get_container_revision`, length must be greater than or equal to `36`")  # noqa: E501
        if 'rev_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['rev_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `rev_id` when calling `get_container_revision`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'rev_id' in local_var_params:
            path_params['rev_id'] = local_var_params['rev_id']  # noqa: E501

        query_params = []
        if 'expand' in local_var_params:
            query_params.append(('expand', local_var_params['expand']))  # noqa: E501
        if 'hide' in local_var_params:
            query_params.append(('hide', local_var_params['hide']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/container/rev/{rev_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ContainerEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_creator(self, ident, **kwargs):  # noqa: E501
        """get_creator  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_creator(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param str expand: List of sub-entities to expand in response. For creators, none accepted (yet).
        :param str hide: List of entity fields to elide in response. For creators, none accepted (yet).
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CreatorEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_creator_with_http_info(ident, **kwargs)  # noqa: E501

    def get_creator_with_http_info(self, ident, **kwargs):  # noqa: E501
        """get_creator  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_creator_with_http_info(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param str expand: List of sub-entities to expand in response. For creators, none accepted (yet).
        :param str hide: List of entity fields to elide in response. For creators, none accepted (yet).
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CreatorEntity, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['ident', 'expand', 'hide']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_creator" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ident' is set
        if ('ident' not in local_var_params or
                local_var_params['ident'] is None):
            raise ApiValueError("Missing the required parameter `ident` when calling `get_creator`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ident' in local_var_params:
            path_params['ident'] = local_var_params['ident']  # noqa: E501

        query_params = []
        if 'expand' in local_var_params:
            query_params.append(('expand', local_var_params['expand']))  # noqa: E501
        if 'hide' in local_var_params:
            query_params.append(('hide', local_var_params['hide']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/creator/{ident}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreatorEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_creator_edit(self, edit_id, **kwargs):  # noqa: E501
        """get_creator_edit  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_creator_edit(edit_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str edit_id: UUID (lower-case, dash-separated, hex-encoded 128-bit) (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EntityEdit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_creator_edit_with_http_info(edit_id, **kwargs)  # noqa: E501

    def get_creator_edit_with_http_info(self, edit_id, **kwargs):  # noqa: E501
        """get_creator_edit  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_creator_edit_with_http_info(edit_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str edit_id: UUID (lower-case, dash-separated, hex-encoded 128-bit) (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EntityEdit, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['edit_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_creator_edit" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edit_id' is set
        if ('edit_id' not in local_var_params or
                local_var_params['edit_id'] is None):
            raise ApiValueError("Missing the required parameter `edit_id` when calling `get_creator_edit`")  # noqa: E501

        if ('edit_id' in local_var_params and
                len(local_var_params['edit_id']) > 36):
            raise ApiValueError("Invalid value for parameter `edit_id` when calling `get_creator_edit`, length must be less than or equal to `36`")  # noqa: E501
        if ('edit_id' in local_var_params and
                len(local_var_params['edit_id']) < 36):
            raise ApiValueError("Invalid value for parameter `edit_id` when calling `get_creator_edit`, length must be greater than or equal to `36`")  # noqa: E501
        if 'edit_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['edit_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `edit_id` when calling `get_creator_edit`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'edit_id' in local_var_params:
            path_params['edit_id'] = local_var_params['edit_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/creator/edit/{edit_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EntityEdit',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_creator_history(self, ident, **kwargs):  # noqa: E501
        """get_creator_history  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_creator_history(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param int limit:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[EntityHistoryEntry]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_creator_history_with_http_info(ident, **kwargs)  # noqa: E501

    def get_creator_history_with_http_info(self, ident, **kwargs):  # noqa: E501
        """get_creator_history  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_creator_history_with_http_info(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param int limit:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[EntityHistoryEntry], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['ident', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_creator_history" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ident' is set
        if ('ident' not in local_var_params or
                local_var_params['ident'] is None):
            raise ApiValueError("Missing the required parameter `ident` when calling `get_creator_history`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ident' in local_var_params:
            path_params['ident'] = local_var_params['ident']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params:
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/creator/{ident}/history', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[EntityHistoryEntry]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_creator_redirects(self, ident, **kwargs):  # noqa: E501
        """get_creator_redirects  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_creator_redirects(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_creator_redirects_with_http_info(ident, **kwargs)  # noqa: E501

    def get_creator_redirects_with_http_info(self, ident, **kwargs):  # noqa: E501
        """get_creator_redirects  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_creator_redirects_with_http_info(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[str], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['ident']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_creator_redirects" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ident' is set
        if ('ident' not in local_var_params or
                local_var_params['ident'] is None):
            raise ApiValueError("Missing the required parameter `ident` when calling `get_creator_redirects`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ident' in local_var_params:
            path_params['ident'] = local_var_params['ident']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/creator/{ident}/redirects', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[str]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_creator_releases(self, ident, **kwargs):  # noqa: E501
        """get_creator_releases  # noqa: E501

        Returns the set of Release entities having a `contrib` entry pointing to the creator entity.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_creator_releases(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param str hide: List of entity fields to elide in response. See `get_release`.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[ReleaseEntity]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_creator_releases_with_http_info(ident, **kwargs)  # noqa: E501

    def get_creator_releases_with_http_info(self, ident, **kwargs):  # noqa: E501
        """get_creator_releases  # noqa: E501

        Returns the set of Release entities having a `contrib` entry pointing to the creator entity.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_creator_releases_with_http_info(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param str hide: List of entity fields to elide in response. See `get_release`.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[ReleaseEntity], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['ident', 'hide']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_creator_releases" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ident' is set
        if ('ident' not in local_var_params or
                local_var_params['ident'] is None):
            raise ApiValueError("Missing the required parameter `ident` when calling `get_creator_releases`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ident' in local_var_params:
            path_params['ident'] = local_var_params['ident']  # noqa: E501

        query_params = []
        if 'hide' in local_var_params:
            query_params.append(('hide', local_var_params['hide']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/creator/{ident}/releases', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ReleaseEntity]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_creator_revision(self, rev_id, **kwargs):  # noqa: E501
        """get_creator_revision  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_creator_revision(rev_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str rev_id: UUID (lower-case, dash-separated, hex-encoded 128-bit) (required)
        :param str expand: List of sub-entities to expand in response. See `get_creator`, though note that identifier-based expansions (like `releases`) will always be empty for revisions. 
        :param str hide: List of entity fields to elide in response. See `get_creator`.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CreatorEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_creator_revision_with_http_info(rev_id, **kwargs)  # noqa: E501

    def get_creator_revision_with_http_info(self, rev_id, **kwargs):  # noqa: E501
        """get_creator_revision  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_creator_revision_with_http_info(rev_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str rev_id: UUID (lower-case, dash-separated, hex-encoded 128-bit) (required)
        :param str expand: List of sub-entities to expand in response. See `get_creator`, though note that identifier-based expansions (like `releases`) will always be empty for revisions. 
        :param str hide: List of entity fields to elide in response. See `get_creator`.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CreatorEntity, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['rev_id', 'expand', 'hide']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_creator_revision" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'rev_id' is set
        if ('rev_id' not in local_var_params or
                local_var_params['rev_id'] is None):
            raise ApiValueError("Missing the required parameter `rev_id` when calling `get_creator_revision`")  # noqa: E501

        if ('rev_id' in local_var_params and
                len(local_var_params['rev_id']) > 36):
            raise ApiValueError("Invalid value for parameter `rev_id` when calling `get_creator_revision`, length must be less than or equal to `36`")  # noqa: E501
        if ('rev_id' in local_var_params and
                len(local_var_params['rev_id']) < 36):
            raise ApiValueError("Invalid value for parameter `rev_id` when calling `get_creator_revision`, length must be greater than or equal to `36`")  # noqa: E501
        if 'rev_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['rev_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `rev_id` when calling `get_creator_revision`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'rev_id' in local_var_params:
            path_params['rev_id'] = local_var_params['rev_id']  # noqa: E501

        query_params = []
        if 'expand' in local_var_params:
            query_params.append(('expand', local_var_params['expand']))  # noqa: E501
        if 'hide' in local_var_params:
            query_params.append(('hide', local_var_params['hide']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/creator/rev/{rev_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreatorEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_editgroup(self, editgroup_id, **kwargs):  # noqa: E501
        """get_editgroup  # noqa: E501

        Returns a single editgroup object.  Unlike some similar methods, this method will return a full/expanded editgroup object, which includes edit lists of each entity type (though will not include the complete entity objects).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_editgroup(editgroup_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: base32-encoded unique identifier (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Editgroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_editgroup_with_http_info(editgroup_id, **kwargs)  # noqa: E501

    def get_editgroup_with_http_info(self, editgroup_id, **kwargs):  # noqa: E501
        """get_editgroup  # noqa: E501

        Returns a single editgroup object.  Unlike some similar methods, this method will return a full/expanded editgroup object, which includes edit lists of each entity type (though will not include the complete entity objects).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_editgroup_with_http_info(editgroup_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: base32-encoded unique identifier (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Editgroup, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['editgroup_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_editgroup" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'editgroup_id' is set
        if ('editgroup_id' not in local_var_params or
                local_var_params['editgroup_id'] is None):
            raise ApiValueError("Missing the required parameter `editgroup_id` when calling `get_editgroup`")  # noqa: E501

        if ('editgroup_id' in local_var_params and
                len(local_var_params['editgroup_id']) > 26):
            raise ApiValueError("Invalid value for parameter `editgroup_id` when calling `get_editgroup`, length must be less than or equal to `26`")  # noqa: E501
        if ('editgroup_id' in local_var_params and
                len(local_var_params['editgroup_id']) < 26):
            raise ApiValueError("Invalid value for parameter `editgroup_id` when calling `get_editgroup`, length must be greater than or equal to `26`")  # noqa: E501
        if 'editgroup_id' in local_var_params and not re.search(r'[a-zA-Z2-7]{26}', local_var_params['editgroup_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `editgroup_id` when calling `get_editgroup`, must conform to the pattern `/[a-zA-Z2-7]{26}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'editgroup_id' in local_var_params:
            path_params['editgroup_id'] = local_var_params['editgroup_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/editgroup/{editgroup_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Editgroup',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_editgroup_annotations(self, editgroup_id, **kwargs):  # noqa: E501
        """get_editgroup_annotations  # noqa: E501

        Returns a list of annotations made to a specific editgroup.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_editgroup_annotations(editgroup_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: base32-encoded unique identifier (required)
        :param str expand: List of sub-entities to expand in response. For editgroup annotations: 'editors'
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[EditgroupAnnotation]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_editgroup_annotations_with_http_info(editgroup_id, **kwargs)  # noqa: E501

    def get_editgroup_annotations_with_http_info(self, editgroup_id, **kwargs):  # noqa: E501
        """get_editgroup_annotations  # noqa: E501

        Returns a list of annotations made to a specific editgroup.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_editgroup_annotations_with_http_info(editgroup_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: base32-encoded unique identifier (required)
        :param str expand: List of sub-entities to expand in response. For editgroup annotations: 'editors'
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[EditgroupAnnotation], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['editgroup_id', 'expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_editgroup_annotations" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'editgroup_id' is set
        if ('editgroup_id' not in local_var_params or
                local_var_params['editgroup_id'] is None):
            raise ApiValueError("Missing the required parameter `editgroup_id` when calling `get_editgroup_annotations`")  # noqa: E501

        if ('editgroup_id' in local_var_params and
                len(local_var_params['editgroup_id']) > 26):
            raise ApiValueError("Invalid value for parameter `editgroup_id` when calling `get_editgroup_annotations`, length must be less than or equal to `26`")  # noqa: E501
        if ('editgroup_id' in local_var_params and
                len(local_var_params['editgroup_id']) < 26):
            raise ApiValueError("Invalid value for parameter `editgroup_id` when calling `get_editgroup_annotations`, length must be greater than or equal to `26`")  # noqa: E501
        if 'editgroup_id' in local_var_params and not re.search(r'[a-zA-Z2-7]{26}', local_var_params['editgroup_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `editgroup_id` when calling `get_editgroup_annotations`, must conform to the pattern `/[a-zA-Z2-7]{26}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'editgroup_id' in local_var_params:
            path_params['editgroup_id'] = local_var_params['editgroup_id']  # noqa: E501

        query_params = []
        if 'expand' in local_var_params:
            query_params.append(('expand', local_var_params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/editgroup/{editgroup_id}/annotations', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[EditgroupAnnotation]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_editgroups_reviewable(self, **kwargs):  # noqa: E501
        """get_editgroups_reviewable  # noqa: E501

        Returns a set of editgroups which have been submitted but not yet accepted.  Query parameters can be used to sort and paginate the list returned.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_editgroups_reviewable(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str expand: List of sub-entities to expand in response. For editgroups: 'editors'
        :param int limit: Maximum number of reviewable editgroups to return in response
        :param datetime before: Return only reviewable editgroups submitted *before* the given timestamp (not inclusive). Editgroups will be sorted by submission time in descending order (most recent first). For use in pagination. 
        :param datetime since: Return only reviewable editgroups submitted *after* the given timestamp (not inclusive). Editgroups will be sorted by submission time in ascending order (most recent last). For use in pagination. 
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Editgroup]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_editgroups_reviewable_with_http_info(**kwargs)  # noqa: E501

    def get_editgroups_reviewable_with_http_info(self, **kwargs):  # noqa: E501
        """get_editgroups_reviewable  # noqa: E501

        Returns a set of editgroups which have been submitted but not yet accepted.  Query parameters can be used to sort and paginate the list returned.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_editgroups_reviewable_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str expand: List of sub-entities to expand in response. For editgroups: 'editors'
        :param int limit: Maximum number of reviewable editgroups to return in response
        :param datetime before: Return only reviewable editgroups submitted *before* the given timestamp (not inclusive). Editgroups will be sorted by submission time in descending order (most recent first). For use in pagination. 
        :param datetime since: Return only reviewable editgroups submitted *after* the given timestamp (not inclusive). Editgroups will be sorted by submission time in ascending order (most recent last). For use in pagination. 
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Editgroup], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['expand', 'limit', 'before', 'since']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_editgroups_reviewable" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'expand' in local_var_params:
            query_params.append(('expand', local_var_params['expand']))  # noqa: E501
        if 'limit' in local_var_params:
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'before' in local_var_params:
            query_params.append(('before', local_var_params['before']))  # noqa: E501
        if 'since' in local_var_params:
            query_params.append(('since', local_var_params['since']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/editgroup/reviewable', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Editgroup]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_editor(self, editor_id, **kwargs):  # noqa: E501
        """get_editor  # noqa: E501

        Returns an editor object, including metadata such as the username, type, and role of editor.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_editor(editor_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editor_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Editor
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_editor_with_http_info(editor_id, **kwargs)  # noqa: E501

    def get_editor_with_http_info(self, editor_id, **kwargs):  # noqa: E501
        """get_editor  # noqa: E501

        Returns an editor object, including metadata such as the username, type, and role of editor.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_editor_with_http_info(editor_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editor_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Editor, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['editor_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_editor" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'editor_id' is set
        if ('editor_id' not in local_var_params or
                local_var_params['editor_id'] is None):
            raise ApiValueError("Missing the required parameter `editor_id` when calling `get_editor`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'editor_id' in local_var_params:
            path_params['editor_id'] = local_var_params['editor_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/editor/{editor_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Editor',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_editor_annotations(self, editor_id, **kwargs):  # noqa: E501
        """get_editor_annotations  # noqa: E501

        Fetches a list of annotations made by a particular editor.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_editor_annotations(editor_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editor_id: base32-encoded unique identifier (required)
        :param int limit: Maximum number (count) of annotations to return in response
        :param datetime before: Return only annotations made *before* the given timestamp (not inclusive). Annotations will be sorted by creation time in descending order (most recent first). For use in pagination. 
        :param datetime since: Return only annotations made *after* the given timestamp (not inclusive). Annotations will be sorted by creation time in ascending order (most recent last). For use in pagination. 
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[EditgroupAnnotation]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_editor_annotations_with_http_info(editor_id, **kwargs)  # noqa: E501

    def get_editor_annotations_with_http_info(self, editor_id, **kwargs):  # noqa: E501
        """get_editor_annotations  # noqa: E501

        Fetches a list of annotations made by a particular editor.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_editor_annotations_with_http_info(editor_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editor_id: base32-encoded unique identifier (required)
        :param int limit: Maximum number (count) of annotations to return in response
        :param datetime before: Return only annotations made *before* the given timestamp (not inclusive). Annotations will be sorted by creation time in descending order (most recent first). For use in pagination. 
        :param datetime since: Return only annotations made *after* the given timestamp (not inclusive). Annotations will be sorted by creation time in ascending order (most recent last). For use in pagination. 
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[EditgroupAnnotation], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['editor_id', 'limit', 'before', 'since']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_editor_annotations" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'editor_id' is set
        if ('editor_id' not in local_var_params or
                local_var_params['editor_id'] is None):
            raise ApiValueError("Missing the required parameter `editor_id` when calling `get_editor_annotations`")  # noqa: E501

        if ('editor_id' in local_var_params and
                len(local_var_params['editor_id']) > 26):
            raise ApiValueError("Invalid value for parameter `editor_id` when calling `get_editor_annotations`, length must be less than or equal to `26`")  # noqa: E501
        if ('editor_id' in local_var_params and
                len(local_var_params['editor_id']) < 26):
            raise ApiValueError("Invalid value for parameter `editor_id` when calling `get_editor_annotations`, length must be greater than or equal to `26`")  # noqa: E501
        if 'editor_id' in local_var_params and not re.search(r'[a-zA-Z2-7]{26}', local_var_params['editor_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `editor_id` when calling `get_editor_annotations`, must conform to the pattern `/[a-zA-Z2-7]{26}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'editor_id' in local_var_params:
            path_params['editor_id'] = local_var_params['editor_id']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params:
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'before' in local_var_params:
            query_params.append(('before', local_var_params['before']))  # noqa: E501
        if 'since' in local_var_params:
            query_params.append(('since', local_var_params['since']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/editor/{editor_id}/annotations', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[EditgroupAnnotation]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_editor_editgroups(self, editor_id, **kwargs):  # noqa: E501
        """get_editor_editgroups  # noqa: E501

        Returns a set of editgroups created by the given editor, regardless of the status (accepted/submitted) of the editgroups.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_editor_editgroups(editor_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editor_id: (required)
        :param int limit:
        :param datetime before: Return only editgroups created *before* the given timestamp (not inclusive). Editgroups will be sorted by creation time in descending order (most recent first). For use in pagination. 
        :param datetime since: Return only editgroups created *after* the given timestamp (not inclusive). Editgroups will be sorted by creation time in ascending order (most recent last). For use in pagination. 
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Editgroup]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_editor_editgroups_with_http_info(editor_id, **kwargs)  # noqa: E501

    def get_editor_editgroups_with_http_info(self, editor_id, **kwargs):  # noqa: E501
        """get_editor_editgroups  # noqa: E501

        Returns a set of editgroups created by the given editor, regardless of the status (accepted/submitted) of the editgroups.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_editor_editgroups_with_http_info(editor_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editor_id: (required)
        :param int limit:
        :param datetime before: Return only editgroups created *before* the given timestamp (not inclusive). Editgroups will be sorted by creation time in descending order (most recent first). For use in pagination. 
        :param datetime since: Return only editgroups created *after* the given timestamp (not inclusive). Editgroups will be sorted by creation time in ascending order (most recent last). For use in pagination. 
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Editgroup], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['editor_id', 'limit', 'before', 'since']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_editor_editgroups" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'editor_id' is set
        if ('editor_id' not in local_var_params or
                local_var_params['editor_id'] is None):
            raise ApiValueError("Missing the required parameter `editor_id` when calling `get_editor_editgroups`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'editor_id' in local_var_params:
            path_params['editor_id'] = local_var_params['editor_id']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params:
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'before' in local_var_params:
            query_params.append(('before', local_var_params['before']))  # noqa: E501
        if 'since' in local_var_params:
            query_params.append(('since', local_var_params['since']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/editor/{editor_id}/editgroups', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Editgroup]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_file(self, ident, **kwargs):  # noqa: E501
        """get_file  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param str expand: List of sub-entities to expand in response. For files, `releases` is accepted.
        :param str hide: List of entity fields to elide in response. For files, none accepted (yet).
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FileEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_file_with_http_info(ident, **kwargs)  # noqa: E501

    def get_file_with_http_info(self, ident, **kwargs):  # noqa: E501
        """get_file  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file_with_http_info(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param str expand: List of sub-entities to expand in response. For files, `releases` is accepted.
        :param str hide: List of entity fields to elide in response. For files, none accepted (yet).
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FileEntity, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['ident', 'expand', 'hide']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ident' is set
        if ('ident' not in local_var_params or
                local_var_params['ident'] is None):
            raise ApiValueError("Missing the required parameter `ident` when calling `get_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ident' in local_var_params:
            path_params['ident'] = local_var_params['ident']  # noqa: E501

        query_params = []
        if 'expand' in local_var_params:
            query_params.append(('expand', local_var_params['expand']))  # noqa: E501
        if 'hide' in local_var_params:
            query_params.append(('hide', local_var_params['hide']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/file/{ident}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_file_edit(self, edit_id, **kwargs):  # noqa: E501
        """get_file_edit  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file_edit(edit_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str edit_id: UUID (lower-case, dash-separated, hex-encoded 128-bit) (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EntityEdit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_file_edit_with_http_info(edit_id, **kwargs)  # noqa: E501

    def get_file_edit_with_http_info(self, edit_id, **kwargs):  # noqa: E501
        """get_file_edit  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file_edit_with_http_info(edit_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str edit_id: UUID (lower-case, dash-separated, hex-encoded 128-bit) (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EntityEdit, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['edit_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file_edit" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edit_id' is set
        if ('edit_id' not in local_var_params or
                local_var_params['edit_id'] is None):
            raise ApiValueError("Missing the required parameter `edit_id` when calling `get_file_edit`")  # noqa: E501

        if ('edit_id' in local_var_params and
                len(local_var_params['edit_id']) > 36):
            raise ApiValueError("Invalid value for parameter `edit_id` when calling `get_file_edit`, length must be less than or equal to `36`")  # noqa: E501
        if ('edit_id' in local_var_params and
                len(local_var_params['edit_id']) < 36):
            raise ApiValueError("Invalid value for parameter `edit_id` when calling `get_file_edit`, length must be greater than or equal to `36`")  # noqa: E501
        if 'edit_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['edit_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `edit_id` when calling `get_file_edit`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'edit_id' in local_var_params:
            path_params['edit_id'] = local_var_params['edit_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/file/edit/{edit_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EntityEdit',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_file_history(self, ident, **kwargs):  # noqa: E501
        """get_file_history  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file_history(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param int limit:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[EntityHistoryEntry]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_file_history_with_http_info(ident, **kwargs)  # noqa: E501

    def get_file_history_with_http_info(self, ident, **kwargs):  # noqa: E501
        """get_file_history  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file_history_with_http_info(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param int limit:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[EntityHistoryEntry], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['ident', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file_history" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ident' is set
        if ('ident' not in local_var_params or
                local_var_params['ident'] is None):
            raise ApiValueError("Missing the required parameter `ident` when calling `get_file_history`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ident' in local_var_params:
            path_params['ident'] = local_var_params['ident']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params:
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/file/{ident}/history', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[EntityHistoryEntry]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_file_redirects(self, ident, **kwargs):  # noqa: E501
        """get_file_redirects  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file_redirects(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_file_redirects_with_http_info(ident, **kwargs)  # noqa: E501

    def get_file_redirects_with_http_info(self, ident, **kwargs):  # noqa: E501
        """get_file_redirects  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file_redirects_with_http_info(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[str], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['ident']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file_redirects" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ident' is set
        if ('ident' not in local_var_params or
                local_var_params['ident'] is None):
            raise ApiValueError("Missing the required parameter `ident` when calling `get_file_redirects`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ident' in local_var_params:
            path_params['ident'] = local_var_params['ident']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/file/{ident}/redirects', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[str]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_file_revision(self, rev_id, **kwargs):  # noqa: E501
        """get_file_revision  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file_revision(rev_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str rev_id: UUID (lower-case, dash-separated, hex-encoded 128-bit) (required)
        :param str expand: List of sub-entities to expand in response. See `get_file`.
        :param str hide: List of entity fields to elide in response. See `get_file`.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FileEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_file_revision_with_http_info(rev_id, **kwargs)  # noqa: E501

    def get_file_revision_with_http_info(self, rev_id, **kwargs):  # noqa: E501
        """get_file_revision  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file_revision_with_http_info(rev_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str rev_id: UUID (lower-case, dash-separated, hex-encoded 128-bit) (required)
        :param str expand: List of sub-entities to expand in response. See `get_file`.
        :param str hide: List of entity fields to elide in response. See `get_file`.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FileEntity, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['rev_id', 'expand', 'hide']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file_revision" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'rev_id' is set
        if ('rev_id' not in local_var_params or
                local_var_params['rev_id'] is None):
            raise ApiValueError("Missing the required parameter `rev_id` when calling `get_file_revision`")  # noqa: E501

        if ('rev_id' in local_var_params and
                len(local_var_params['rev_id']) > 36):
            raise ApiValueError("Invalid value for parameter `rev_id` when calling `get_file_revision`, length must be less than or equal to `36`")  # noqa: E501
        if ('rev_id' in local_var_params and
                len(local_var_params['rev_id']) < 36):
            raise ApiValueError("Invalid value for parameter `rev_id` when calling `get_file_revision`, length must be greater than or equal to `36`")  # noqa: E501
        if 'rev_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['rev_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `rev_id` when calling `get_file_revision`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'rev_id' in local_var_params:
            path_params['rev_id'] = local_var_params['rev_id']  # noqa: E501

        query_params = []
        if 'expand' in local_var_params:
            query_params.append(('expand', local_var_params['expand']))  # noqa: E501
        if 'hide' in local_var_params:
            query_params.append(('hide', local_var_params['hide']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/file/rev/{rev_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_fileset(self, ident, **kwargs):  # noqa: E501
        """get_fileset  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_fileset(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param str expand: List of sub-entities to expand in response. For filesets, `releases` is accepted.
        :param str hide: List of entity fields to elide in response. For filesets, 'manifest' is accepted.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FilesetEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_fileset_with_http_info(ident, **kwargs)  # noqa: E501

    def get_fileset_with_http_info(self, ident, **kwargs):  # noqa: E501
        """get_fileset  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_fileset_with_http_info(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param str expand: List of sub-entities to expand in response. For filesets, `releases` is accepted.
        :param str hide: List of entity fields to elide in response. For filesets, 'manifest' is accepted.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FilesetEntity, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['ident', 'expand', 'hide']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_fileset" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ident' is set
        if ('ident' not in local_var_params or
                local_var_params['ident'] is None):
            raise ApiValueError("Missing the required parameter `ident` when calling `get_fileset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ident' in local_var_params:
            path_params['ident'] = local_var_params['ident']  # noqa: E501

        query_params = []
        if 'expand' in local_var_params:
            query_params.append(('expand', local_var_params['expand']))  # noqa: E501
        if 'hide' in local_var_params:
            query_params.append(('hide', local_var_params['hide']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/fileset/{ident}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FilesetEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_fileset_edit(self, edit_id, **kwargs):  # noqa: E501
        """get_fileset_edit  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_fileset_edit(edit_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str edit_id: UUID (lower-case, dash-separated, hex-encoded 128-bit) (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EntityEdit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_fileset_edit_with_http_info(edit_id, **kwargs)  # noqa: E501

    def get_fileset_edit_with_http_info(self, edit_id, **kwargs):  # noqa: E501
        """get_fileset_edit  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_fileset_edit_with_http_info(edit_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str edit_id: UUID (lower-case, dash-separated, hex-encoded 128-bit) (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EntityEdit, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['edit_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_fileset_edit" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edit_id' is set
        if ('edit_id' not in local_var_params or
                local_var_params['edit_id'] is None):
            raise ApiValueError("Missing the required parameter `edit_id` when calling `get_fileset_edit`")  # noqa: E501

        if ('edit_id' in local_var_params and
                len(local_var_params['edit_id']) > 36):
            raise ApiValueError("Invalid value for parameter `edit_id` when calling `get_fileset_edit`, length must be less than or equal to `36`")  # noqa: E501
        if ('edit_id' in local_var_params and
                len(local_var_params['edit_id']) < 36):
            raise ApiValueError("Invalid value for parameter `edit_id` when calling `get_fileset_edit`, length must be greater than or equal to `36`")  # noqa: E501
        if 'edit_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['edit_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `edit_id` when calling `get_fileset_edit`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'edit_id' in local_var_params:
            path_params['edit_id'] = local_var_params['edit_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/fileset/edit/{edit_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EntityEdit',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_fileset_history(self, ident, **kwargs):  # noqa: E501
        """get_fileset_history  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_fileset_history(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param int limit:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[EntityHistoryEntry]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_fileset_history_with_http_info(ident, **kwargs)  # noqa: E501

    def get_fileset_history_with_http_info(self, ident, **kwargs):  # noqa: E501
        """get_fileset_history  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_fileset_history_with_http_info(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param int limit:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[EntityHistoryEntry], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['ident', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_fileset_history" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ident' is set
        if ('ident' not in local_var_params or
                local_var_params['ident'] is None):
            raise ApiValueError("Missing the required parameter `ident` when calling `get_fileset_history`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ident' in local_var_params:
            path_params['ident'] = local_var_params['ident']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params:
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/fileset/{ident}/history', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[EntityHistoryEntry]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_fileset_redirects(self, ident, **kwargs):  # noqa: E501
        """get_fileset_redirects  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_fileset_redirects(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_fileset_redirects_with_http_info(ident, **kwargs)  # noqa: E501

    def get_fileset_redirects_with_http_info(self, ident, **kwargs):  # noqa: E501
        """get_fileset_redirects  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_fileset_redirects_with_http_info(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[str], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['ident']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_fileset_redirects" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ident' is set
        if ('ident' not in local_var_params or
                local_var_params['ident'] is None):
            raise ApiValueError("Missing the required parameter `ident` when calling `get_fileset_redirects`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ident' in local_var_params:
            path_params['ident'] = local_var_params['ident']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/fileset/{ident}/redirects', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[str]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_fileset_revision(self, rev_id, **kwargs):  # noqa: E501
        """get_fileset_revision  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_fileset_revision(rev_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str rev_id: UUID (lower-case, dash-separated, hex-encoded 128-bit) (required)
        :param str expand: List of sub-entities to expand in response. See `get_fileset`.
        :param str hide: List of entity fields to elide in response. See `get_fileset`.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FilesetEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_fileset_revision_with_http_info(rev_id, **kwargs)  # noqa: E501

    def get_fileset_revision_with_http_info(self, rev_id, **kwargs):  # noqa: E501
        """get_fileset_revision  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_fileset_revision_with_http_info(rev_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str rev_id: UUID (lower-case, dash-separated, hex-encoded 128-bit) (required)
        :param str expand: List of sub-entities to expand in response. See `get_fileset`.
        :param str hide: List of entity fields to elide in response. See `get_fileset`.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FilesetEntity, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['rev_id', 'expand', 'hide']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_fileset_revision" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'rev_id' is set
        if ('rev_id' not in local_var_params or
                local_var_params['rev_id'] is None):
            raise ApiValueError("Missing the required parameter `rev_id` when calling `get_fileset_revision`")  # noqa: E501

        if ('rev_id' in local_var_params and
                len(local_var_params['rev_id']) > 36):
            raise ApiValueError("Invalid value for parameter `rev_id` when calling `get_fileset_revision`, length must be less than or equal to `36`")  # noqa: E501
        if ('rev_id' in local_var_params and
                len(local_var_params['rev_id']) < 36):
            raise ApiValueError("Invalid value for parameter `rev_id` when calling `get_fileset_revision`, length must be greater than or equal to `36`")  # noqa: E501
        if 'rev_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['rev_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `rev_id` when calling `get_fileset_revision`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'rev_id' in local_var_params:
            path_params['rev_id'] = local_var_params['rev_id']  # noqa: E501

        query_params = []
        if 'expand' in local_var_params:
            query_params.append(('expand', local_var_params['expand']))  # noqa: E501
        if 'hide' in local_var_params:
            query_params.append(('hide', local_var_params['hide']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/fileset/rev/{rev_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FilesetEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_release(self, ident, **kwargs):  # noqa: E501
        """get_release  # noqa: E501

        Fetches a single Release entity from the catalog.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_release(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param str expand: List of sub-entities to expand in response. For releases, 'files', 'filesets, 'webcaptures', 'container', and 'creators' are valid. 
        :param str hide: List of entity fields to elide in response (for efficiency). For releases, 'abstracts', 'refs', and 'contribs' are valid. 
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ReleaseEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_release_with_http_info(ident, **kwargs)  # noqa: E501

    def get_release_with_http_info(self, ident, **kwargs):  # noqa: E501
        """get_release  # noqa: E501

        Fetches a single Release entity from the catalog.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_release_with_http_info(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param str expand: List of sub-entities to expand in response. For releases, 'files', 'filesets, 'webcaptures', 'container', and 'creators' are valid. 
        :param str hide: List of entity fields to elide in response (for efficiency). For releases, 'abstracts', 'refs', and 'contribs' are valid. 
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ReleaseEntity, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['ident', 'expand', 'hide']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_release" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ident' is set
        if ('ident' not in local_var_params or
                local_var_params['ident'] is None):
            raise ApiValueError("Missing the required parameter `ident` when calling `get_release`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ident' in local_var_params:
            path_params['ident'] = local_var_params['ident']  # noqa: E501

        query_params = []
        if 'expand' in local_var_params:
            query_params.append(('expand', local_var_params['expand']))  # noqa: E501
        if 'hide' in local_var_params:
            query_params.append(('hide', local_var_params['hide']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/release/{ident}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReleaseEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_release_edit(self, edit_id, **kwargs):  # noqa: E501
        """get_release_edit  # noqa: E501

        Returns the entity edit object with the given identifier. This method is expected to be used rarely.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_release_edit(edit_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str edit_id: UUID (lower-case, dash-separated, hex-encoded 128-bit) (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EntityEdit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_release_edit_with_http_info(edit_id, **kwargs)  # noqa: E501

    def get_release_edit_with_http_info(self, edit_id, **kwargs):  # noqa: E501
        """get_release_edit  # noqa: E501

        Returns the entity edit object with the given identifier. This method is expected to be used rarely.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_release_edit_with_http_info(edit_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str edit_id: UUID (lower-case, dash-separated, hex-encoded 128-bit) (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EntityEdit, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['edit_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_release_edit" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edit_id' is set
        if ('edit_id' not in local_var_params or
                local_var_params['edit_id'] is None):
            raise ApiValueError("Missing the required parameter `edit_id` when calling `get_release_edit`")  # noqa: E501

        if ('edit_id' in local_var_params and
                len(local_var_params['edit_id']) > 36):
            raise ApiValueError("Invalid value for parameter `edit_id` when calling `get_release_edit`, length must be less than or equal to `36`")  # noqa: E501
        if ('edit_id' in local_var_params and
                len(local_var_params['edit_id']) < 36):
            raise ApiValueError("Invalid value for parameter `edit_id` when calling `get_release_edit`, length must be greater than or equal to `36`")  # noqa: E501
        if 'edit_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['edit_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `edit_id` when calling `get_release_edit`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'edit_id' in local_var_params:
            path_params['edit_id'] = local_var_params['edit_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/release/edit/{edit_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EntityEdit',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_release_files(self, ident, **kwargs):  # noqa: E501
        """get_release_files  # noqa: E501

        Returns the set of File entities that have a `release_id` pointing to this release entity.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_release_files(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param str hide: List of entity fields to elide in response. See `get_file`.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[FileEntity]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_release_files_with_http_info(ident, **kwargs)  # noqa: E501

    def get_release_files_with_http_info(self, ident, **kwargs):  # noqa: E501
        """get_release_files  # noqa: E501

        Returns the set of File entities that have a `release_id` pointing to this release entity.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_release_files_with_http_info(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param str hide: List of entity fields to elide in response. See `get_file`.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[FileEntity], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['ident', 'hide']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_release_files" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ident' is set
        if ('ident' not in local_var_params or
                local_var_params['ident'] is None):
            raise ApiValueError("Missing the required parameter `ident` when calling `get_release_files`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ident' in local_var_params:
            path_params['ident'] = local_var_params['ident']  # noqa: E501

        query_params = []
        if 'hide' in local_var_params:
            query_params.append(('hide', local_var_params['hide']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/release/{ident}/files', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[FileEntity]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_release_filesets(self, ident, **kwargs):  # noqa: E501
        """get_release_filesets  # noqa: E501

        Returns the set of Fileset entities that have a `release_id` pointing to this release entity.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_release_filesets(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param str hide: List of entity fields to elide in response. See `get_fileset`.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[FilesetEntity]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_release_filesets_with_http_info(ident, **kwargs)  # noqa: E501

    def get_release_filesets_with_http_info(self, ident, **kwargs):  # noqa: E501
        """get_release_filesets  # noqa: E501

        Returns the set of Fileset entities that have a `release_id` pointing to this release entity.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_release_filesets_with_http_info(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param str hide: List of entity fields to elide in response. See `get_fileset`.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[FilesetEntity], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['ident', 'hide']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_release_filesets" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ident' is set
        if ('ident' not in local_var_params or
                local_var_params['ident'] is None):
            raise ApiValueError("Missing the required parameter `ident` when calling `get_release_filesets`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ident' in local_var_params:
            path_params['ident'] = local_var_params['ident']  # noqa: E501

        query_params = []
        if 'hide' in local_var_params:
            query_params.append(('hide', local_var_params['hide']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/release/{ident}/filesets', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[FilesetEntity]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_release_history(self, ident, **kwargs):  # noqa: E501
        """get_release_history  # noqa: E501

        Fetches the history of accepted edits (changelog entries) for a specific entity fatcat identifier.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_release_history(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param int limit:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[EntityHistoryEntry]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_release_history_with_http_info(ident, **kwargs)  # noqa: E501

    def get_release_history_with_http_info(self, ident, **kwargs):  # noqa: E501
        """get_release_history  # noqa: E501

        Fetches the history of accepted edits (changelog entries) for a specific entity fatcat identifier.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_release_history_with_http_info(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param int limit:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[EntityHistoryEntry], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['ident', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_release_history" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ident' is set
        if ('ident' not in local_var_params or
                local_var_params['ident'] is None):
            raise ApiValueError("Missing the required parameter `ident` when calling `get_release_history`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ident' in local_var_params:
            path_params['ident'] = local_var_params['ident']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params:
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/release/{ident}/history', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[EntityHistoryEntry]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_release_redirects(self, ident, **kwargs):  # noqa: E501
        """get_release_redirects  # noqa: E501

        Returns the set of entity identifiers which currently redirect to this identifier.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_release_redirects(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_release_redirects_with_http_info(ident, **kwargs)  # noqa: E501

    def get_release_redirects_with_http_info(self, ident, **kwargs):  # noqa: E501
        """get_release_redirects  # noqa: E501

        Returns the set of entity identifiers which currently redirect to this identifier.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_release_redirects_with_http_info(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[str], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['ident']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_release_redirects" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ident' is set
        if ('ident' not in local_var_params or
                local_var_params['ident'] is None):
            raise ApiValueError("Missing the required parameter `ident` when calling `get_release_redirects`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ident' in local_var_params:
            path_params['ident'] = local_var_params['ident']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/release/{ident}/redirects', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[str]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_release_revision(self, rev_id, **kwargs):  # noqa: E501
        """get_release_revision  # noqa: E501

        Fetches a specific entity revision. Note that the returned revision will not be associated with any particular fatcat identifier (even if one or more identifiers do currently point to this revision). The revision may even be part of an un-merged editgroup.  Revisions are immutable and can not be deleted or updated.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_release_revision(rev_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str rev_id: UUID (lower-case, dash-separated, hex-encoded 128-bit) (required)
        :param str expand: List of sub-entities to expand in response. See `get_release`, though note that identifier-based exapansions like `file` will always be empty for revisions.
        :param str hide: List of entity fields to elide in response. See `get_release`.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ReleaseEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_release_revision_with_http_info(rev_id, **kwargs)  # noqa: E501

    def get_release_revision_with_http_info(self, rev_id, **kwargs):  # noqa: E501
        """get_release_revision  # noqa: E501

        Fetches a specific entity revision. Note that the returned revision will not be associated with any particular fatcat identifier (even if one or more identifiers do currently point to this revision). The revision may even be part of an un-merged editgroup.  Revisions are immutable and can not be deleted or updated.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_release_revision_with_http_info(rev_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str rev_id: UUID (lower-case, dash-separated, hex-encoded 128-bit) (required)
        :param str expand: List of sub-entities to expand in response. See `get_release`, though note that identifier-based exapansions like `file` will always be empty for revisions.
        :param str hide: List of entity fields to elide in response. See `get_release`.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ReleaseEntity, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['rev_id', 'expand', 'hide']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_release_revision" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'rev_id' is set
        if ('rev_id' not in local_var_params or
                local_var_params['rev_id'] is None):
            raise ApiValueError("Missing the required parameter `rev_id` when calling `get_release_revision`")  # noqa: E501

        if ('rev_id' in local_var_params and
                len(local_var_params['rev_id']) > 36):
            raise ApiValueError("Invalid value for parameter `rev_id` when calling `get_release_revision`, length must be less than or equal to `36`")  # noqa: E501
        if ('rev_id' in local_var_params and
                len(local_var_params['rev_id']) < 36):
            raise ApiValueError("Invalid value for parameter `rev_id` when calling `get_release_revision`, length must be greater than or equal to `36`")  # noqa: E501
        if 'rev_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['rev_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `rev_id` when calling `get_release_revision`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'rev_id' in local_var_params:
            path_params['rev_id'] = local_var_params['rev_id']  # noqa: E501

        query_params = []
        if 'expand' in local_var_params:
            query_params.append(('expand', local_var_params['expand']))  # noqa: E501
        if 'hide' in local_var_params:
            query_params.append(('hide', local_var_params['hide']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/release/rev/{rev_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReleaseEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_release_webcaptures(self, ident, **kwargs):  # noqa: E501
        """get_release_webcaptures  # noqa: E501

        Returns the set of Web Capture entities that have a `release_id` pointing to this release entity.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_release_webcaptures(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param str hide: List of entity fields to elide in response. See `get_webcapture`.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[WebcaptureEntity]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_release_webcaptures_with_http_info(ident, **kwargs)  # noqa: E501

    def get_release_webcaptures_with_http_info(self, ident, **kwargs):  # noqa: E501
        """get_release_webcaptures  # noqa: E501

        Returns the set of Web Capture entities that have a `release_id` pointing to this release entity.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_release_webcaptures_with_http_info(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param str hide: List of entity fields to elide in response. See `get_webcapture`.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[WebcaptureEntity], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['ident', 'hide']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_release_webcaptures" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ident' is set
        if ('ident' not in local_var_params or
                local_var_params['ident'] is None):
            raise ApiValueError("Missing the required parameter `ident` when calling `get_release_webcaptures`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ident' in local_var_params:
            path_params['ident'] = local_var_params['ident']  # noqa: E501

        query_params = []
        if 'hide' in local_var_params:
            query_params.append(('hide', local_var_params['hide']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/release/{ident}/webcaptures', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[WebcaptureEntity]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_webcapture(self, ident, **kwargs):  # noqa: E501
        """get_webcapture  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_webcapture(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param str expand: List of sub-entities to expand in response. For webcaptures, `releases` is accepted.
        :param str hide: List of entity fields to elide in response. For webcaptures, 'cdx' is accepted.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: WebcaptureEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_webcapture_with_http_info(ident, **kwargs)  # noqa: E501

    def get_webcapture_with_http_info(self, ident, **kwargs):  # noqa: E501
        """get_webcapture  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_webcapture_with_http_info(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param str expand: List of sub-entities to expand in response. For webcaptures, `releases` is accepted.
        :param str hide: List of entity fields to elide in response. For webcaptures, 'cdx' is accepted.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(WebcaptureEntity, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['ident', 'expand', 'hide']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_webcapture" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ident' is set
        if ('ident' not in local_var_params or
                local_var_params['ident'] is None):
            raise ApiValueError("Missing the required parameter `ident` when calling `get_webcapture`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ident' in local_var_params:
            path_params['ident'] = local_var_params['ident']  # noqa: E501

        query_params = []
        if 'expand' in local_var_params:
            query_params.append(('expand', local_var_params['expand']))  # noqa: E501
        if 'hide' in local_var_params:
            query_params.append(('hide', local_var_params['hide']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/webcapture/{ident}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WebcaptureEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_webcapture_edit(self, edit_id, **kwargs):  # noqa: E501
        """get_webcapture_edit  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_webcapture_edit(edit_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str edit_id: UUID (lower-case, dash-separated, hex-encoded 128-bit) (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EntityEdit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_webcapture_edit_with_http_info(edit_id, **kwargs)  # noqa: E501

    def get_webcapture_edit_with_http_info(self, edit_id, **kwargs):  # noqa: E501
        """get_webcapture_edit  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_webcapture_edit_with_http_info(edit_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str edit_id: UUID (lower-case, dash-separated, hex-encoded 128-bit) (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EntityEdit, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['edit_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_webcapture_edit" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edit_id' is set
        if ('edit_id' not in local_var_params or
                local_var_params['edit_id'] is None):
            raise ApiValueError("Missing the required parameter `edit_id` when calling `get_webcapture_edit`")  # noqa: E501

        if ('edit_id' in local_var_params and
                len(local_var_params['edit_id']) > 36):
            raise ApiValueError("Invalid value for parameter `edit_id` when calling `get_webcapture_edit`, length must be less than or equal to `36`")  # noqa: E501
        if ('edit_id' in local_var_params and
                len(local_var_params['edit_id']) < 36):
            raise ApiValueError("Invalid value for parameter `edit_id` when calling `get_webcapture_edit`, length must be greater than or equal to `36`")  # noqa: E501
        if 'edit_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['edit_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `edit_id` when calling `get_webcapture_edit`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'edit_id' in local_var_params:
            path_params['edit_id'] = local_var_params['edit_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/webcapture/edit/{edit_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EntityEdit',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_webcapture_history(self, ident, **kwargs):  # noqa: E501
        """get_webcapture_history  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_webcapture_history(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param int limit:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[EntityHistoryEntry]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_webcapture_history_with_http_info(ident, **kwargs)  # noqa: E501

    def get_webcapture_history_with_http_info(self, ident, **kwargs):  # noqa: E501
        """get_webcapture_history  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_webcapture_history_with_http_info(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param int limit:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[EntityHistoryEntry], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['ident', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_webcapture_history" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ident' is set
        if ('ident' not in local_var_params or
                local_var_params['ident'] is None):
            raise ApiValueError("Missing the required parameter `ident` when calling `get_webcapture_history`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ident' in local_var_params:
            path_params['ident'] = local_var_params['ident']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params:
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/webcapture/{ident}/history', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[EntityHistoryEntry]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_webcapture_redirects(self, ident, **kwargs):  # noqa: E501
        """get_webcapture_redirects  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_webcapture_redirects(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_webcapture_redirects_with_http_info(ident, **kwargs)  # noqa: E501

    def get_webcapture_redirects_with_http_info(self, ident, **kwargs):  # noqa: E501
        """get_webcapture_redirects  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_webcapture_redirects_with_http_info(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[str], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['ident']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_webcapture_redirects" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ident' is set
        if ('ident' not in local_var_params or
                local_var_params['ident'] is None):
            raise ApiValueError("Missing the required parameter `ident` when calling `get_webcapture_redirects`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ident' in local_var_params:
            path_params['ident'] = local_var_params['ident']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/webcapture/{ident}/redirects', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[str]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_webcapture_revision(self, rev_id, **kwargs):  # noqa: E501
        """get_webcapture_revision  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_webcapture_revision(rev_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str rev_id: UUID (lower-case, dash-separated, hex-encoded 128-bit) (required)
        :param str expand: List of sub-entities to expand in response. See `get_webcapture`.
        :param str hide: List of entity fields to elide in response. See `get_webcapture`.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: WebcaptureEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_webcapture_revision_with_http_info(rev_id, **kwargs)  # noqa: E501

    def get_webcapture_revision_with_http_info(self, rev_id, **kwargs):  # noqa: E501
        """get_webcapture_revision  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_webcapture_revision_with_http_info(rev_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str rev_id: UUID (lower-case, dash-separated, hex-encoded 128-bit) (required)
        :param str expand: List of sub-entities to expand in response. See `get_webcapture`.
        :param str hide: List of entity fields to elide in response. See `get_webcapture`.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(WebcaptureEntity, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['rev_id', 'expand', 'hide']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_webcapture_revision" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'rev_id' is set
        if ('rev_id' not in local_var_params or
                local_var_params['rev_id'] is None):
            raise ApiValueError("Missing the required parameter `rev_id` when calling `get_webcapture_revision`")  # noqa: E501

        if ('rev_id' in local_var_params and
                len(local_var_params['rev_id']) > 36):
            raise ApiValueError("Invalid value for parameter `rev_id` when calling `get_webcapture_revision`, length must be less than or equal to `36`")  # noqa: E501
        if ('rev_id' in local_var_params and
                len(local_var_params['rev_id']) < 36):
            raise ApiValueError("Invalid value for parameter `rev_id` when calling `get_webcapture_revision`, length must be greater than or equal to `36`")  # noqa: E501
        if 'rev_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['rev_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `rev_id` when calling `get_webcapture_revision`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'rev_id' in local_var_params:
            path_params['rev_id'] = local_var_params['rev_id']  # noqa: E501

        query_params = []
        if 'expand' in local_var_params:
            query_params.append(('expand', local_var_params['expand']))  # noqa: E501
        if 'hide' in local_var_params:
            query_params.append(('hide', local_var_params['hide']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/webcapture/rev/{rev_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WebcaptureEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_work(self, ident, **kwargs):  # noqa: E501
        """get_work  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_work(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param str expand: List of sub-entities to expand in response. For works, none accepted (yet).
        :param str hide: List of entity fields to elide in response. For works, none accepted (yet).
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: WorkEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_work_with_http_info(ident, **kwargs)  # noqa: E501

    def get_work_with_http_info(self, ident, **kwargs):  # noqa: E501
        """get_work  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_work_with_http_info(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param str expand: List of sub-entities to expand in response. For works, none accepted (yet).
        :param str hide: List of entity fields to elide in response. For works, none accepted (yet).
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(WorkEntity, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['ident', 'expand', 'hide']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_work" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ident' is set
        if ('ident' not in local_var_params or
                local_var_params['ident'] is None):
            raise ApiValueError("Missing the required parameter `ident` when calling `get_work`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ident' in local_var_params:
            path_params['ident'] = local_var_params['ident']  # noqa: E501

        query_params = []
        if 'expand' in local_var_params:
            query_params.append(('expand', local_var_params['expand']))  # noqa: E501
        if 'hide' in local_var_params:
            query_params.append(('hide', local_var_params['hide']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/work/{ident}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WorkEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_work_edit(self, edit_id, **kwargs):  # noqa: E501
        """get_work_edit  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_work_edit(edit_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str edit_id: UUID (lower-case, dash-separated, hex-encoded 128-bit) (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EntityEdit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_work_edit_with_http_info(edit_id, **kwargs)  # noqa: E501

    def get_work_edit_with_http_info(self, edit_id, **kwargs):  # noqa: E501
        """get_work_edit  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_work_edit_with_http_info(edit_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str edit_id: UUID (lower-case, dash-separated, hex-encoded 128-bit) (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EntityEdit, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['edit_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_work_edit" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edit_id' is set
        if ('edit_id' not in local_var_params or
                local_var_params['edit_id'] is None):
            raise ApiValueError("Missing the required parameter `edit_id` when calling `get_work_edit`")  # noqa: E501

        if ('edit_id' in local_var_params and
                len(local_var_params['edit_id']) > 36):
            raise ApiValueError("Invalid value for parameter `edit_id` when calling `get_work_edit`, length must be less than or equal to `36`")  # noqa: E501
        if ('edit_id' in local_var_params and
                len(local_var_params['edit_id']) < 36):
            raise ApiValueError("Invalid value for parameter `edit_id` when calling `get_work_edit`, length must be greater than or equal to `36`")  # noqa: E501
        if 'edit_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['edit_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `edit_id` when calling `get_work_edit`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'edit_id' in local_var_params:
            path_params['edit_id'] = local_var_params['edit_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/work/edit/{edit_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EntityEdit',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_work_history(self, ident, **kwargs):  # noqa: E501
        """get_work_history  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_work_history(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param int limit:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[EntityHistoryEntry]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_work_history_with_http_info(ident, **kwargs)  # noqa: E501

    def get_work_history_with_http_info(self, ident, **kwargs):  # noqa: E501
        """get_work_history  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_work_history_with_http_info(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param int limit:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[EntityHistoryEntry], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['ident', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_work_history" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ident' is set
        if ('ident' not in local_var_params or
                local_var_params['ident'] is None):
            raise ApiValueError("Missing the required parameter `ident` when calling `get_work_history`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ident' in local_var_params:
            path_params['ident'] = local_var_params['ident']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params:
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/work/{ident}/history', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[EntityHistoryEntry]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_work_redirects(self, ident, **kwargs):  # noqa: E501
        """get_work_redirects  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_work_redirects(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_work_redirects_with_http_info(ident, **kwargs)  # noqa: E501

    def get_work_redirects_with_http_info(self, ident, **kwargs):  # noqa: E501
        """get_work_redirects  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_work_redirects_with_http_info(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[str], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['ident']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_work_redirects" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ident' is set
        if ('ident' not in local_var_params or
                local_var_params['ident'] is None):
            raise ApiValueError("Missing the required parameter `ident` when calling `get_work_redirects`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ident' in local_var_params:
            path_params['ident'] = local_var_params['ident']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/work/{ident}/redirects', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[str]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_work_releases(self, ident, **kwargs):  # noqa: E501
        """get_work_releases  # noqa: E501

        Returns the set of release entities that are part of this work (aka, have `work_id` pointing to this work entity).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_work_releases(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param str hide: List of entity fields to elide in response. See `get_release`.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[ReleaseEntity]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_work_releases_with_http_info(ident, **kwargs)  # noqa: E501

    def get_work_releases_with_http_info(self, ident, **kwargs):  # noqa: E501
        """get_work_releases  # noqa: E501

        Returns the set of release entities that are part of this work (aka, have `work_id` pointing to this work entity).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_work_releases_with_http_info(ident, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ident: (required)
        :param str hide: List of entity fields to elide in response. See `get_release`.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[ReleaseEntity], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['ident', 'hide']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_work_releases" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ident' is set
        if ('ident' not in local_var_params or
                local_var_params['ident'] is None):
            raise ApiValueError("Missing the required parameter `ident` when calling `get_work_releases`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ident' in local_var_params:
            path_params['ident'] = local_var_params['ident']  # noqa: E501

        query_params = []
        if 'hide' in local_var_params:
            query_params.append(('hide', local_var_params['hide']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/work/{ident}/releases', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ReleaseEntity]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_work_revision(self, rev_id, **kwargs):  # noqa: E501
        """get_work_revision  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_work_revision(rev_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str rev_id: UUID (lower-case, dash-separated, hex-encoded 128-bit) (required)
        :param str expand: List of sub-entities to expand in response. See `get_work`, though note that identifier-based expansions like `releases` will always be empty for revisions.
        :param str hide: List of entity fields to elide in response. See `get_work`.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: WorkEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_work_revision_with_http_info(rev_id, **kwargs)  # noqa: E501

    def get_work_revision_with_http_info(self, rev_id, **kwargs):  # noqa: E501
        """get_work_revision  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_work_revision_with_http_info(rev_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str rev_id: UUID (lower-case, dash-separated, hex-encoded 128-bit) (required)
        :param str expand: List of sub-entities to expand in response. See `get_work`, though note that identifier-based expansions like `releases` will always be empty for revisions.
        :param str hide: List of entity fields to elide in response. See `get_work`.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(WorkEntity, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['rev_id', 'expand', 'hide']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_work_revision" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'rev_id' is set
        if ('rev_id' not in local_var_params or
                local_var_params['rev_id'] is None):
            raise ApiValueError("Missing the required parameter `rev_id` when calling `get_work_revision`")  # noqa: E501

        if ('rev_id' in local_var_params and
                len(local_var_params['rev_id']) > 36):
            raise ApiValueError("Invalid value for parameter `rev_id` when calling `get_work_revision`, length must be less than or equal to `36`")  # noqa: E501
        if ('rev_id' in local_var_params and
                len(local_var_params['rev_id']) < 36):
            raise ApiValueError("Invalid value for parameter `rev_id` when calling `get_work_revision`, length must be greater than or equal to `36`")  # noqa: E501
        if 'rev_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['rev_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `rev_id` when calling `get_work_revision`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'rev_id' in local_var_params:
            path_params['rev_id'] = local_var_params['rev_id']  # noqa: E501

        query_params = []
        if 'expand' in local_var_params:
            query_params.append(('expand', local_var_params['expand']))  # noqa: E501
        if 'hide' in local_var_params:
            query_params.append(('hide', local_var_params['hide']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/work/rev/{rev_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WorkEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def lookup_container(self, **kwargs):  # noqa: E501
        """lookup_container  # noqa: E501

        Looks for an active entity with the given external identifier. If any such entity is found, returns a single complete entity. If multiple entities have the same external identifier, this is considered a soft catalog error, and the behavior of which entity is returned is undefined.  One (and only one) external identifier should be specified per request.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.lookup_container(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str issnl: Linking ISSN (ISSN-L); will be one of either ISSN-E or ISSN-P
        :param str issne: Electronic ISSN (ISSN-L)
        :param str issnp: Print ISSN (ISSN-P)
        :param str issn: Any of ISSN-L, ISSN-E, or ISSN-P
        :param str wikidata_qid:
        :param str expand: List of sub-entities to expand in response. See `get_container`.
        :param str hide: List of entity fields to elide in response. See `get_container`.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ContainerEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.lookup_container_with_http_info(**kwargs)  # noqa: E501

    def lookup_container_with_http_info(self, **kwargs):  # noqa: E501
        """lookup_container  # noqa: E501

        Looks for an active entity with the given external identifier. If any such entity is found, returns a single complete entity. If multiple entities have the same external identifier, this is considered a soft catalog error, and the behavior of which entity is returned is undefined.  One (and only one) external identifier should be specified per request.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.lookup_container_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str issnl: Linking ISSN (ISSN-L); will be one of either ISSN-E or ISSN-P
        :param str issne: Electronic ISSN (ISSN-L)
        :param str issnp: Print ISSN (ISSN-P)
        :param str issn: Any of ISSN-L, ISSN-E, or ISSN-P
        :param str wikidata_qid:
        :param str expand: List of sub-entities to expand in response. See `get_container`.
        :param str hide: List of entity fields to elide in response. See `get_container`.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ContainerEntity, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['issnl', 'issne', 'issnp', 'issn', 'wikidata_qid', 'expand', 'hide']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method lookup_container" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if ('issnl' in local_var_params and
                len(local_var_params['issnl']) > 9):
            raise ApiValueError("Invalid value for parameter `issnl` when calling `lookup_container`, length must be less than or equal to `9`")  # noqa: E501
        if ('issnl' in local_var_params and
                len(local_var_params['issnl']) < 9):
            raise ApiValueError("Invalid value for parameter `issnl` when calling `lookup_container`, length must be greater than or equal to `9`")  # noqa: E501
        if 'issnl' in local_var_params and not re.search(r'\d{4}-\d{3}[0-9X]', local_var_params['issnl']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `issnl` when calling `lookup_container`, must conform to the pattern `/\d{4}-\d{3}[0-9X]/`")  # noqa: E501
        if ('issne' in local_var_params and
                len(local_var_params['issne']) > 9):
            raise ApiValueError("Invalid value for parameter `issne` when calling `lookup_container`, length must be less than or equal to `9`")  # noqa: E501
        if ('issne' in local_var_params and
                len(local_var_params['issne']) < 9):
            raise ApiValueError("Invalid value for parameter `issne` when calling `lookup_container`, length must be greater than or equal to `9`")  # noqa: E501
        if 'issne' in local_var_params and not re.search(r'\d{4}-\d{3}[0-9X]', local_var_params['issne']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `issne` when calling `lookup_container`, must conform to the pattern `/\d{4}-\d{3}[0-9X]/`")  # noqa: E501
        if ('issnp' in local_var_params and
                len(local_var_params['issnp']) > 9):
            raise ApiValueError("Invalid value for parameter `issnp` when calling `lookup_container`, length must be less than or equal to `9`")  # noqa: E501
        if ('issnp' in local_var_params and
                len(local_var_params['issnp']) < 9):
            raise ApiValueError("Invalid value for parameter `issnp` when calling `lookup_container`, length must be greater than or equal to `9`")  # noqa: E501
        if 'issnp' in local_var_params and not re.search(r'\d{4}-\d{3}[0-9X]', local_var_params['issnp']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `issnp` when calling `lookup_container`, must conform to the pattern `/\d{4}-\d{3}[0-9X]/`")  # noqa: E501
        if ('issn' in local_var_params and
                len(local_var_params['issn']) > 9):
            raise ApiValueError("Invalid value for parameter `issn` when calling `lookup_container`, length must be less than or equal to `9`")  # noqa: E501
        if ('issn' in local_var_params and
                len(local_var_params['issn']) < 9):
            raise ApiValueError("Invalid value for parameter `issn` when calling `lookup_container`, length must be greater than or equal to `9`")  # noqa: E501
        if 'issn' in local_var_params and not re.search(r'\d{4}-\d{3}[0-9X]', local_var_params['issn']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `issn` when calling `lookup_container`, must conform to the pattern `/\d{4}-\d{3}[0-9X]/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'issnl' in local_var_params:
            query_params.append(('issnl', local_var_params['issnl']))  # noqa: E501
        if 'issne' in local_var_params:
            query_params.append(('issne', local_var_params['issne']))  # noqa: E501
        if 'issnp' in local_var_params:
            query_params.append(('issnp', local_var_params['issnp']))  # noqa: E501
        if 'issn' in local_var_params:
            query_params.append(('issn', local_var_params['issn']))  # noqa: E501
        if 'wikidata_qid' in local_var_params:
            query_params.append(('wikidata_qid', local_var_params['wikidata_qid']))  # noqa: E501
        if 'expand' in local_var_params:
            query_params.append(('expand', local_var_params['expand']))  # noqa: E501
        if 'hide' in local_var_params:
            query_params.append(('hide', local_var_params['hide']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/container/lookup', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ContainerEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def lookup_creator(self, **kwargs):  # noqa: E501
        """lookup_creator  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.lookup_creator(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str orcid: ORCiD (https://orcid.org) identifier
        :param str wikidata_qid:
        :param str expand: List of sub-entities to expand in response. See `get_creator`.
        :param str hide: List of entity fields to elide in response. See `get_creator`.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CreatorEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.lookup_creator_with_http_info(**kwargs)  # noqa: E501

    def lookup_creator_with_http_info(self, **kwargs):  # noqa: E501
        """lookup_creator  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.lookup_creator_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str orcid: ORCiD (https://orcid.org) identifier
        :param str wikidata_qid:
        :param str expand: List of sub-entities to expand in response. See `get_creator`.
        :param str hide: List of entity fields to elide in response. See `get_creator`.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CreatorEntity, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['orcid', 'wikidata_qid', 'expand', 'hide']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method lookup_creator" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if ('orcid' in local_var_params and
                len(local_var_params['orcid']) > 19):
            raise ApiValueError("Invalid value for parameter `orcid` when calling `lookup_creator`, length must be less than or equal to `19`")  # noqa: E501
        if ('orcid' in local_var_params and
                len(local_var_params['orcid']) < 19):
            raise ApiValueError("Invalid value for parameter `orcid` when calling `lookup_creator`, length must be greater than or equal to `19`")  # noqa: E501
        if 'orcid' in local_var_params and not re.search(r'\d{4}-\d{4}-\d{4}-\d{3}[\dX]', local_var_params['orcid']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `orcid` when calling `lookup_creator`, must conform to the pattern `/\d{4}-\d{4}-\d{4}-\d{3}[\dX]/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'orcid' in local_var_params:
            query_params.append(('orcid', local_var_params['orcid']))  # noqa: E501
        if 'wikidata_qid' in local_var_params:
            query_params.append(('wikidata_qid', local_var_params['wikidata_qid']))  # noqa: E501
        if 'expand' in local_var_params:
            query_params.append(('expand', local_var_params['expand']))  # noqa: E501
        if 'hide' in local_var_params:
            query_params.append(('hide', local_var_params['hide']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/creator/lookup', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreatorEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def lookup_editor(self, **kwargs):  # noqa: E501
        """lookup_editor  # noqa: E501

        Fetches editor by, eg, username.  One (and only one) lookup identifier should be specified per request.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.lookup_editor(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str username:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Editor
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.lookup_editor_with_http_info(**kwargs)  # noqa: E501

    def lookup_editor_with_http_info(self, **kwargs):  # noqa: E501
        """lookup_editor  # noqa: E501

        Fetches editor by, eg, username.  One (and only one) lookup identifier should be specified per request.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.lookup_editor_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str username:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Editor, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['username']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method lookup_editor" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'username' in local_var_params:
            query_params.append(('username', local_var_params['username']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/editor/lookup', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Editor',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def lookup_file(self, **kwargs):  # noqa: E501
        """lookup_file  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.lookup_file(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str md5: MD5 hash of data, in hex encoding
        :param str sha1: SHA-1 hash of data, in hex encoding
        :param str sha256: SHA-256 hash of data, in hex encoding
        :param str expand: List of sub-entities to expand in response. See `get_file`.
        :param str hide: List of entity fields to elide in response. See `get_file`.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FileEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.lookup_file_with_http_info(**kwargs)  # noqa: E501

    def lookup_file_with_http_info(self, **kwargs):  # noqa: E501
        """lookup_file  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.lookup_file_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str md5: MD5 hash of data, in hex encoding
        :param str sha1: SHA-1 hash of data, in hex encoding
        :param str sha256: SHA-256 hash of data, in hex encoding
        :param str expand: List of sub-entities to expand in response. See `get_file`.
        :param str hide: List of entity fields to elide in response. See `get_file`.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FileEntity, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['md5', 'sha1', 'sha256', 'expand', 'hide']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method lookup_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if ('md5' in local_var_params and
                len(local_var_params['md5']) > 32):
            raise ApiValueError("Invalid value for parameter `md5` when calling `lookup_file`, length must be less than or equal to `32`")  # noqa: E501
        if ('md5' in local_var_params and
                len(local_var_params['md5']) < 32):
            raise ApiValueError("Invalid value for parameter `md5` when calling `lookup_file`, length must be greater than or equal to `32`")  # noqa: E501
        if 'md5' in local_var_params and not re.search(r'[a-f0-9]{32}', local_var_params['md5']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `md5` when calling `lookup_file`, must conform to the pattern `/[a-f0-9]{32}/`")  # noqa: E501
        if ('sha1' in local_var_params and
                len(local_var_params['sha1']) > 40):
            raise ApiValueError("Invalid value for parameter `sha1` when calling `lookup_file`, length must be less than or equal to `40`")  # noqa: E501
        if ('sha1' in local_var_params and
                len(local_var_params['sha1']) < 40):
            raise ApiValueError("Invalid value for parameter `sha1` when calling `lookup_file`, length must be greater than or equal to `40`")  # noqa: E501
        if 'sha1' in local_var_params and not re.search(r'[a-f0-9]{40}', local_var_params['sha1']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `sha1` when calling `lookup_file`, must conform to the pattern `/[a-f0-9]{40}/`")  # noqa: E501
        if ('sha256' in local_var_params and
                len(local_var_params['sha256']) > 64):
            raise ApiValueError("Invalid value for parameter `sha256` when calling `lookup_file`, length must be less than or equal to `64`")  # noqa: E501
        if ('sha256' in local_var_params and
                len(local_var_params['sha256']) < 64):
            raise ApiValueError("Invalid value for parameter `sha256` when calling `lookup_file`, length must be greater than or equal to `64`")  # noqa: E501
        if 'sha256' in local_var_params and not re.search(r'[a-f0-9]{64}', local_var_params['sha256']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `sha256` when calling `lookup_file`, must conform to the pattern `/[a-f0-9]{64}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'md5' in local_var_params:
            query_params.append(('md5', local_var_params['md5']))  # noqa: E501
        if 'sha1' in local_var_params:
            query_params.append(('sha1', local_var_params['sha1']))  # noqa: E501
        if 'sha256' in local_var_params:
            query_params.append(('sha256', local_var_params['sha256']))  # noqa: E501
        if 'expand' in local_var_params:
            query_params.append(('expand', local_var_params['expand']))  # noqa: E501
        if 'hide' in local_var_params:
            query_params.append(('hide', local_var_params['hide']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/file/lookup', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def lookup_release(self, **kwargs):  # noqa: E501
        """lookup_release  # noqa: E501

        Looks for an active entity with the given external identifier. If any such entity is found, returns a single complete entity. If multiple entities have the same external identifier, this is considered a soft catalog error, and the behavior of which entity is returned is undefined.  One (and only one) external identifier should be specified per request.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.lookup_release(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str doi:
        :param str wikidata_qid:
        :param str isbn13:
        :param str pmid:
        :param str pmcid:
        :param str core:
        :param str arxiv:
        :param str jstor:
        :param str ark:
        :param str mag:
        :param str doaj:
        :param str dblp:
        :param str oai:
        :param str hdl:
        :param str expand: List of sub-entities to expand in response. See `get_release`.
        :param str hide: List of sub-entities to elide in response. See `get_release`.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ReleaseEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.lookup_release_with_http_info(**kwargs)  # noqa: E501

    def lookup_release_with_http_info(self, **kwargs):  # noqa: E501
        """lookup_release  # noqa: E501

        Looks for an active entity with the given external identifier. If any such entity is found, returns a single complete entity. If multiple entities have the same external identifier, this is considered a soft catalog error, and the behavior of which entity is returned is undefined.  One (and only one) external identifier should be specified per request.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.lookup_release_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str doi:
        :param str wikidata_qid:
        :param str isbn13:
        :param str pmid:
        :param str pmcid:
        :param str core:
        :param str arxiv:
        :param str jstor:
        :param str ark:
        :param str mag:
        :param str doaj:
        :param str dblp:
        :param str oai:
        :param str hdl:
        :param str expand: List of sub-entities to expand in response. See `get_release`.
        :param str hide: List of sub-entities to elide in response. See `get_release`.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ReleaseEntity, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['doi', 'wikidata_qid', 'isbn13', 'pmid', 'pmcid', 'core', 'arxiv', 'jstor', 'ark', 'mag', 'doaj', 'dblp', 'oai', 'hdl', 'expand', 'hide']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method lookup_release" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'doi' in local_var_params:
            query_params.append(('doi', local_var_params['doi']))  # noqa: E501
        if 'wikidata_qid' in local_var_params:
            query_params.append(('wikidata_qid', local_var_params['wikidata_qid']))  # noqa: E501
        if 'isbn13' in local_var_params:
            query_params.append(('isbn13', local_var_params['isbn13']))  # noqa: E501
        if 'pmid' in local_var_params:
            query_params.append(('pmid', local_var_params['pmid']))  # noqa: E501
        if 'pmcid' in local_var_params:
            query_params.append(('pmcid', local_var_params['pmcid']))  # noqa: E501
        if 'core' in local_var_params:
            query_params.append(('core', local_var_params['core']))  # noqa: E501
        if 'arxiv' in local_var_params:
            query_params.append(('arxiv', local_var_params['arxiv']))  # noqa: E501
        if 'jstor' in local_var_params:
            query_params.append(('jstor', local_var_params['jstor']))  # noqa: E501
        if 'ark' in local_var_params:
            query_params.append(('ark', local_var_params['ark']))  # noqa: E501
        if 'mag' in local_var_params:
            query_params.append(('mag', local_var_params['mag']))  # noqa: E501
        if 'doaj' in local_var_params:
            query_params.append(('doaj', local_var_params['doaj']))  # noqa: E501
        if 'dblp' in local_var_params:
            query_params.append(('dblp', local_var_params['dblp']))  # noqa: E501
        if 'oai' in local_var_params:
            query_params.append(('oai', local_var_params['oai']))  # noqa: E501
        if 'hdl' in local_var_params:
            query_params.append(('hdl', local_var_params['hdl']))  # noqa: E501
        if 'expand' in local_var_params:
            query_params.append(('expand', local_var_params['expand']))  # noqa: E501
        if 'hide' in local_var_params:
            query_params.append(('hide', local_var_params['hide']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/release/lookup', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReleaseEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_container(self, editgroup_id, ident, entity, **kwargs):  # noqa: E501
        """update_container  # noqa: E501

        Updates an existing entity as part of a specific (existing) editgroup. The editgroup must be open for updates (aka, not accepted/merged), and the editor making the request must have permissions (aka, must have created the editgroup or have `admin` role).  This method can also be used to update an existing entity edit as part of an editgroup. For example, if an entity was created in this editgroup, an editor could make changes to the new entity's metadata before merging.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_container(editgroup_id, ident, entity, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param str ident: (required)
        :param ContainerEntity entity: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EntityEdit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_container_with_http_info(editgroup_id, ident, entity, **kwargs)  # noqa: E501

    def update_container_with_http_info(self, editgroup_id, ident, entity, **kwargs):  # noqa: E501
        """update_container  # noqa: E501

        Updates an existing entity as part of a specific (existing) editgroup. The editgroup must be open for updates (aka, not accepted/merged), and the editor making the request must have permissions (aka, must have created the editgroup or have `admin` role).  This method can also be used to update an existing entity edit as part of an editgroup. For example, if an entity was created in this editgroup, an editor could make changes to the new entity's metadata before merging.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_container_with_http_info(editgroup_id, ident, entity, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param str ident: (required)
        :param ContainerEntity entity: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EntityEdit, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['editgroup_id', 'ident', 'entity']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_container" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'editgroup_id' is set
        if ('editgroup_id' not in local_var_params or
                local_var_params['editgroup_id'] is None):
            raise ApiValueError("Missing the required parameter `editgroup_id` when calling `update_container`")  # noqa: E501
        # verify the required parameter 'ident' is set
        if ('ident' not in local_var_params or
                local_var_params['ident'] is None):
            raise ApiValueError("Missing the required parameter `ident` when calling `update_container`")  # noqa: E501
        # verify the required parameter 'entity' is set
        if ('entity' not in local_var_params or
                local_var_params['entity'] is None):
            raise ApiValueError("Missing the required parameter `entity` when calling `update_container`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'editgroup_id' in local_var_params:
            path_params['editgroup_id'] = local_var_params['editgroup_id']  # noqa: E501
        if 'ident' in local_var_params:
            path_params['ident'] = local_var_params['ident']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'entity' in local_var_params:
            body_params = local_var_params['entity']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/editgroup/{editgroup_id}/container/{ident}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EntityEdit',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_creator(self, editgroup_id, ident, entity, **kwargs):  # noqa: E501
        """update_creator  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_creator(editgroup_id, ident, entity, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param str ident: (required)
        :param CreatorEntity entity: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EntityEdit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_creator_with_http_info(editgroup_id, ident, entity, **kwargs)  # noqa: E501

    def update_creator_with_http_info(self, editgroup_id, ident, entity, **kwargs):  # noqa: E501
        """update_creator  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_creator_with_http_info(editgroup_id, ident, entity, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param str ident: (required)
        :param CreatorEntity entity: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EntityEdit, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['editgroup_id', 'ident', 'entity']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_creator" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'editgroup_id' is set
        if ('editgroup_id' not in local_var_params or
                local_var_params['editgroup_id'] is None):
            raise ApiValueError("Missing the required parameter `editgroup_id` when calling `update_creator`")  # noqa: E501
        # verify the required parameter 'ident' is set
        if ('ident' not in local_var_params or
                local_var_params['ident'] is None):
            raise ApiValueError("Missing the required parameter `ident` when calling `update_creator`")  # noqa: E501
        # verify the required parameter 'entity' is set
        if ('entity' not in local_var_params or
                local_var_params['entity'] is None):
            raise ApiValueError("Missing the required parameter `entity` when calling `update_creator`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'editgroup_id' in local_var_params:
            path_params['editgroup_id'] = local_var_params['editgroup_id']  # noqa: E501
        if 'ident' in local_var_params:
            path_params['ident'] = local_var_params['ident']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'entity' in local_var_params:
            body_params = local_var_params['entity']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/editgroup/{editgroup_id}/creator/{ident}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EntityEdit',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_editgroup(self, editgroup_id, editgroup, **kwargs):  # noqa: E501
        """update_editgroup  # noqa: E501

        Updates metadata for a single editgroup object. Note that only metadata fields such as the `description` or `extra` metadata can be changed with this method; it does not allow adding or removing edits to the editgroup (for that use the individual entity create/update/delete methods).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_editgroup(editgroup_id, editgroup, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: base32-encoded unique identifier (required)
        :param Editgroup editgroup: (required)
        :param bool submit:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Editgroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_editgroup_with_http_info(editgroup_id, editgroup, **kwargs)  # noqa: E501

    def update_editgroup_with_http_info(self, editgroup_id, editgroup, **kwargs):  # noqa: E501
        """update_editgroup  # noqa: E501

        Updates metadata for a single editgroup object. Note that only metadata fields such as the `description` or `extra` metadata can be changed with this method; it does not allow adding or removing edits to the editgroup (for that use the individual entity create/update/delete methods).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_editgroup_with_http_info(editgroup_id, editgroup, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: base32-encoded unique identifier (required)
        :param Editgroup editgroup: (required)
        :param bool submit:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Editgroup, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['editgroup_id', 'editgroup', 'submit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_editgroup" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'editgroup_id' is set
        if ('editgroup_id' not in local_var_params or
                local_var_params['editgroup_id'] is None):
            raise ApiValueError("Missing the required parameter `editgroup_id` when calling `update_editgroup`")  # noqa: E501
        # verify the required parameter 'editgroup' is set
        if ('editgroup' not in local_var_params or
                local_var_params['editgroup'] is None):
            raise ApiValueError("Missing the required parameter `editgroup` when calling `update_editgroup`")  # noqa: E501

        if ('editgroup_id' in local_var_params and
                len(local_var_params['editgroup_id']) > 26):
            raise ApiValueError("Invalid value for parameter `editgroup_id` when calling `update_editgroup`, length must be less than or equal to `26`")  # noqa: E501
        if ('editgroup_id' in local_var_params and
                len(local_var_params['editgroup_id']) < 26):
            raise ApiValueError("Invalid value for parameter `editgroup_id` when calling `update_editgroup`, length must be greater than or equal to `26`")  # noqa: E501
        if 'editgroup_id' in local_var_params and not re.search(r'[a-zA-Z2-7]{26}', local_var_params['editgroup_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `editgroup_id` when calling `update_editgroup`, must conform to the pattern `/[a-zA-Z2-7]{26}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'editgroup_id' in local_var_params:
            path_params['editgroup_id'] = local_var_params['editgroup_id']  # noqa: E501

        query_params = []
        if 'submit' in local_var_params:
            query_params.append(('submit', local_var_params['submit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'editgroup' in local_var_params:
            body_params = local_var_params['editgroup']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/editgroup/{editgroup_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Editgroup',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_editor(self, editor_id, editor, **kwargs):  # noqa: E501
        """update_editor  # noqa: E501

        Allows metadata changes to some editor fields, such as the username.  Changes require authentication and permissions. An editor can change their own username; changes to role flags require the `admin` role by the editor making the request.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_editor(editor_id, editor, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editor_id: (required)
        :param Editor editor: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Editor
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_editor_with_http_info(editor_id, editor, **kwargs)  # noqa: E501

    def update_editor_with_http_info(self, editor_id, editor, **kwargs):  # noqa: E501
        """update_editor  # noqa: E501

        Allows metadata changes to some editor fields, such as the username.  Changes require authentication and permissions. An editor can change their own username; changes to role flags require the `admin` role by the editor making the request.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_editor_with_http_info(editor_id, editor, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editor_id: (required)
        :param Editor editor: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Editor, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['editor_id', 'editor']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_editor" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'editor_id' is set
        if ('editor_id' not in local_var_params or
                local_var_params['editor_id'] is None):
            raise ApiValueError("Missing the required parameter `editor_id` when calling `update_editor`")  # noqa: E501
        # verify the required parameter 'editor' is set
        if ('editor' not in local_var_params or
                local_var_params['editor'] is None):
            raise ApiValueError("Missing the required parameter `editor` when calling `update_editor`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'editor_id' in local_var_params:
            path_params['editor_id'] = local_var_params['editor_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'editor' in local_var_params:
            body_params = local_var_params['editor']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/editor/{editor_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Editor',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_file(self, editgroup_id, ident, entity, **kwargs):  # noqa: E501
        """update_file  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_file(editgroup_id, ident, entity, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param str ident: (required)
        :param FileEntity entity: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EntityEdit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_file_with_http_info(editgroup_id, ident, entity, **kwargs)  # noqa: E501

    def update_file_with_http_info(self, editgroup_id, ident, entity, **kwargs):  # noqa: E501
        """update_file  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_file_with_http_info(editgroup_id, ident, entity, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param str ident: (required)
        :param FileEntity entity: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EntityEdit, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['editgroup_id', 'ident', 'entity']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'editgroup_id' is set
        if ('editgroup_id' not in local_var_params or
                local_var_params['editgroup_id'] is None):
            raise ApiValueError("Missing the required parameter `editgroup_id` when calling `update_file`")  # noqa: E501
        # verify the required parameter 'ident' is set
        if ('ident' not in local_var_params or
                local_var_params['ident'] is None):
            raise ApiValueError("Missing the required parameter `ident` when calling `update_file`")  # noqa: E501
        # verify the required parameter 'entity' is set
        if ('entity' not in local_var_params or
                local_var_params['entity'] is None):
            raise ApiValueError("Missing the required parameter `entity` when calling `update_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'editgroup_id' in local_var_params:
            path_params['editgroup_id'] = local_var_params['editgroup_id']  # noqa: E501
        if 'ident' in local_var_params:
            path_params['ident'] = local_var_params['ident']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'entity' in local_var_params:
            body_params = local_var_params['entity']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/editgroup/{editgroup_id}/file/{ident}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EntityEdit',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_fileset(self, editgroup_id, ident, entity, **kwargs):  # noqa: E501
        """update_fileset  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_fileset(editgroup_id, ident, entity, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param str ident: (required)
        :param FilesetEntity entity: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EntityEdit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_fileset_with_http_info(editgroup_id, ident, entity, **kwargs)  # noqa: E501

    def update_fileset_with_http_info(self, editgroup_id, ident, entity, **kwargs):  # noqa: E501
        """update_fileset  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_fileset_with_http_info(editgroup_id, ident, entity, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param str ident: (required)
        :param FilesetEntity entity: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EntityEdit, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['editgroup_id', 'ident', 'entity']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_fileset" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'editgroup_id' is set
        if ('editgroup_id' not in local_var_params or
                local_var_params['editgroup_id'] is None):
            raise ApiValueError("Missing the required parameter `editgroup_id` when calling `update_fileset`")  # noqa: E501
        # verify the required parameter 'ident' is set
        if ('ident' not in local_var_params or
                local_var_params['ident'] is None):
            raise ApiValueError("Missing the required parameter `ident` when calling `update_fileset`")  # noqa: E501
        # verify the required parameter 'entity' is set
        if ('entity' not in local_var_params or
                local_var_params['entity'] is None):
            raise ApiValueError("Missing the required parameter `entity` when calling `update_fileset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'editgroup_id' in local_var_params:
            path_params['editgroup_id'] = local_var_params['editgroup_id']  # noqa: E501
        if 'ident' in local_var_params:
            path_params['ident'] = local_var_params['ident']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'entity' in local_var_params:
            body_params = local_var_params['entity']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/editgroup/{editgroup_id}/fileset/{ident}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EntityEdit',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_release(self, editgroup_id, ident, entity, **kwargs):  # noqa: E501
        """update_release  # noqa: E501

        Updates an existing entity as part of a specific (existing) editgroup. The editgroup must be open for updates (aka, not accepted/merged), and the editor making the requiest must have permissions (aka, must have created the editgroup or have `admin` role).  This method can also be used to update an existing entity edit as part of an editgroup. For example, if an entity was created in this editgroup, an editor could make changes to the new entity's metadata before merging.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_release(editgroup_id, ident, entity, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param str ident: (required)
        :param ReleaseEntity entity: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EntityEdit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_release_with_http_info(editgroup_id, ident, entity, **kwargs)  # noqa: E501

    def update_release_with_http_info(self, editgroup_id, ident, entity, **kwargs):  # noqa: E501
        """update_release  # noqa: E501

        Updates an existing entity as part of a specific (existing) editgroup. The editgroup must be open for updates (aka, not accepted/merged), and the editor making the requiest must have permissions (aka, must have created the editgroup or have `admin` role).  This method can also be used to update an existing entity edit as part of an editgroup. For example, if an entity was created in this editgroup, an editor could make changes to the new entity's metadata before merging.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_release_with_http_info(editgroup_id, ident, entity, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param str ident: (required)
        :param ReleaseEntity entity: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EntityEdit, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['editgroup_id', 'ident', 'entity']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_release" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'editgroup_id' is set
        if ('editgroup_id' not in local_var_params or
                local_var_params['editgroup_id'] is None):
            raise ApiValueError("Missing the required parameter `editgroup_id` when calling `update_release`")  # noqa: E501
        # verify the required parameter 'ident' is set
        if ('ident' not in local_var_params or
                local_var_params['ident'] is None):
            raise ApiValueError("Missing the required parameter `ident` when calling `update_release`")  # noqa: E501
        # verify the required parameter 'entity' is set
        if ('entity' not in local_var_params or
                local_var_params['entity'] is None):
            raise ApiValueError("Missing the required parameter `entity` when calling `update_release`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'editgroup_id' in local_var_params:
            path_params['editgroup_id'] = local_var_params['editgroup_id']  # noqa: E501
        if 'ident' in local_var_params:
            path_params['ident'] = local_var_params['ident']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'entity' in local_var_params:
            body_params = local_var_params['entity']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/editgroup/{editgroup_id}/release/{ident}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EntityEdit',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_webcapture(self, editgroup_id, ident, entity, **kwargs):  # noqa: E501
        """update_webcapture  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_webcapture(editgroup_id, ident, entity, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param str ident: (required)
        :param WebcaptureEntity entity: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EntityEdit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_webcapture_with_http_info(editgroup_id, ident, entity, **kwargs)  # noqa: E501

    def update_webcapture_with_http_info(self, editgroup_id, ident, entity, **kwargs):  # noqa: E501
        """update_webcapture  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_webcapture_with_http_info(editgroup_id, ident, entity, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param str ident: (required)
        :param WebcaptureEntity entity: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EntityEdit, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['editgroup_id', 'ident', 'entity']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_webcapture" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'editgroup_id' is set
        if ('editgroup_id' not in local_var_params or
                local_var_params['editgroup_id'] is None):
            raise ApiValueError("Missing the required parameter `editgroup_id` when calling `update_webcapture`")  # noqa: E501
        # verify the required parameter 'ident' is set
        if ('ident' not in local_var_params or
                local_var_params['ident'] is None):
            raise ApiValueError("Missing the required parameter `ident` when calling `update_webcapture`")  # noqa: E501
        # verify the required parameter 'entity' is set
        if ('entity' not in local_var_params or
                local_var_params['entity'] is None):
            raise ApiValueError("Missing the required parameter `entity` when calling `update_webcapture`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'editgroup_id' in local_var_params:
            path_params['editgroup_id'] = local_var_params['editgroup_id']  # noqa: E501
        if 'ident' in local_var_params:
            path_params['ident'] = local_var_params['ident']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'entity' in local_var_params:
            body_params = local_var_params['entity']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/editgroup/{editgroup_id}/webcapture/{ident}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EntityEdit',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_work(self, editgroup_id, ident, entity, **kwargs):  # noqa: E501
        """update_work  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_work(editgroup_id, ident, entity, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param str ident: (required)
        :param WorkEntity entity: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EntityEdit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_work_with_http_info(editgroup_id, ident, entity, **kwargs)  # noqa: E501

    def update_work_with_http_info(self, editgroup_id, ident, entity, **kwargs):  # noqa: E501
        """update_work  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_work_with_http_info(editgroup_id, ident, entity, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str editgroup_id: (required)
        :param str ident: (required)
        :param WorkEntity entity: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EntityEdit, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['editgroup_id', 'ident', 'entity']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_work" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'editgroup_id' is set
        if ('editgroup_id' not in local_var_params or
                local_var_params['editgroup_id'] is None):
            raise ApiValueError("Missing the required parameter `editgroup_id` when calling `update_work`")  # noqa: E501
        # verify the required parameter 'ident' is set
        if ('ident' not in local_var_params or
                local_var_params['ident'] is None):
            raise ApiValueError("Missing the required parameter `ident` when calling `update_work`")  # noqa: E501
        # verify the required parameter 'entity' is set
        if ('entity' not in local_var_params or
                local_var_params['entity'] is None):
            raise ApiValueError("Missing the required parameter `entity` when calling `update_work`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'editgroup_id' in local_var_params:
            path_params['editgroup_id'] = local_var_params['editgroup_id']  # noqa: E501
        if 'ident' in local_var_params:
            path_params['ident'] = local_var_params['ident']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'entity' in local_var_params:
            body_params = local_var_params['entity']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/editgroup/{editgroup_id}/work/{ident}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EntityEdit',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
